/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.shade.org.apache.avro.file.DataFileStream;
import org.apache.paimon.shade.org.apache.avro.generic.GenericDatumReader;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class AvroTableStatsExtractor
implements TableStatsExtractor {
    private final RowType rowType;
    private final FieldStatsCollector.Factory[] statsCollectors;

    public AvroTableStatsExtractor(RowType rowType, FieldStatsCollector.Factory[] statsCollectors) {
        this.rowType = rowType;
        this.statsCollectors = statsCollectors;
        Preconditions.checkArgument((rowType.getFieldCount() == statsCollectors.length ? 1 : 0) != 0, (Object)"The stats collector is not aligned to write schema.");
    }

    public FieldStats[] extract(FileIO fileIO, Path path) throws IOException {
        return (FieldStats[])this.extractWithFileInfo(fileIO, path).getLeft();
    }

    public Pair<FieldStats[], TableStatsExtractor.FileInfo> extractWithFileInfo(FileIO fileIO, Path path) throws IOException {
        SeekableInputStream fileInputStream = fileIO.newInputStream(path);
        long rowCount = this.getRowCount((InputStream)fileInputStream);
        return Pair.of(IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> new FieldStats(null, null, null)).toArray(FieldStats[]::new), (Object)new TableStatsExtractor.FileInfo(rowCount));
    }

    private long getRowCount(InputStream inStream) throws IOException {
        long count = 0L;
        try (DataFileStream streamReader = new DataFileStream(inStream, new GenericDatumReader());){
            while (streamReader.hasNext()) {
                count += streamReader.getBlockCount();
                streamReader.nextBlock();
            }
        }
        return count;
    }
}

