/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.HeapBooleanVector;
import org.apache.paimon.data.columnar.heap.HeapByteVector;
import org.apache.paimon.data.columnar.heap.HeapBytesVector;
import org.apache.paimon.data.columnar.heap.HeapDoubleVector;
import org.apache.paimon.data.columnar.heap.HeapFloatVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.heap.HeapLongVector;
import org.apache.paimon.data.columnar.heap.HeapShortVector;
import org.apache.paimon.data.columnar.heap.HeapTimestampVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.position.LevelDelegation;
import org.apache.paimon.format.parquet.reader.ColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReaderFactory;
import org.apache.paimon.format.parquet.reader.ParquetDecimalVector;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesInput;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.Encoding;
import org.apache.paimon.shade.org.apache.parquet.column.ValuesType;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV1;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV2;
import org.apache.paimon.shade.org.apache.parquet.column.page.DictionaryPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.IntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedPrimitiveColumnReader
implements ColumnReader<WritableColumnVector> {
    private static final Logger LOG = LoggerFactory.getLogger(NestedPrimitiveColumnReader.class);
    private final IntArrayList repetitionLevelList = new IntArrayList(0);
    private final IntArrayList definitionLevelList = new IntArrayList(0);
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final Type type;
    private final DataType dataType;
    private final boolean readRowField;
    private final boolean readMapKey;
    private final ParquetDataColumnReader dictionary;
    private final int maxDefLevel;
    private final boolean isUtcTimestamp;
    private long valuesRead;
    private long endOfPageValueCount;
    private boolean isCurrentPageDictionaryEncoded;
    private int definitionLevel;
    private int repetitionLevel;
    private IntIterator repetitionLevelColumn;
    private IntIterator definitionLevelColumn;
    private ParquetDataColumnReader dataColumn;
    private int pageValueCount;
    private boolean eof = false;
    private boolean isFirstRow = true;
    private final LastValueContainer lastValue = new LastValueContainer();

    public NestedPrimitiveColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean isUtcTimestamp, Type parquetType, DataType dataType, boolean readRowField, boolean readMapKey) throws IOException {
        this.descriptor = descriptor;
        this.type = parquetType;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.isUtcTimestamp = isUtcTimestamp;
        this.dataType = dataType;
        this.readRowField = readRowField;
        this.readMapKey = readMapKey;
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = ParquetDataColumnReaderFactory.getDataColumnReaderByTypeOnDictionary(dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage), isUtcTimestamp);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not decode the dictionary for %s", descriptor), e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        throw new UnsupportedOperationException("This function should no be called.");
    }

    public WritableColumnVector readAndNewVector(int readNumber, WritableColumnVector vector) throws IOException {
        if (this.isFirstRow) {
            if (!this.readValue()) {
                return vector;
            }
            this.isFirstRow = false;
        }
        int valueIndex = 0;
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int index = 0; !this.eof && index < readNumber; ++index) {
            do {
                if (this.lastValue.shouldSkip) continue;
                valueList.add(this.lastValue.value);
                ++valueIndex;
            } while (this.readValue() && this.repetitionLevel != 0);
        }
        return this.fillColumnVector(valueIndex, valueList);
    }

    public LevelDelegation getLevelDelegation() {
        int[] repetition = this.repetitionLevelList.toArray();
        int[] definition = this.definitionLevelList.toArray();
        this.repetitionLevelList.clear();
        this.definitionLevelList.clear();
        this.repetitionLevelList.add(this.repetitionLevel);
        this.definitionLevelList.add(this.definitionLevel);
        return new LevelDelegation(repetition, definition);
    }

    private boolean readValue() throws IOException {
        int left = this.readPageIfNeed();
        if (left > 0) {
            this.readAndSaveRepetitionAndDefinitionLevels();
            if (this.definitionLevel == this.maxDefLevel) {
                if (this.isCurrentPageDictionaryEncoded) {
                    int dictionaryId = this.dataColumn.readValueDictionaryId();
                    this.lastValue.setValue(this.dictionaryDecodeValue(this.dataType, dictionaryId));
                } else {
                    this.lastValue.setValue(this.readPrimitiveTypedRow(this.dataType));
                }
            } else if (this.readMapKey) {
                this.lastValue.skip();
            } else if (this.definitionLevel == this.maxDefLevel - 1) {
                this.lastValue.setValue(null);
            } else if (this.definitionLevel == this.maxDefLevel - 2 && this.readRowField) {
                this.lastValue.setValue(null);
            } else {
                this.lastValue.skip();
            }
            return true;
        }
        this.eof = true;
        return false;
    }

    private void readAndSaveRepetitionAndDefinitionLevels() {
        this.repetitionLevel = this.repetitionLevelColumn.nextInt();
        this.definitionLevel = this.definitionLevelColumn.nextInt();
        ++this.valuesRead;
        this.repetitionLevelList.add(this.repetitionLevel);
        this.definitionLevelList.add(this.definitionLevel);
    }

    private int readPageIfNeed() throws IOException {
        int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        if (leftInPage == 0) {
            this.readPage();
            leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        }
        return leftInPage;
    }

    private Object readPrimitiveTypedRow(DataType category) {
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dataColumn.readBytes();
            }
            case BOOLEAN: {
                return this.dataColumn.readBoolean();
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dataColumn.readInteger();
            }
            case TINYINT: {
                return this.dataColumn.readTinyInt();
            }
            case SMALLINT: {
                return this.dataColumn.readSmallInt();
            }
            case BIGINT: {
                return this.dataColumn.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.dataColumn.readFloat());
            }
            case DOUBLE: {
                return this.dataColumn.readDouble();
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dataColumn.readInteger();
                    }
                    case INT64: {
                        return this.dataColumn.readLong();
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dataColumn.readBytes();
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.readTimestamp(((TimestampType)category).getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.readTimestamp(((LocalZonedTimestampType)category).getPrecision());
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private Timestamp readTimestamp(int precision) {
        if (precision <= 3) {
            return this.dataColumn.readMillsTimestamp();
        }
        if (precision <= 6) {
            return this.dataColumn.readMicrosTimestamp();
        }
        return this.dataColumn.readNanosTimestamp();
    }

    private Object dictionaryDecodeValue(DataType category, Integer dictionaryValue) {
        if (dictionaryValue == null) {
            return null;
        }
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dictionary.readBytes(dictionaryValue);
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dictionary.readInteger(dictionaryValue);
            }
            case BOOLEAN: {
                return this.dictionary.readBoolean(dictionaryValue) ? 1 : 0;
            }
            case DOUBLE: {
                return this.dictionary.readDouble(dictionaryValue);
            }
            case FLOAT: {
                return Float.valueOf(this.dictionary.readFloat(dictionaryValue));
            }
            case TINYINT: {
                return this.dictionary.readTinyInt(dictionaryValue);
            }
            case SMALLINT: {
                return this.dictionary.readSmallInt(dictionaryValue);
            }
            case BIGINT: {
                return this.dictionary.readLong(dictionaryValue);
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dictionary.readInteger(dictionaryValue);
                    }
                    case INT64: {
                        return this.dictionary.readLong(dictionaryValue);
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dictionary.readBytes(dictionaryValue);
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.dictionaryReadTimestamp(((TimestampType)category).getPrecision(), dictionaryValue);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dictionaryReadTimestamp(((LocalZonedTimestampType)category).getPrecision(), dictionaryValue);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private Timestamp dictionaryReadTimestamp(int precision, int dictionaryValue) {
        if (precision <= 3) {
            return this.dictionary.readMillsTimestamp(dictionaryValue);
        }
        if (precision <= 6) {
            return this.dictionary.readMicrosTimestamp(dictionaryValue);
        }
        return this.dictionary.readNanosTimestamp(dictionaryValue);
    }

    private WritableColumnVector fillColumnVector(int total, List valueList) {
        switch (this.dataType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                HeapBytesVector heapBytesVector = new HeapBytesVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    byte[] src = (byte[])valueList.get(i);
                    if (src == null) {
                        heapBytesVector.setNullAt(i);
                        continue;
                    }
                    heapBytesVector.appendBytes(i, src, 0, src.length);
                }
                return heapBytesVector;
            }
            case BOOLEAN: {
                HeapBooleanVector heapBooleanVector = new HeapBooleanVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapBooleanVector.setNullAt(i);
                        continue;
                    }
                    heapBooleanVector.vector[i] = (Boolean)valueList.get(i);
                }
                return heapBooleanVector;
            }
            case TINYINT: {
                HeapByteVector heapByteVector = new HeapByteVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapByteVector.setNullAt(i);
                        continue;
                    }
                    heapByteVector.vector[i] = (byte)((Integer)valueList.get(i)).intValue();
                }
                return heapByteVector;
            }
            case SMALLINT: {
                HeapShortVector heapShortVector = new HeapShortVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapShortVector.setNullAt(i);
                        continue;
                    }
                    heapShortVector.vector[i] = (short)((Integer)valueList.get(i)).intValue();
                }
                return heapShortVector;
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                HeapIntVector heapIntVector = new HeapIntVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapIntVector.setNullAt(i);
                        continue;
                    }
                    heapIntVector.vector[i] = (Integer)valueList.get(i);
                }
                return heapIntVector;
            }
            case FLOAT: {
                HeapFloatVector heapFloatVector = new HeapFloatVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapFloatVector.setNullAt(i);
                        continue;
                    }
                    heapFloatVector.vector[i] = ((Float)valueList.get(i)).floatValue();
                }
                return heapFloatVector;
            }
            case BIGINT: {
                HeapLongVector heapLongVector = new HeapLongVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapLongVector.setNullAt(i);
                        continue;
                    }
                    heapLongVector.vector[i] = (Long)valueList.get(i);
                }
                return heapLongVector;
            }
            case DOUBLE: {
                HeapDoubleVector heapDoubleVector = new HeapDoubleVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapDoubleVector.setNullAt(i);
                        continue;
                    }
                    heapDoubleVector.vector[i] = (Double)valueList.get(i);
                }
                return heapDoubleVector;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                HeapTimestampVector heapTimestampVector = new HeapTimestampVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapTimestampVector.setNullAt(i);
                        continue;
                    }
                    heapTimestampVector.setTimestamp(i, (Timestamp)valueList.get(i));
                }
                return heapTimestampVector;
            }
            case DECIMAL: {
                PrimitiveType.PrimitiveTypeName primitiveTypeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                switch (primitiveTypeName) {
                    case INT32: {
                        HeapIntVector phiv = new HeapIntVector(total);
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                phiv.setNullAt(i);
                                continue;
                            }
                            phiv.vector[i] = (Integer)valueList.get(i);
                        }
                        return new ParquetDecimalVector((ColumnVector)phiv);
                    }
                    case INT64: {
                        HeapLongVector phlv = new HeapLongVector(total);
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                phlv.setNullAt(i);
                                continue;
                            }
                            phlv.vector[i] = (Long)valueList.get(i);
                        }
                        return new ParquetDecimalVector((ColumnVector)phlv);
                    }
                }
                HeapBytesVector phbv = NestedPrimitiveColumnReader.getHeapBytesVector(total, valueList);
                return new ParquetDecimalVector((ColumnVector)phbv);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private static HeapBytesVector getHeapBytesVector(int total, List valueList) {
        HeapBytesVector phbv = new HeapBytesVector(total);
        for (int i = 0; i < valueList.size(); ++i) {
            byte[] src = (byte[])valueList.get(i);
            if (valueList.get(i) == null) {
                phbv.setNullAt(i);
                continue;
            }
            phbv.appendBytes(i, src, 0, src.length);
        }
        return phbv;
    }

    protected void readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return;
        }
        page.accept(new DataPage.Visitor<Void>(){

            @Override
            public Void visit(DataPageV1 dataPageV1) {
                NestedPrimitiveColumnReader.this.readPageV1(dataPageV1);
                return null;
            }

            @Override
            public Void visit(DataPageV2 dataPageV2) {
                NestedPrimitiveColumnReader.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) throws IOException {
        this.pageValueCount = valueCount;
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException(String.format("Could not read page in col %s because the dictionary was missing for encoding %s.", new Object[]{this.descriptor, dataEncoding}));
            }
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary.getDictionary()), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not read page in col %s.", this.descriptor), e);
        }
    }

    private void readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        try {
            BytesInput bytes = page.getBytes();
            LOG.debug("Page size {}  bytes and {} records.", (Object)bytes.size(), (Object)this.pageValueCount);
            ByteBufferInputStream in = bytes.toInputStream();
            LOG.debug("Reading repetition levels at {}.", (Object)in.position());
            rlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("Reading definition levels at {}.", (Object)in.position());
            dlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("Reading data at {}.", (Object)in.position());
            this.initDataReader(page.getValueEncoding(), in, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private void readPageV2(DataPageV2 page) {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            LOG.debug("Page data size {} bytes and {} records.", (Object)page.getData().size(), (Object)this.pageValueCount);
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream(), page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt(maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read levels in page for col %s.", this.descriptor), e);
        }
    }

    private static class LastValueContainer {
        protected boolean shouldSkip;
        protected Object value;

        private LastValueContainer() {
        }

        protected void setValue(Object value) {
            this.value = value;
            this.shouldSkip = false;
        }

        protected void skip() {
            this.shouldSkip = true;
        }
    }

    protected static final class NullIntIterator
    implements IntIterator {
        protected NullIntIterator() {
        }

        @Override
        public int nextInt() {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    implements IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }

    protected static final class ValuesReaderIntIterator
    implements IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static interface IntIterator {
        public int nextInt();
    }
}

