/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.filter;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.format.orc.OrcReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.orc.BooleanColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.ColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DateColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DecimalColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DoubleColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.IntegerColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.Reader;
import org.apache.paimon.shade.org.apache.orc.StringColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.TimestampColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class OrcSimpleStatsExtractor
implements SimpleStatsExtractor {
    private final RowType rowType;
    private final SimpleColStatsCollector.Factory[] statsCollectors;

    public OrcSimpleStatsExtractor(RowType rowType, SimpleColStatsCollector.Factory[] statsCollectors) {
        this.rowType = rowType;
        this.statsCollectors = statsCollectors;
        Preconditions.checkArgument((rowType.getFieldCount() == statsCollectors.length ? 1 : 0) != 0, (Object)"The stats collector is not aligned to write schema.");
    }

    public SimpleColStats[] extract(FileIO fileIO, Path path) throws IOException {
        return (SimpleColStats[])this.extractWithFileInfo(fileIO, path).getLeft();
    }

    public Pair<SimpleColStats[], SimpleStatsExtractor.FileInfo> extractWithFileInfo(FileIO fileIO, Path path) throws IOException {
        try (Reader reader = OrcReaderFactory.createReader(new Configuration(), fileIO, path, null);){
            long rowCount = reader.getNumberOfRows();
            ColumnStatistics[] columnStatistics = reader.getStatistics();
            TypeDescription schema = reader.getSchema();
            List<String> columnNames = schema.getFieldNames();
            List<TypeDescription> columnTypes = schema.getChildren();
            SimpleColStatsCollector[] collectors = SimpleColStatsCollector.create((SimpleColStatsCollector.Factory[])this.statsCollectors);
            Pair pair = Pair.of(IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
                DataField field = (DataField)this.rowType.getFields().get(i);
                int fieldIdx = columnNames.indexOf(field.name());
                if (fieldIdx == -1) {
                    return collectors[i].convert(new SimpleColStats(null, null, null));
                }
                int colId = ((TypeDescription)columnTypes.get(fieldIdx)).getId();
                return this.toFieldStats(field, columnStatistics[colId], rowCount, collectors[i]);
            }).toArray(SimpleColStats[]::new), (Object)new SimpleStatsExtractor.FileInfo(rowCount));
            return pair;
        }
    }

    private SimpleColStats toFieldStats(DataField field, ColumnStatistics stats, long rowCount, SimpleColStatsCollector collector) {
        SimpleColStats fieldStats;
        long nullCount = rowCount - stats.getNumberOfValues();
        if (nullCount == rowCount) {
            return collector.convert(new SimpleColStats(null, null, Long.valueOf(nullCount)));
        }
        Preconditions.checkState((nullCount > 0L == stats.hasNull() ? 1 : 0) != 0, (Object)("Bug in OrcFileStatsExtractor: nullCount is " + nullCount + " while stats.hasNull() is " + stats.hasNull() + "!"));
        switch (field.type().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                this.assertStatsClass(field, stats, StringColumnStatistics.class);
                StringColumnStatistics stringStats = (StringColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)BinaryString.fromString((String)stringStats.getMinimum()), (Object)BinaryString.fromString((String)stringStats.getMaximum()), Long.valueOf(nullCount));
                break;
            }
            case BOOLEAN: {
                this.assertStatsClass(field, stats, BooleanColumnStatistics.class);
                BooleanColumnStatistics boolStats = (BooleanColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)(boolStats.getFalseCount() == 0L ? 1 : 0), (Object)(boolStats.getTrueCount() != 0L ? 1 : 0), Long.valueOf(nullCount));
                break;
            }
            case DECIMAL: {
                this.assertStatsClass(field, stats, DecimalColumnStatistics.class);
                DecimalColumnStatistics decimalStats = (DecimalColumnStatistics)stats;
                DecimalType decimalType = (DecimalType)field.type();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                fieldStats = new SimpleColStats((Object)Decimal.fromBigDecimal((BigDecimal)decimalStats.getMinimum().bigDecimalValue(), (int)precision, (int)scale), (Object)Decimal.fromBigDecimal((BigDecimal)decimalStats.getMaximum().bigDecimalValue(), (int)precision, (int)scale), Long.valueOf(nullCount));
                break;
            }
            case TINYINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics byteStats = (IntegerColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)((byte)byteStats.getMinimum()), (Object)((byte)byteStats.getMaximum()), Long.valueOf(nullCount));
                break;
            }
            case SMALLINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics shortStats = (IntegerColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)((short)shortStats.getMinimum()), (Object)((short)shortStats.getMaximum()), Long.valueOf(nullCount));
                break;
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics intStats = (IntegerColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)Long.valueOf(intStats.getMinimum()).intValue(), (Object)Long.valueOf(intStats.getMaximum()).intValue(), Long.valueOf(nullCount));
                break;
            }
            case BIGINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics longStats = (IntegerColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)longStats.getMinimum(), (Object)longStats.getMaximum(), Long.valueOf(nullCount));
                break;
            }
            case FLOAT: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics floatStats = (DoubleColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)Float.valueOf((float)floatStats.getMinimum()), (Object)Float.valueOf((float)floatStats.getMaximum()), Long.valueOf(nullCount));
                break;
            }
            case DOUBLE: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics doubleStats = (DoubleColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)doubleStats.getMinimum(), (Object)doubleStats.getMaximum(), Long.valueOf(nullCount));
                break;
            }
            case DATE: {
                this.assertStatsClass(field, stats, DateColumnStatistics.class);
                DateColumnStatistics dateStats = (DateColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)DateTimeUtils.toInternal((Date)new Date(dateStats.getMinimum().getTime())), (Object)DateTimeUtils.toInternal((Date)new Date(dateStats.getMaximum().getTime())), Long.valueOf(nullCount));
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                this.assertStatsClass(field, stats, TimestampColumnStatistics.class);
                TimestampColumnStatistics timestampStats = (TimestampColumnStatistics)stats;
                fieldStats = new SimpleColStats((Object)org.apache.paimon.data.Timestamp.fromSQLTimestamp((Timestamp)timestampStats.getMinimum()), (Object)org.apache.paimon.data.Timestamp.fromSQLTimestamp((Timestamp)timestampStats.getMaximum()), Long.valueOf(nullCount));
                break;
            }
            default: {
                fieldStats = new SimpleColStats(null, null, Long.valueOf(nullCount));
            }
        }
        return collector.convert(fieldStats);
    }

    private void assertStatsClass(DataField field, ColumnStatistics stats, Class<? extends ColumnStatistics> expectedClass) {
        if (!expectedClass.isInstance(stats)) {
            throw new IllegalArgumentException("Expecting " + expectedClass.getName() + " for field " + field.asSQLString() + " but found " + stats.getClass().getName());
        }
    }
}

