/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.writer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.orc.writer.FieldWriter;
import org.apache.paimon.format.orc.writer.FieldWriterFactory;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;

public class RowDataVectorizer
extends Vectorizer<InternalRow> {
    private final List<FieldWriter> fieldWriters;

    public RowDataVectorizer(TypeDescription schema, DataType[] fieldTypes) {
        super(schema);
        this.fieldWriters = Arrays.stream(fieldTypes).map(t -> (FieldWriter)t.accept((DataTypeVisitor)FieldWriterFactory.WRITER_FACTORY)).collect(Collectors.toList());
    }

    @Override
    public void vectorize(InternalRow row, VectorizedRowBatch batch) {
        int rowId = batch.size++;
        for (int i = 0; i < row.getFieldCount(); ++i) {
            ColumnVector fieldColumn = batch.cols[i];
            if (row.isNullAt(i)) {
                fieldColumn.noNulls = false;
                fieldColumn.isNull[rowId] = true;
                continue;
            }
            this.fieldWriters.get(i).write(rowId, fieldColumn, (DataGetters)row, i);
        }
    }
}

