/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReader;
import org.apache.paimon.format.parquet.reader.TimestampColumnReader;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.column.Dictionary;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.utils.Preconditions;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, @Nullable Dictionary dictionary, @Nullable ValuesReader valuesReader, boolean isUtcTimestamp) {
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary, isUtcTimestamp) : new DefaultParquetDataColumnReader(valuesReader, isUtcTimestamp);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(Dictionary realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, realReader, null, isUtcTimestamp);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(ValuesReader realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, null, realReader, isUtcTimestamp);
    }

    private static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        private final ValuesReader valuesReader;
        private final Dictionary dict;
        private final boolean isUtcTimestamp;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader, boolean isUtcTimestamp) {
            this.valuesReader = (ValuesReader)Preconditions.checkNotNull((Object)valuesReader);
            this.dict = null;
            this.isUtcTimestamp = isUtcTimestamp;
        }

        public DefaultParquetDataColumnReader(Dictionary dict, boolean isUtcTimestamp) {
            this.valuesReader = null;
            this.dict = (Dictionary)Preconditions.checkNotNull((Object)dict);
            this.isUtcTimestamp = isUtcTimestamp;
        }

        @Override
        public void initFromPage(int i, ByteBufferInputStream in) throws IOException {
            this.valuesReader.initFromPage(i, in);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public Timestamp readMillsTimestamp() {
            return Timestamp.fromEpochMillis((long)this.valuesReader.readLong());
        }

        @Override
        public Timestamp readMicrosTimestamp() {
            return Timestamp.fromMicros((long)this.valuesReader.readLong());
        }

        @Override
        public Timestamp readNanosTimestamp() {
            return this.int96TimestampConvert(this.valuesReader.readBytes());
        }

        @Override
        public Timestamp readMillsTimestamp(int id) {
            return Timestamp.fromEpochMillis((long)this.readLong(id));
        }

        @Override
        public Timestamp readMicrosTimestamp(int id) {
            return Timestamp.fromMicros((long)this.readLong(id));
        }

        @Override
        public Timestamp readNanosTimestamp(int id) {
            return this.int96TimestampConvert(this.dict.decodeToBinary(id));
        }

        @Override
        public int readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public int readSmallInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readSmallInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readTinyInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readTinyInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }

        private Timestamp int96TimestampConvert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            return TimestampColumnReader.int96ToTimestamp(this.isUtcTimestamp, timeOfDayNanos, julianDay);
        }
    }
}

