/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.filter2.predicate;

import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.FunctionVisitor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.shade.org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.Operators;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class ParquetFilters {
    private static final ConvertFilterToParquet CONVERTER = new ConvertFilterToParquet();

    private ParquetFilters() {
    }

    public static FilterCompat.Filter convert(List<Predicate> predicates) {
        FilterPredicate result = null;
        if (predicates != null) {
            for (Predicate predicate : predicates) {
                try {
                    FilterPredicate parquetFilter = (FilterPredicate)predicate.visit((PredicateVisitor)CONVERTER);
                    if (result == null) {
                        result = parquetFilter;
                        continue;
                    }
                    result = FilterApi.and(result, parquetFilter);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        return result != null ? FilterCompat.get(result) : FilterCompat.NOOP;
    }

    private static Operators.Column<?> toParquetColumn(FieldRef fieldRef) {
        return (Operators.Column)fieldRef.type().accept((DataTypeVisitor)new ConvertToColumnTypeVisitor(fieldRef.name()));
    }

    private static Comparable<?> toParquetObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Byte) {
                return ((Byte)value).intValue();
            }
            if (value instanceof Short) {
                return ((Short)value).intValue();
            }
            return (Comparable)value;
        }
        if (value instanceof String) {
            return Binary.fromString((String)value);
        }
        if (value instanceof BinaryString) {
            return Binary.fromString(value.toString());
        }
        if (value instanceof byte[]) {
            return Binary.fromReusedByteArray((byte[])value);
        }
        throw new UnsupportedOperationException();
    }

    private static class ConvertToColumnTypeVisitor
    implements DataTypeVisitor<Operators.Column<?>> {
        private final String name;

        public ConvertToColumnTypeVisitor(String name) {
            this.name = name;
        }

        public Operators.Column<?> visit(CharType charType) {
            return FilterApi.binaryColumn(this.name);
        }

        public Operators.Column<?> visit(VarCharType varCharType) {
            return FilterApi.binaryColumn(this.name);
        }

        public Operators.Column<?> visit(BooleanType booleanType) {
            return FilterApi.booleanColumn(this.name);
        }

        public Operators.Column<?> visit(BinaryType binaryType) {
            return FilterApi.binaryColumn(this.name);
        }

        public Operators.Column<?> visit(VarBinaryType varBinaryType) {
            return FilterApi.binaryColumn(this.name);
        }

        public Operators.Column<?> visit(TinyIntType tinyIntType) {
            return FilterApi.intColumn(this.name);
        }

        public Operators.Column<?> visit(SmallIntType smallIntType) {
            return FilterApi.intColumn(this.name);
        }

        public Operators.Column<?> visit(IntType intType) {
            return FilterApi.intColumn(this.name);
        }

        public Operators.Column<?> visit(BigIntType bigIntType) {
            return FilterApi.longColumn(this.name);
        }

        public Operators.Column<?> visit(FloatType floatType) {
            return FilterApi.floatColumn(this.name);
        }

        public Operators.Column<?> visit(DoubleType doubleType) {
            return FilterApi.doubleColumn(this.name);
        }

        public Operators.Column<?> visit(DateType dateType) {
            return FilterApi.intColumn(this.name);
        }

        public Operators.Column<?> visit(TimeType timeType) {
            return FilterApi.intColumn(this.name);
        }

        public Operators.Column<?> visit(DecimalType decimalType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(TimestampType timestampType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(LocalZonedTimestampType localZonedTimestampType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(ArrayType arrayType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(MultisetType multisetType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(MapType mapType) {
            throw new UnsupportedOperationException();
        }

        public Operators.Column<?> visit(RowType rowType) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConvertFilterToParquet
    implements FunctionVisitor<FilterPredicate> {
        private ConvertFilterToParquet() {
        }

        public FilterPredicate visitIsNotNull(FieldRef fieldRef) {
            return new Operators.NotEq<Object>(ParquetFilters.toParquetColumn(fieldRef), null);
        }

        public FilterPredicate visitIsNull(FieldRef fieldRef) {
            return new Operators.Eq<Object>(ParquetFilters.toParquetColumn(fieldRef), null);
        }

        public FilterPredicate visitLessThan(FieldRef fieldRef, Object literal) {
            return new Operators.Lt<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitGreaterOrEqual(FieldRef fieldRef, Object literal) {
            return new Operators.GtEq<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitNotEqual(FieldRef fieldRef, Object literal) {
            return new Operators.NotEq<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitLessOrEqual(FieldRef fieldRef, Object literal) {
            return new Operators.LtEq<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitEqual(FieldRef fieldRef, Object literal) {
            return new Operators.Eq<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitGreaterThan(FieldRef fieldRef, Object literal) {
            return new Operators.Gt<Comparable>(ParquetFilters.toParquetColumn(fieldRef), ParquetFilters.toParquetObject(literal));
        }

        public FilterPredicate visitAnd(List<FilterPredicate> children) {
            if (children.size() != 2) {
                throw new RuntimeException("Illegal and children: " + children.size());
            }
            return FilterApi.and(children.get(0), children.get(1));
        }

        public FilterPredicate visitOr(List<FilterPredicate> children) {
            if (children.size() != 2) {
                throw new RuntimeException("Illegal and children: " + children.size());
            }
            return FilterApi.or(children.get(0), children.get(1));
        }

        public FilterPredicate visitStartsWith(FieldRef fieldRef, Object literal) {
            throw new UnsupportedOperationException();
        }

        public FilterPredicate visitEndsWith(FieldRef fieldRef, Object literal) {
            throw new UnsupportedOperationException();
        }

        public FilterPredicate visitContains(FieldRef fieldRef, Object literal) {
            throw new UnsupportedOperationException();
        }

        public FilterPredicate visitIn(FieldRef fieldRef, List<Object> literals) {
            throw new UnsupportedOperationException();
        }

        public FilterPredicate visitNotIn(FieldRef fieldRef, List<Object> literals) {
            throw new UnsupportedOperationException();
        }
    }
}

