/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.format.parquet.ParquetReaderFactory;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.ParquetSimpleStatsExtractor;
import org.apache.paimon.format.parquet.ParquetWriterFactory;
import org.apache.paimon.format.parquet.writer.RowDataParquetBuilder;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.ParquetFilters;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;

public class ParquetFileFormat
extends FileFormat {
    private final Options options;
    private final int readBatchSize;

    public ParquetFileFormat(FileFormatFactory.FormatContext formatContext) {
        super("parquet");
        this.options = this.getParquetConfiguration(formatContext);
        this.readBatchSize = formatContext.readBatchSize();
    }

    @VisibleForTesting
    Options getOptions() {
        return this.options;
    }

    public FormatReaderFactory createReaderFactory(RowType projectedRowType, List<Predicate> filters) {
        return new ParquetReaderFactory(this.options, projectedRowType, this.readBatchSize, ParquetFilters.convert(filters));
    }

    public FormatWriterFactory createWriterFactory(RowType type) {
        return new ParquetWriterFactory(new RowDataParquetBuilder(type, this.options));
    }

    public void validateDataFields(RowType rowType) {
        ParquetSchemaConverter.convertToParquetMessageType("paimon_schema", rowType);
    }

    public Optional<SimpleStatsExtractor> createStatsExtractor(RowType type, SimpleColStatsCollector.Factory[] statsCollectors) {
        return Optional.of(new ParquetSimpleStatsExtractor(type, statsCollectors));
    }

    private Options getParquetConfiguration(FileFormatFactory.FormatContext context) {
        MemorySize blockSize;
        Options parquetOptions = this.getIdentifierPrefixOptions(context.options());
        if (!parquetOptions.containsKey("parquet.compression.codec.zstd.level")) {
            parquetOptions.set("parquet.compression.codec.zstd.level", String.valueOf(context.zstdLevel()));
        }
        if ((blockSize = context.blockSize()) != null) {
            parquetOptions.set("parquet.block.size", String.valueOf(blockSize.getBytes()));
        }
        return parquetOptions;
    }
}

