/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.heap.HeapBooleanVector;
import org.apache.paimon.data.columnar.heap.HeapByteVector;
import org.apache.paimon.data.columnar.heap.HeapBytesVector;
import org.apache.paimon.data.columnar.heap.HeapDoubleVector;
import org.apache.paimon.data.columnar.heap.HeapFloatVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.heap.HeapLongVector;
import org.apache.paimon.data.columnar.heap.HeapShortVector;
import org.apache.paimon.data.columnar.heap.HeapTimestampVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.position.LevelDelegation;
import org.apache.paimon.format.parquet.reader.ColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReaderFactory;
import org.apache.paimon.format.parquet.reader.ParquetDecimalVector;
import org.apache.paimon.format.parquet.reader.ParquetReadState;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesInput;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.Encoding;
import org.apache.paimon.shade.org.apache.parquet.column.ValuesType;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV1;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV2;
import org.apache.paimon.shade.org.apache.parquet.column.page.DictionaryPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.IntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedPrimitiveColumnReader
implements ColumnReader<WritableColumnVector> {
    private static final Logger LOG = LoggerFactory.getLogger(NestedPrimitiveColumnReader.class);
    private final IntArrayList repetitionLevelList = new IntArrayList(0);
    private final IntArrayList definitionLevelList = new IntArrayList(0);
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final Type type;
    private final DataType dataType;
    private final ParquetDataColumnReader dictionary;
    private final int maxDefLevel;
    private boolean isUtcTimestamp;
    private boolean isCurrentPageDictionaryEncoded;
    private int definitionLevel;
    private int repetitionLevel;
    private IntIterator repetitionLevelColumn;
    private IntIterator definitionLevelColumn;
    private ParquetDataColumnReader dataColumn;
    protected final ParquetReadState readState;
    private boolean eof = false;
    private boolean isFirstRow = true;
    private Object lastValue;

    public NestedPrimitiveColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore, boolean isUtcTimestamp, Type parquetType, DataType dataType) throws IOException {
        this.descriptor = descriptor;
        this.type = parquetType;
        this.pageReader = pageReadStore.getPageReader(descriptor);
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.isUtcTimestamp = isUtcTimestamp;
        this.dataType = dataType;
        DictionaryPage dictionaryPage = this.pageReader.readDictionaryPage();
        this.readState = new ParquetReadState(pageReadStore.getRowIndexes().orElse(null));
        if (dictionaryPage != null) {
            try {
                this.dictionary = ParquetDataColumnReaderFactory.getDataColumnReaderByTypeOnDictionary(dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage), isUtcTimestamp);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not decode the dictionary for %s", descriptor), e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        throw new UnsupportedOperationException("This function should no be called.");
    }

    public WritableColumnVector readAndNewVector(int readNumber, WritableColumnVector vector) throws IOException {
        if (this.isFirstRow) {
            if (!this.readValue()) {
                return vector;
            }
            this.isFirstRow = false;
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        int valueIndex = this.collectDataFromParquetPage(readNumber, valueList);
        return this.fillColumnVector(valueIndex, valueList);
    }

    private int collectDataFromParquetPage(int total, List<Object> valueList) throws IOException {
        int valueIndex = 0;
        this.readState.resetForNewBatch(total);
        while (!this.eof && this.readState.rowsToReadInBatch > 0) {
            boolean needFilterSkip;
            if (this.readState.isFinished()) {
                this.eof = true;
                break;
            }
            long pageRowId = this.readState.rowId;
            long rangeStart = this.readState.currentRangeStart();
            long rangeEnd = this.readState.currentRangeEnd();
            if (pageRowId > rangeEnd) {
                this.readState.nextRange();
                continue;
            }
            boolean bl = needFilterSkip = pageRowId < rangeStart;
            do {
                if (needFilterSkip) continue;
                valueList.add(this.lastValue);
                ++valueIndex;
            } while (this.readValue() && this.repetitionLevel != 0);
            if (pageRowId == this.readState.rowId) {
                ++this.readState.rowId;
            }
            if (needFilterSkip) continue;
            --this.readState.rowsToReadInBatch;
        }
        return valueIndex;
    }

    public LevelDelegation getLevelDelegation() {
        int[] repetition = this.repetitionLevelList.toArray();
        int[] definition = this.definitionLevelList.toArray();
        this.repetitionLevelList.clear();
        this.definitionLevelList.clear();
        this.repetitionLevelList.add(this.repetitionLevel);
        this.definitionLevelList.add(this.definitionLevel);
        return new LevelDelegation(repetition, definition);
    }

    private boolean readValue() throws IOException {
        int left = this.readPageIfNeed();
        if (left > 0) {
            this.readAndSaveRepetitionAndDefinitionLevels();
            if (this.definitionLevel == this.maxDefLevel) {
                if (this.isCurrentPageDictionaryEncoded) {
                    int dictionaryId = this.dataColumn.readValueDictionaryId();
                    this.lastValue = this.dictionaryDecodeValue(this.dataType, dictionaryId);
                } else {
                    this.lastValue = this.readPrimitiveTypedRow(this.dataType);
                }
            } else {
                this.lastValue = null;
            }
            return true;
        }
        this.eof = true;
        return false;
    }

    private void readAndSaveRepetitionAndDefinitionLevels() {
        this.repetitionLevel = this.repetitionLevelColumn.nextInt();
        this.definitionLevel = this.definitionLevelColumn.nextInt();
        --this.readState.valuesToReadInPage;
        this.repetitionLevelList.add(this.repetitionLevel);
        this.definitionLevelList.add(this.definitionLevel);
    }

    private int readPageIfNeed() throws IOException {
        int pageValueCount;
        if (this.readState.valuesToReadInPage == 0 && (pageValueCount = this.readPage()) < 0) {
            return -1;
        }
        return this.readState.valuesToReadInPage;
    }

    private Object readPrimitiveTypedRow(DataType category) {
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dataColumn.readBytes();
            }
            case BOOLEAN: {
                return this.dataColumn.readBoolean();
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dataColumn.readInteger();
            }
            case TINYINT: {
                return this.dataColumn.readTinyInt();
            }
            case SMALLINT: {
                return this.dataColumn.readSmallInt();
            }
            case BIGINT: {
                return this.dataColumn.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.dataColumn.readFloat());
            }
            case DOUBLE: {
                return this.dataColumn.readDouble();
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dataColumn.readInteger();
                    }
                    case INT64: {
                        return this.dataColumn.readLong();
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dataColumn.readBytes();
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.readTimestamp(((TimestampType)category).getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.readTimestamp(((LocalZonedTimestampType)category).getPrecision());
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private Timestamp readTimestamp(int precision) {
        if (precision <= 3) {
            return this.dataColumn.readMillsTimestamp();
        }
        if (precision <= 6) {
            return this.dataColumn.readMicrosTimestamp();
        }
        return this.dataColumn.readNanosTimestamp();
    }

    private Object dictionaryDecodeValue(DataType category, Integer dictionaryValue) {
        if (dictionaryValue == null) {
            return null;
        }
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dictionary.readBytes(dictionaryValue);
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dictionary.readInteger(dictionaryValue);
            }
            case BOOLEAN: {
                return this.dictionary.readBoolean(dictionaryValue) ? 1 : 0;
            }
            case DOUBLE: {
                return this.dictionary.readDouble(dictionaryValue);
            }
            case FLOAT: {
                return Float.valueOf(this.dictionary.readFloat(dictionaryValue));
            }
            case TINYINT: {
                return this.dictionary.readTinyInt(dictionaryValue);
            }
            case SMALLINT: {
                return this.dictionary.readSmallInt(dictionaryValue);
            }
            case BIGINT: {
                return this.dictionary.readLong(dictionaryValue);
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dictionary.readInteger(dictionaryValue);
                    }
                    case INT64: {
                        return this.dictionary.readLong(dictionaryValue);
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dictionary.readBytes(dictionaryValue);
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.dictionaryReadTimestamp(((TimestampType)category).getPrecision(), dictionaryValue);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dictionaryReadTimestamp(((LocalZonedTimestampType)category).getPrecision(), dictionaryValue);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private Timestamp dictionaryReadTimestamp(int precision, int dictionaryValue) {
        if (precision <= 3) {
            return this.dictionary.readMillsTimestamp(dictionaryValue);
        }
        if (precision <= 6) {
            return this.dictionary.readMicrosTimestamp(dictionaryValue);
        }
        return this.dictionary.readNanosTimestamp(dictionaryValue);
    }

    private WritableColumnVector fillColumnVector(int total, List valueList) {
        switch (this.dataType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                HeapBytesVector heapBytesVector = new HeapBytesVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    byte[] src = (byte[])valueList.get(i);
                    if (src == null) {
                        heapBytesVector.setNullAt(i);
                        continue;
                    }
                    heapBytesVector.putByteArray(i, src, 0, src.length);
                }
                return heapBytesVector;
            }
            case BOOLEAN: {
                HeapBooleanVector heapBooleanVector = new HeapBooleanVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapBooleanVector.setNullAt(i);
                        continue;
                    }
                    heapBooleanVector.vector[i] = (Boolean)valueList.get(i);
                }
                return heapBooleanVector;
            }
            case TINYINT: {
                HeapByteVector heapByteVector = new HeapByteVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapByteVector.setNullAt(i);
                        continue;
                    }
                    heapByteVector.vector[i] = (byte)((Integer)valueList.get(i)).intValue();
                }
                return heapByteVector;
            }
            case SMALLINT: {
                HeapShortVector heapShortVector = new HeapShortVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapShortVector.setNullAt(i);
                        continue;
                    }
                    heapShortVector.vector[i] = (short)((Integer)valueList.get(i)).intValue();
                }
                return heapShortVector;
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                HeapIntVector heapIntVector = new HeapIntVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapIntVector.setNullAt(i);
                        continue;
                    }
                    heapIntVector.vector[i] = (Integer)valueList.get(i);
                }
                return heapIntVector;
            }
            case FLOAT: {
                HeapFloatVector heapFloatVector = new HeapFloatVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapFloatVector.setNullAt(i);
                        continue;
                    }
                    heapFloatVector.vector[i] = ((Float)valueList.get(i)).floatValue();
                }
                return heapFloatVector;
            }
            case BIGINT: {
                HeapLongVector heapLongVector = new HeapLongVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapLongVector.setNullAt(i);
                        continue;
                    }
                    heapLongVector.vector[i] = (Long)valueList.get(i);
                }
                return heapLongVector;
            }
            case DOUBLE: {
                HeapDoubleVector heapDoubleVector = new HeapDoubleVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapDoubleVector.setNullAt(i);
                        continue;
                    }
                    heapDoubleVector.vector[i] = (Double)valueList.get(i);
                }
                return heapDoubleVector;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                HeapTimestampVector heapTimestampVector = new HeapTimestampVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        heapTimestampVector.setNullAt(i);
                        continue;
                    }
                    heapTimestampVector.setTimestamp(i, (Timestamp)valueList.get(i));
                }
                return heapTimestampVector;
            }
            case DECIMAL: {
                PrimitiveType.PrimitiveTypeName primitiveTypeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                switch (primitiveTypeName) {
                    case INT32: {
                        HeapIntVector phiv = new HeapIntVector(total);
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                phiv.setNullAt(i);
                                continue;
                            }
                            phiv.vector[i] = (Integer)valueList.get(i);
                        }
                        return new ParquetDecimalVector((WritableColumnVector)phiv);
                    }
                    case INT64: {
                        HeapLongVector phlv = new HeapLongVector(total);
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                phlv.setNullAt(i);
                                continue;
                            }
                            phlv.vector[i] = (Long)valueList.get(i);
                        }
                        return new ParquetDecimalVector((WritableColumnVector)phlv);
                    }
                }
                HeapBytesVector phbv = NestedPrimitiveColumnReader.getHeapBytesVector(total, valueList);
                return new ParquetDecimalVector((WritableColumnVector)phbv);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private static HeapBytesVector getHeapBytesVector(int total, List valueList) {
        HeapBytesVector phbv = new HeapBytesVector(total);
        for (int i = 0; i < valueList.size(); ++i) {
            byte[] src = (byte[])valueList.get(i);
            if (valueList.get(i) == null) {
                phbv.setNullAt(i);
                continue;
            }
            phbv.putByteArray(i, src, 0, src.length);
        }
        return phbv;
    }

    protected int readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return -1;
        }
        long pageFirstRowIndex = page.getFirstRowIndex().orElse(0L);
        int pageValueCount = page.accept(new DataPage.Visitor<Integer>(){

            @Override
            public Integer visit(DataPageV1 dataPageV1) {
                return NestedPrimitiveColumnReader.this.readPageV1(dataPageV1);
            }

            @Override
            public Integer visit(DataPageV2 dataPageV2) {
                return NestedPrimitiveColumnReader.this.readPageV2(dataPageV2);
            }
        });
        this.readState.resetForNewPage(pageValueCount, pageFirstRowIndex);
        return pageValueCount;
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) throws IOException {
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException(String.format("Could not read page in col %s because the dictionary was missing for encoding %s.", new Object[]{this.descriptor, dataEncoding}));
            }
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary.getDictionary()), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES), this.isUtcTimestamp);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(valueCount, in);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not read page in col %s.", this.descriptor), e);
        }
    }

    private int readPageV1(DataPageV1 page) {
        int pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        try {
            BytesInput bytes = page.getBytes();
            LOG.debug("Page size {}  bytes and {} records.", (Object)bytes.size(), (Object)pageValueCount);
            ByteBufferInputStream in = bytes.toInputStream();
            LOG.debug("Reading repetition levels at {}.", (Object)in.position());
            rlReader.initFromPage(pageValueCount, in);
            LOG.debug("Reading definition levels at {}.", (Object)in.position());
            dlReader.initFromPage(pageValueCount, in);
            LOG.debug("Reading data at {}.", (Object)in.position());
            this.initDataReader(page.getValueEncoding(), in, pageValueCount);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private int readPageV2(DataPageV2 page) {
        int pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            LOG.debug("Page data size {} bytes and {} records.", (Object)page.getData().size(), (Object)pageValueCount);
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream(), pageValueCount);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read page %s in col %s.", page, this.descriptor), e);
        }
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt(maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException(String.format("Could not read levels in page for col %s.", this.descriptor), e);
        }
    }

    protected static final class NullIntIterator
    implements IntIterator {
        protected NullIntIterator() {
        }

        @Override
        public int nextInt() {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    implements IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }

    protected static final class ValuesReaderIntIterator
    implements IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static interface IntIterator {
        public int nextInt();
    }
}

