/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.OrcOptions;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.format.orc.OrcReaderFactory;
import org.apache.paimon.format.orc.OrcTypeUtil;
import org.apache.paimon.format.orc.OrcWriterFactory;
import org.apache.paimon.format.orc.filter.OrcFilters;
import org.apache.paimon.format.orc.filter.OrcPredicateFunctionVisitor;
import org.apache.paimon.format.orc.filter.OrcSimpleStatsExtractor;
import org.apache.paimon.format.orc.writer.RowDataVectorizer;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.shade.org.apache.orc.OrcConf;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;

@ThreadSafe
public class OrcFileFormat
extends FileFormat {
    public static final String IDENTIFIER = "orc";
    private final Properties orcProperties;
    private final Configuration readerConf;
    private final Configuration writerConf;
    private final int readBatchSize;
    private final int writeBatchSize;
    private final boolean deletionVectorsEnabled;
    private final boolean legacyTimestampLtzType;

    public OrcFileFormat(FileFormatFactory.FormatContext formatContext) {
        super(IDENTIFIER);
        this.orcProperties = this.getOrcProperties(formatContext.options(), formatContext);
        this.readerConf = new Configuration(false);
        this.orcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.readerConf.set(k.toString(), v.toString())));
        this.writerConf = new Configuration(false);
        this.orcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.writerConf.set(k.toString(), v.toString())));
        this.readBatchSize = formatContext.readBatchSize();
        this.writeBatchSize = formatContext.writeBatchSize();
        this.deletionVectorsEnabled = (Boolean)formatContext.options().get(CoreOptions.DELETION_VECTORS_ENABLED);
        this.legacyTimestampLtzType = (Boolean)formatContext.options().get(OrcOptions.ORC_TIMESTAMP_LTZ_LEGACY_TYPE);
    }

    @VisibleForTesting
    public Properties orcProperties() {
        return this.orcProperties;
    }

    @VisibleForTesting
    public int readBatchSize() {
        return this.readBatchSize;
    }

    public Optional<SimpleStatsExtractor> createStatsExtractor(RowType type, SimpleColStatsCollector.Factory[] statsCollectors) {
        return Optional.of(new OrcSimpleStatsExtractor(type, statsCollectors, this.legacyTimestampLtzType));
    }

    public FormatReaderFactory createReaderFactory(RowType projectedRowType, @Nullable List<Predicate> filters) {
        ArrayList<OrcFilters.Predicate> orcPredicates = new ArrayList<OrcFilters.Predicate>();
        if (filters != null) {
            for (Predicate pred : filters) {
                Optional orcPred = (Optional)pred.visit((PredicateVisitor)OrcPredicateFunctionVisitor.VISITOR);
                orcPred.ifPresent(orcPredicates::add);
            }
        }
        return new OrcReaderFactory(this.readerConf, (RowType)OrcFileFormat.refineDataType((DataType)projectedRowType), orcPredicates, this.readBatchSize, this.deletionVectorsEnabled, this.legacyTimestampLtzType);
    }

    public void validateDataFields(RowType rowType) {
        DataType refinedType = OrcFileFormat.refineDataType((DataType)rowType);
        OrcTypeUtil.convertToOrcSchema((RowType)refinedType);
    }

    public FormatWriterFactory createWriterFactory(RowType type) {
        DataType refinedType = OrcFileFormat.refineDataType((DataType)type);
        DataType[] orcTypes = DataTypeChecks.getFieldTypes((DataType)refinedType).toArray(new DataType[0]);
        TypeDescription typeDescription = OrcTypeUtil.convertToOrcSchema((RowType)refinedType);
        RowDataVectorizer vectorizer = new RowDataVectorizer(typeDescription, orcTypes, this.legacyTimestampLtzType);
        return new OrcWriterFactory(vectorizer, this.orcProperties, this.writerConf, this.writeBatchSize);
    }

    private Properties getOrcProperties(Options options, FileFormatFactory.FormatContext formatContext) {
        MemorySize blockSize;
        Properties orcProperties = new Properties();
        orcProperties.putAll((Map<?, ?>)this.getIdentifierPrefixOptions(options).toMap());
        if (!orcProperties.containsKey(OrcConf.COMPRESSION_ZSTD_LEVEL.getAttribute())) {
            orcProperties.setProperty(OrcConf.COMPRESSION_ZSTD_LEVEL.getAttribute(), String.valueOf(formatContext.zstdLevel()));
        }
        if ((blockSize = formatContext.blockSize()) != null) {
            orcProperties.setProperty(OrcConf.STRIPE_SIZE.getAttribute(), String.valueOf(blockSize.getBytes()));
        }
        return orcProperties;
    }

    public static DataType refineDataType(DataType type) {
        switch (type.getTypeRoot()) {
            case BINARY: 
            case VARBINARY: {
                return DataTypes.BYTES();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return new ArrayType(arrayType.isNullable(), OrcFileFormat.refineDataType(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new MapType(OrcFileFormat.refineDataType(mapType.getKeyType()), OrcFileFormat.refineDataType(mapType.getValueType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                return new MapType(OrcFileFormat.refineDataType(multisetType.getElementType()), OrcFileFormat.refineDataType((DataType)new IntType(false)));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new RowType(rowType.isNullable(), rowType.getFields().stream().map(f -> new DataField(f.id(), f.name(), OrcFileFormat.refineDataType(f.type()), f.description())).collect(Collectors.toList()));
            }
        }
        return type;
    }
}

