/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.shade.org.apache.parquet.schema.ConversionPatterns;
import org.apache.paimon.shade.org.apache.parquet.schema.GroupType;
import org.apache.paimon.shade.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.shade.org.apache.parquet.schema.Types;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.Pair;

public class ParquetSchemaConverter {
    static final String PAIMON_SCHEMA = "paimon_schema";
    static final String MAP_REPEATED_NAME = "key_value";
    static final String MAP_KEY_NAME = "key";
    static final String MAP_VALUE_NAME = "value";
    static final String LIST_REPEATED_NAME = "list";
    static final String LIST_ELEMENT_NAME = "element";

    public static MessageType convertToParquetMessageType(RowType rowType) {
        return new MessageType(PAIMON_SCHEMA, ParquetSchemaConverter.convertToParquetTypes(rowType));
    }

    private static Type[] convertToParquetTypes(RowType rowType) {
        return (Type[])rowType.getFields().stream().map(ParquetSchemaConverter::convertToParquetType).toArray(Type[]::new);
    }

    public static Type convertToParquetType(DataField field) {
        return ParquetSchemaConverter.convertToParquetType(field.name(), field.type(), field.id(), 0);
    }

    private static Type convertToParquetType(String name, DataType type, int fieldId, int depth) {
        Type.Repetition repetition = type.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(LogicalTypeAnnotation.stringType())).named(name)).withId(fieldId);
            }
            case BOOLEAN: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(name)).withId(fieldId);
            }
            case BINARY: 
            case VARBINARY: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).named(name)).withId(fieldId);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                if (ParquetSchemaConverter.is32BitDecimal(precision)) {
                    return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).named(name)).withId(fieldId);
                }
                if (ParquetSchemaConverter.is64BitDecimal(precision)) {
                    return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).named(name)).withId(fieldId);
                }
                return ((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).length(ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision))).named(name)).withId(fieldId);
            }
            case TINYINT: {
                return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.intType(8, true))).named(name)).withId(fieldId);
            }
            case SMALLINT: {
                return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.intType(16, true))).named(name)).withId(fieldId);
            }
            case INTEGER: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).named(name)).withId(fieldId);
            }
            case BIGINT: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name)).withId(fieldId);
            }
            case FLOAT: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(name)).withId(fieldId);
            }
            case DOUBLE: {
                return ((PrimitiveType)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(name)).withId(fieldId);
            }
            case DATE: {
                return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.dateType())).named(name)).withId(fieldId);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name)).withId(fieldId);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                return ParquetSchemaConverter.createTimestampWithLogicalType(name, timestampType.getPrecision(), repetition, false).withId(fieldId);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)type;
                return ParquetSchemaConverter.createTimestampWithLogicalType(name, localZonedTimestampType.getPrecision(), repetition, true).withId(fieldId);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                Type elementParquetType = ParquetSchemaConverter.convertToParquetType(LIST_ELEMENT_NAME, arrayType.getElementType(), fieldId, depth + 1).withId(SpecialFields.getArrayElementFieldId((int)fieldId, (int)(depth + 1)));
                return ConversionPatterns.listOfElements(repetition, name, elementParquetType).withId(fieldId);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                DataType keyType = mapType.getKeyType();
                if (keyType.isNullable()) {
                    keyType = keyType.copy(false);
                }
                Type mapKeyParquetType = ParquetSchemaConverter.convertToParquetType(MAP_KEY_NAME, keyType, fieldId, depth + 1).withId(SpecialFields.getMapKeyFieldId((int)fieldId, (int)(depth + 1)));
                Type mapValueParquetType = ParquetSchemaConverter.convertToParquetType(MAP_VALUE_NAME, mapType.getValueType(), fieldId, depth + 1).withId(SpecialFields.getMapValueFieldId((int)fieldId, (int)(depth + 1)));
                return ConversionPatterns.mapType(repetition, name, MAP_REPEATED_NAME, mapKeyParquetType, mapValueParquetType).withId(fieldId);
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                DataType elementType = multisetType.getElementType();
                if (elementType.isNullable()) {
                    elementType = elementType.copy(false);
                }
                Type multisetKeyParquetType = ParquetSchemaConverter.convertToParquetType(MAP_KEY_NAME, elementType, fieldId, depth + 1).withId(SpecialFields.getMapKeyFieldId((int)fieldId, (int)(depth + 1)));
                Type multisetValueParquetType = ParquetSchemaConverter.convertToParquetType(MAP_VALUE_NAME, (DataType)new IntType(false), fieldId, depth + 1).withId(SpecialFields.getMapValueFieldId((int)fieldId, (int)(depth + 1)));
                return ConversionPatterns.mapType(repetition, name, MAP_REPEATED_NAME, multisetKeyParquetType, multisetValueParquetType).withId(fieldId);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new GroupType(repetition, name, ParquetSchemaConverter.convertToParquetTypes(rowType)).withId(fieldId);
            }
            case VARIANT: {
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(repetition).addField((Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED).named(MAP_VALUE_NAME))).addField((Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED).named("metadata"))).named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static Type createTimestampWithLogicalType(String name, int precision, Type.Repetition repetition, boolean isAdjustToUTC) {
        if (precision <= 3) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.timestampType(isAdjustToUTC, LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
        }
        if (precision > 6) {
            return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
        }
        return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.timestampType(isAdjustToUTC, LogicalTypeAnnotation.TimeUnit.MICROS))).named(name);
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    public static boolean is32BitDecimal(int precision) {
        return precision <= 9;
    }

    public static boolean is64BitDecimal(int precision) {
        return precision <= 18 && precision > 9;
    }

    public static RowType convertToPaimonRowType(MessageType messageType) {
        List dataFields = messageType.asGroupType().getFields().stream().map(ParquetSchemaConverter::convertToPaimonField).collect(Collectors.toList());
        return new RowType(dataFields);
    }

    public static DataField convertToPaimonField(Type parquetType) {
        ArrayType paimonDataType;
        LogicalTypeAnnotation logicalType = parquetType.getLogicalTypeAnnotation();
        if (parquetType.isPrimitive()) {
            BooleanType paimonDataType2;
            switch (parquetType.asPrimitiveType().getPrimitiveTypeName()) {
                case BINARY: {
                    if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                        paimonDataType2 = DataTypes.STRING();
                        break;
                    }
                    paimonDataType2 = DataTypes.BYTES();
                    break;
                }
                case BOOLEAN: {
                    paimonDataType2 = DataTypes.BOOLEAN();
                    break;
                }
                case FLOAT: {
                    paimonDataType2 = DataTypes.FLOAT();
                    break;
                }
                case DOUBLE: {
                    paimonDataType2 = DataTypes.DOUBLE();
                    break;
                }
                case INT32: {
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
                        paimonDataType2 = new DecimalType(decimalType.getPrecision(), decimalType.getScale());
                        break;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType;
                        int bitWidth = intType.getBitWidth();
                        if (bitWidth == 8) {
                            paimonDataType2 = DataTypes.TINYINT();
                            break;
                        }
                        if (bitWidth == 16) {
                            paimonDataType2 = DataTypes.SMALLINT();
                            break;
                        }
                        paimonDataType2 = DataTypes.INT();
                        break;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                        paimonDataType2 = DataTypes.DATE();
                        break;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        paimonDataType2 = DataTypes.TIME();
                        break;
                    }
                    paimonDataType2 = DataTypes.INT();
                    break;
                }
                case INT64: {
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
                        paimonDataType2 = new DecimalType(decimalType.getPrecision(), decimalType.getScale());
                        break;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                        int precision = timestampType.getUnit().equals((Object)LogicalTypeAnnotation.TimeUnit.MILLIS) ? 3 : 6;
                        paimonDataType2 = timestampType.isAdjustedToUTC() ? new LocalZonedTimestampType(precision) : new TimestampType(precision);
                        break;
                    }
                    paimonDataType2 = DataTypes.BIGINT();
                    break;
                }
                case INT96: {
                    paimonDataType2 = new TimestampType(9);
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
                    paimonDataType2 = new DecimalType(decimalType.getPrecision(), decimalType.getScale());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type: " + parquetType);
                }
            }
            if (parquetType.getRepetition().equals((Object)Type.Repetition.REQUIRED)) {
                paimonDataType2 = paimonDataType2.notNull();
            }
            return new DataField(parquetType.getId().intValue(), parquetType.getName(), (DataType)paimonDataType2);
        }
        GroupType groupType = parquetType.asGroupType();
        if (logicalType instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            paimonDataType = new ArrayType(ParquetSchemaConverter.convertToPaimonField(ParquetSchemaConverter.parquetListElementType(groupType)).type());
        } else if (logicalType instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            Pair<Type, Type> keyValueType = ParquetSchemaConverter.parquetMapKeyValueType(groupType);
            paimonDataType = new MapType(ParquetSchemaConverter.convertToPaimonField((Type)keyValueType.getLeft()).type().nullable(), ParquetSchemaConverter.convertToPaimonField((Type)keyValueType.getRight()).type());
        } else {
            paimonDataType = new RowType(groupType.getFields().stream().map(ParquetSchemaConverter::convertToPaimonField).collect(Collectors.toList()));
        }
        if (parquetType.getRepetition().equals((Object)Type.Repetition.REQUIRED)) {
            paimonDataType = paimonDataType.notNull();
        }
        return new DataField(parquetType.getId().intValue(), parquetType.getName(), (DataType)paimonDataType);
    }

    public static Type parquetListElementType(GroupType listType) {
        return listType.getType(LIST_REPEATED_NAME).asGroupType().getType(LIST_ELEMENT_NAME);
    }

    public static Pair<Type, Type> parquetMapKeyValueType(GroupType mapType) {
        GroupType keyValue = mapType.getType(MAP_REPEATED_NAME).asGroupType();
        return Pair.of((Object)keyValue.getType(MAP_KEY_NAME), (Object)keyValue.getType(MAP_VALUE_NAME));
    }
}

