/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.newreader;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.paimon.data.columnar.heap.AbstractArrayBasedVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.newreader.VectorizedColumnReader;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.format.parquet.type.ParquetGroupField;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.Preconditions;

public class ParquetColumnVector {
    private final ParquetField column;
    private final List<ParquetColumnVector> children;
    private final WritableColumnVector vector;
    private HeapIntVector repetitionLevels;
    private HeapIntVector definitionLevels;
    private final boolean isPrimitive;
    private VectorizedColumnReader columnReader;

    ParquetColumnVector(ParquetField column, WritableColumnVector vector, int capacity, Set<ParquetField> missingColumns, boolean isTopLevel) {
        this.column = column;
        this.vector = vector;
        this.children = new ArrayList<ParquetColumnVector>();
        this.isPrimitive = column.isPrimitive();
        if (missingColumns.contains(column)) {
            vector.setAllNull();
            return;
        }
        if (this.isPrimitive) {
            if (column.getRepetitionLevel() > 0) {
                this.repetitionLevels = new HeapIntVector(capacity);
            }
            if (!isTopLevel) {
                this.definitionLevels = new HeapIntVector(capacity);
            }
        } else {
            ParquetGroupField groupField = (ParquetGroupField)column;
            Preconditions.checkArgument((groupField.getChildren().size() == vector.getChildren().length ? 1 : 0) != 0);
            boolean allChildrenAreMissing = true;
            for (int i = 0; i < groupField.getChildren().size(); ++i) {
                ParquetColumnVector childCv = new ParquetColumnVector(groupField.getChildren().get(i), (WritableColumnVector)vector.getChildren()[i], capacity, missingColumns, false);
                this.children.add(childCv);
                if (childCv.vector.isAllNull()) continue;
                allChildrenAreMissing = false;
                this.repetitionLevels = childCv.repetitionLevels;
                this.definitionLevels = childCv.definitionLevels;
            }
            if (allChildrenAreMissing) {
                vector.setAllNull();
            }
        }
    }

    List<ParquetColumnVector> getChildren() {
        return this.children;
    }

    List<ParquetColumnVector> getLeaves() {
        ArrayList<ParquetColumnVector> result = new ArrayList<ParquetColumnVector>();
        ParquetColumnVector.getLeavesHelper(this, result);
        return result;
    }

    private static void getLeavesHelper(ParquetColumnVector vector, List<ParquetColumnVector> coll) {
        if (vector.isPrimitive) {
            coll.add(vector);
        } else {
            for (ParquetColumnVector child : vector.children) {
                ParquetColumnVector.getLeavesHelper(child, coll);
            }
        }
    }

    void assemble() {
        if (this.vector.isAllNull()) {
            return;
        }
        DataTypeRoot type = this.column.getType().getTypeRoot();
        if (type == DataTypeRoot.ARRAY || type == DataTypeRoot.MAP || type == DataTypeRoot.MULTISET) {
            for (ParquetColumnVector child : this.children) {
                child.assemble();
            }
            this.assembleCollection();
        } else if (type == DataTypeRoot.ROW || type == DataTypeRoot.VARIANT) {
            for (ParquetColumnVector child : this.children) {
                child.assemble();
            }
            this.assembleStruct();
        }
    }

    void reset() {
        if (this.vector.isAllNull()) {
            return;
        }
        this.vector.reset();
        if (this.repetitionLevels != null) {
            this.repetitionLevels.reset();
        }
        if (this.definitionLevels != null) {
            this.definitionLevels.reset();
        }
        for (ParquetColumnVector child : this.children) {
            child.reset();
        }
    }

    ParquetField getColumn() {
        return this.column;
    }

    WritableColumnVector getValueVector() {
        return this.vector;
    }

    WritableIntVector getRepetitionLevelVector() {
        return this.repetitionLevels;
    }

    WritableIntVector getDefinitionLevelVector() {
        return this.definitionLevels;
    }

    VectorizedColumnReader getColumnReader() {
        return this.columnReader;
    }

    void setColumnReader(VectorizedColumnReader reader) {
        if (!this.isPrimitive) {
            throw new IllegalStateException("Can't set reader for non-primitive column");
        }
        this.columnReader = reader;
    }

    private void assembleCollection() {
        int maxDefinitionLevel = this.column.getDefinitionLevel();
        int maxElementRepetitionLevel = this.column.getRepetitionLevel();
        AbstractArrayBasedVector arrayVector = (AbstractArrayBasedVector)this.vector;
        int rowId = 0;
        int i = 0;
        int offset = 0;
        while (i < this.definitionLevels.getElementsAppended()) {
            arrayVector.reserve(rowId + 1);
            int definitionLevel = this.definitionLevels.getInt(i);
            if (definitionLevel <= maxDefinitionLevel) {
                ++offset;
            }
            if (definitionLevel <= maxDefinitionLevel - 1) {
                arrayVector.setNullAt(rowId++);
            } else if (definitionLevel == maxDefinitionLevel) {
                arrayVector.putOffsetLength(rowId, (long)offset, 0L);
                ++rowId;
            } else if (definitionLevel > maxDefinitionLevel) {
                int length = this.getCollectionSize(maxElementRepetitionLevel, i);
                arrayVector.putOffsetLength(rowId, (long)offset, (long)length);
                offset += length;
                ++rowId;
            }
            i = this.getNextCollectionStart(maxElementRepetitionLevel, i);
        }
        this.vector.addElementsAppended(rowId);
    }

    private void assembleStruct() {
        int maxRepetitionLevel = this.column.getRepetitionLevel();
        int maxDefinitionLevel = this.column.getDefinitionLevel();
        this.vector.reserve(this.definitionLevels.getElementsAppended());
        int rowId = 0;
        boolean hasRepetitionLevels = this.repetitionLevels != null && this.repetitionLevels.getElementsAppended() > 0;
        for (int i = 0; i < this.definitionLevels.getElementsAppended(); ++i) {
            if (hasRepetitionLevels && this.repetitionLevels.getInt(i) > maxRepetitionLevel) continue;
            if (this.definitionLevels.getInt(i) <= maxDefinitionLevel - 1) {
                this.vector.setNullAt(rowId);
                ++rowId;
                continue;
            }
            if (this.definitionLevels.getInt(i) < maxDefinitionLevel) continue;
            ++rowId;
        }
        this.vector.addElementsAppended(rowId);
    }

    private int getNextCollectionStart(int maxRepetitionLevel, int idx) {
        ++idx;
        while (idx < this.repetitionLevels.getElementsAppended() && this.repetitionLevels.getInt(idx) > maxRepetitionLevel) {
            ++idx;
        }
        return idx;
    }

    private int getCollectionSize(int maxRepetitionLevel, int idx) {
        int size = 1;
        ++idx;
        while (idx < this.repetitionLevels.getElementsAppended() && this.repetitionLevels.getInt(idx) > maxRepetitionLevel) {
            if (this.repetitionLevels.getInt(idx) <= maxRepetitionLevel + 1) {
                ++size;
            }
            ++idx;
        }
        return size;
    }
}

