/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.newreader;

import java.util.PrimitiveIterator;
import org.apache.paimon.format.parquet.newreader.ColumnarBatch;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.utils.LongIterator;

public class RowIndexGenerator {
    private LongIterator rowIndexIterator;

    public void initFromPageReadStore(PageReadStore pageReadStore) {
        final long startingRowIdx = pageReadStore.getRowIndexOffset().orElse(0L);
        final PrimitiveIterator.OfLong rowIndexes = pageReadStore.getRowIndexes().orElse(null);
        if (rowIndexes != null) {
            this.rowIndexIterator = new LongIterator(){

                public boolean hasNext() {
                    return rowIndexes.hasNext();
                }

                public long next() {
                    return rowIndexes.nextLong() + startingRowIdx;
                }
            };
        } else {
            long numRowsInRowGroup = pageReadStore.getRowCount();
            this.rowIndexIterator = LongIterator.fromRange((long)startingRowIdx, (long)(startingRowIdx + numRowsInRowGroup));
        }
    }

    public void populateRowIndex(ColumnarBatch columnarBatch) {
        columnarBatch.resetPositions(this.rowIndexIterator);
    }
}

