/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.thrift.TException;

public class HiveMetastoreClient
implements MetastoreClient {
    private static final String HIVE_LAST_UPDATE_TIME_PROP = "transient_lastDdlTime";
    private final Identifier identifier;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final List<String> partitionKeys;
    private final StorageDescriptor sd;
    private final String dataFilePath;

    HiveMetastoreClient(Identifier identifier, ClientPool<IMetaStoreClient, TException> clients) throws TException, InterruptedException {
        this.identifier = identifier;
        this.clients = clients;
        Table table = (Table)this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
        this.partitionKeys = table.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
        this.sd = table.getSd();
        this.dataFilePath = table.getParameters().containsKey(CoreOptions.DATA_FILE_PATH_DIRECTORY.key()) ? this.sd.getLocation() + "/" + (String)table.getParameters().get(CoreOptions.DATA_FILE_PATH_DIRECTORY.key()) : this.sd.getLocation();
    }

    public void addPartition(LinkedHashMap<String, String> partition) throws Exception {
        org.apache.hadoop.hive.metastore.api.Partition hivePartition = this.toHivePartition(partition, (int)(System.currentTimeMillis() / 1000L));
        this.clients.execute(client -> {
            try {
                client.add_partition(hivePartition);
            }
            catch (AlreadyExistsException alreadyExistsException) {
                // empty catch block
            }
        });
    }

    public void addPartitions(List<LinkedHashMap<String, String>> partitions) throws Exception {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        List hivePartitions = partitions.stream().map(partitionSpec -> this.toHivePartition((LinkedHashMap<String, String>)partitionSpec, currentTime)).collect(Collectors.toList());
        this.clients.execute(client -> client.add_partitions(hivePartitions, true, false));
    }

    public void alterPartition(Partition partition) throws Exception {
        Map spec = partition.spec();
        List partitionValues = this.partitionKeys.stream().map(spec::get).collect(Collectors.toList());
        HashMap<String, String> statistic = new HashMap<String, String>();
        statistic.put("numFiles", String.valueOf(partition.fileCount()));
        statistic.put("totalSize", String.valueOf(partition.fileSizeInBytes()));
        statistic.put("numRows", String.valueOf(partition.recordCount()));
        String modifyTimeSeconds = String.valueOf(partition.lastFileCreationTime() / 1000L);
        statistic.put("lastUpdateTime", modifyTimeSeconds);
        statistic.put(HIVE_LAST_UPDATE_TIME_PROP, modifyTimeSeconds);
        try {
            org.apache.hadoop.hive.metastore.api.Partition hivePartition = (org.apache.hadoop.hive.metastore.api.Partition)this.clients.run(client -> client.getPartition(this.identifier.getDatabaseName(), this.identifier.getObjectName(), partitionValues));
            hivePartition.setValues(partitionValues);
            hivePartition.setLastAccessTime((int)(partition.lastFileCreationTime() / 1000L));
            hivePartition.getParameters().putAll(statistic);
            this.clients.execute(client -> client.alter_partition(this.identifier.getDatabaseName(), this.identifier.getObjectName(), hivePartition));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void dropPartition(LinkedHashMap<String, String> partitionSpec) throws Exception {
        ArrayList<String> partitionValues = new ArrayList<String>(partitionSpec.values());
        try {
            this.clients.execute(client -> client.dropPartition(this.identifier.getDatabaseName(), this.identifier.getTableName(), partitionValues, false));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void dropPartitions(List<LinkedHashMap<String, String>> partitions) throws Exception {
        for (LinkedHashMap<String, String> partition : partitions) {
            this.dropPartition(partition);
        }
    }

    public void markPartitionDone(LinkedHashMap<String, String> partitionSpec) throws Exception {
        try {
            this.clients.execute(client -> client.markPartitionForEvent(this.identifier.getDatabaseName(), this.identifier.getTableName(), (Map)partitionSpec, PartitionEventType.LOAD_DONE));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void close() throws Exception {
    }

    public IMetaStoreClient client() throws TException, InterruptedException {
        return (IMetaStoreClient)this.clients.run(client -> client);
    }

    private org.apache.hadoop.hive.metastore.api.Partition toHivePartition(LinkedHashMap<String, String> partitionSpec, int currentTime) {
        org.apache.hadoop.hive.metastore.api.Partition hivePartition = new org.apache.hadoop.hive.metastore.api.Partition();
        StorageDescriptor newSd = new StorageDescriptor(this.sd);
        newSd.setLocation(this.dataFilePath + "/" + PartitionPathUtils.generatePartitionPath(partitionSpec));
        hivePartition.setDbName(this.identifier.getDatabaseName());
        hivePartition.setTableName(this.identifier.getTableName());
        hivePartition.setValues(new ArrayList<String>(partitionSpec.values()));
        hivePartition.setSd(newSd);
        hivePartition.setCreateTime(currentTime);
        hivePartition.setLastAccessTime(currentTime);
        return hivePartition;
    }

    public static class Factory
    implements MetastoreClient.Factory {
        private static final long serialVersionUID = 1L;
        private final Identifier identifier;
        private final SerializableHiveConf hiveConf;
        private final String clientClassName;
        private final Options options;

        public Factory(Identifier identifier, HiveConf hiveConf, String clientClassName, Options options) {
            this.identifier = identifier;
            this.hiveConf = new SerializableHiveConf(hiveConf);
            this.clientClassName = clientClassName;
            this.options = options;
        }

        public MetastoreClient create() {
            HiveConf conf = this.hiveConf.conf();
            try {
                return new HiveMetastoreClient(this.identifier, new CachedClientPool((Configuration)conf, this.options, this.clientClassName));
            }
            catch (TException e) {
                throw new RuntimeException("Can not get table " + this.identifier + " info from metastore.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted in call to new HiveMetastoreClient for table " + this.identifier, e);
            }
        }
    }
}

