/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.FormatTableOptions;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

class HiveTableUtils {
    HiveTableUtils() {
    }

    public static FormatTable convertToFormatTable(Table hiveTable) {
        FormatTable.Format format;
        if (HiveCatalog.isView(hiveTable)) {
            throw new UnsupportedOperationException("Hive view is not supported.");
        }
        Identifier identifier = new Identifier(hiveTable.getDbName(), hiveTable.getTableName());
        HashMap<String, String> options = new HashMap<String, String>(hiveTable.getParameters());
        List<String> partitionKeys = HiveTableUtils.getFieldNames(hiveTable.getPartitionKeys());
        RowType rowType = HiveTableUtils.createRowType(hiveTable);
        String comment = (String)options.remove("comment");
        String location = hiveTable.getSd().getLocation();
        SerDeInfo serdeInfo = hiveTable.getSd().getSerdeInfo();
        String serLib = serdeInfo.getSerializationLib().toLowerCase();
        String inputFormat = hiveTable.getSd().getInputFormat();
        if (serLib.contains("parquet")) {
            format = FormatTable.Format.PARQUET;
        } else if (serLib.contains("orc")) {
            format = FormatTable.Format.ORC;
        } else if (inputFormat.contains("Text")) {
            format = FormatTable.Format.CSV;
            options.put(FormatTableOptions.FIELD_DELIMITER.key(), serdeInfo.getParameters().getOrDefault("field.delim", "\u0001"));
        } else {
            throw new UnsupportedOperationException("Unsupported table: " + hiveTable);
        }
        return FormatTable.builder().identifier(identifier).rowType(rowType).partitionKeys(partitionKeys).location(location).format(format).options(options).comment(comment).build();
    }

    private static List<String> getFieldNames(List<FieldSchema> fieldSchemas) {
        ArrayList<String> names = new ArrayList<String>(fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            names.add(fs.getName());
        }
        return names;
    }

    public static RowType createRowType(Table table) {
        ArrayList<FieldSchema> allCols = new ArrayList<FieldSchema>(table.getSd().getCols());
        allCols.addAll(table.getPartitionKeys());
        Pair<String[], DataType[]> columnInformation = HiveTableUtils.extractColumnInformation(allCols);
        return RowType.builder().fields((DataType[])columnInformation.getRight(), (String[])columnInformation.getLeft()).build();
    }

    private static Pair<String[], DataType[]> extractColumnInformation(List<FieldSchema> allCols) {
        String[] colNames = new String[allCols.size()];
        DataType[] colTypes = new DataType[allCols.size()];
        for (int i = 0; i < allCols.size(); ++i) {
            FieldSchema fs = allCols.get(i);
            colNames[i] = fs.getName();
            colTypes[i] = HiveTypeUtils.toPaimonType(TypeInfoUtils.getTypeInfoFromTypeString((String)fs.getType()));
        }
        return Pair.of((Object)colNames, (Object)colTypes);
    }
}

