/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.hive.LegacyHiveClasses;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.PagedList;
import org.apache.paimon.TableType;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.catalog.TableMetadata;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveAlterTableUtils;
import org.apache.paimon.hive.HiveCatalogLoader;
import org.apache.paimon.hive.HiveCatalogLock;
import org.apache.paimon.hive.HiveCatalogLockContext;
import org.apache.paimon.hive.HiveCatalogLockFactory;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.hive.HiveTableUtils;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationHelper;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.hive.StorageLocationHelper;
import org.apache.paimon.hive.TBPropertiesLocationHelper;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.table.CatalogTableType;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.FormatTableOptions;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.HadoopUtils;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewImpl;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String PAIMON_TABLE_IDENTIFIER = "PAIMON";
    private static final String INPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonInputFormat";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonOutputFormat";
    private static final String SERDE_CLASS_NAME = "org.apache.paimon.hive.PaimonSerDe";
    private static final String STORAGE_HANDLER_CLASS_NAME = "org.apache.paimon.hive.PaimonStorageHandler";
    private static final String HIVE_PREFIX = "hive.";
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    private static final String HIVE_EXTERNAL_TABLE_PROP = "EXTERNAL";
    private static final int DEFAULT_TABLE_BATCH_SIZE = 300;
    private static final String HIVE_LAST_UPDATE_TIME_PROP = "transient_lastDdlTime";
    private final HiveConf hiveConf;
    private final String clientClassName;
    private final Options options;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final String warehouse;
    private final LocationHelper locationHelper;

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, String warehouse) {
        this(fileIO, hiveConf, clientClassName, new Options(), warehouse);
    }

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, Options options, String warehouse) {
        super(fileIO, options);
        this.hiveConf = hiveConf;
        this.clientClassName = clientClassName;
        this.options = options;
        this.warehouse = warehouse;
        boolean needLocationInProperties = hiveConf.getBoolean(HiveCatalogOptions.LOCATION_IN_PROPERTIES.key(), ((Boolean)HiveCatalogOptions.LOCATION_IN_PROPERTIES.defaultValue()).booleanValue());
        if (needLocationInProperties) {
            this.locationHelper = new TBPropertiesLocationHelper();
        } else {
            hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, warehouse);
            this.locationHelper = new StorageLocationHelper();
        }
        this.clients = new CachedClientPool((Configuration)hiveConf, options, clientClassName);
    }

    private boolean formatTableDisabled() {
        return (Boolean)this.options.get(CatalogOptions.FORMAT_TABLE_ENABLED) == false;
    }

    public Optional<CatalogLockFactory> defaultLockFactory() {
        return Optional.of(new HiveCatalogLockFactory());
    }

    public Optional<CatalogLockContext> lockContext() {
        return Optional.of(new HiveCatalogLockContext(new SerializableHiveConf(this.hiveConf), this.clientClassName, this.catalogOptions));
    }

    public Path getTableLocation(Identifier identifier) {
        Table table = null;
        try {
            table = this.getHmsTable(identifier);
        }
        catch (Catalog.TableNotExistException tableNotExistException) {
            // empty catch block
        }
        return this.getTableLocation(identifier, table);
    }

    private Pair<Path, Boolean> initialTableLocation(Map<String, String> tableOptions, Identifier identifier) {
        Path location;
        boolean externalTable;
        if (tableOptions.containsKey(CoreOptions.PATH.key())) {
            externalTable = true;
            location = new Path(tableOptions.get(CoreOptions.PATH.key()));
        } else {
            externalTable = this.usingExternalTable(tableOptions);
            location = this.getTableLocation(identifier, null);
        }
        return Pair.of((Object)location, (Object)externalTable);
    }

    private Path getTableLocation(Identifier identifier, @Nullable Table table) {
        try {
            String databaseName = identifier.getDatabaseName();
            String tableName = identifier.getTableName();
            Optional tablePath = (Optional)this.clients.run(client -> {
                if (table != null) {
                    String location = this.locationHelper.getTableLocation(table);
                    if (location != null) {
                        return Optional.of(new Path(location));
                    }
                } else {
                    String dbLocation = this.locationHelper.getDatabaseLocation(client.getDatabase(databaseName));
                    if (dbLocation != null) {
                        return Optional.of(new Path(dbLocation, tableName));
                    }
                }
                return Optional.empty();
            });
            return tablePath.orElse(super.getTableLocation(identifier));
        }
        catch (TException e) {
            throw new RuntimeException("Can not get table " + identifier + " from metastore.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDataTableLocation " + identifier, e);
        }
    }

    public List<String> listDatabases() {
        try {
            return (List)this.clients.run(IMetaStoreClient::getAllDatabases);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all databases", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listDatabases", e);
        }
    }

    protected void createDatabaseImpl(String name, Map<String, String> properties) {
        try {
            org.apache.hadoop.hive.metastore.api.Database database = this.convertToHiveDatabase(name, properties);
            Path databasePath = database.getLocationUri() == null ? this.newDatabasePath(name) : new Path(database.getLocationUri());
            this.locationHelper.createPathIfRequired(databasePath, this.fileIO);
            this.locationHelper.specifyDatabaseLocation(databasePath, database);
            this.clients.execute(client -> client.createDatabase(database));
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to create database " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase " + name, e);
        }
    }

    private org.apache.hadoop.hive.metastore.api.Database convertToHiveDatabase(String name, Map<String, String> properties) {
        org.apache.hadoop.hive.metastore.api.Database database = new org.apache.hadoop.hive.metastore.api.Database();
        database.setName(name);
        HashMap parameter = new HashMap();
        properties.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("owner")) {
                database.setOwnerName(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        database.setParameters(parameter);
        return database;
    }

    public Database getDatabaseImpl(String name) throws Catalog.DatabaseNotExistException {
        try {
            org.apache.hadoop.hive.metastore.api.Database database = (org.apache.hadoop.hive.metastore.api.Database)this.clients.run(client -> client.getDatabase(name));
            HashMap<String, String> options = new HashMap<String, String>(database.getParameters());
            if (database.getDescription() != null) {
                options.put("comment", database.getDescription());
            }
            if (database.getOwnerName() != null) {
                options.put("owner", database.getOwnerName());
            }
            if (database.getLocationUri() != null) {
                options.put("location", database.getLocationUri());
            }
            return Database.of((String)name, options, (String)database.getDescription());
        }
        catch (NoSuchObjectException e) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Failed to get database %s properties", name), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to loadDatabaseProperties " + name, e);
        }
    }

    private boolean metastorePartitioned(TableSchema schema) {
        CoreOptions options = CoreOptions.fromMap((Map)schema.options());
        return !schema.partitionKeys().isEmpty() && options.partitionedTableInMetastore() || options.tagToPartitionField() != null;
    }

    public void createPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        Table hmsTable;
        Identifier tableIdentifier = Identifier.create((String)identifier.getDatabaseName(), (String)identifier.getTableName());
        TableSchema schema = this.loadTableSchema(tableIdentifier, hmsTable = this.getHmsTable(tableIdentifier));
        if (!this.metastorePartitioned(schema)) {
            return;
        }
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        StorageDescriptor sd = hmsTable.getSd();
        String dataFilePath = this.getDataFilePath(tableIdentifier, hmsTable);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> hivePartitions = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        for (Map<String, String> partitionSpec : partitions) {
            org.apache.hadoop.hive.metastore.api.Partition hivePartition = new org.apache.hadoop.hive.metastore.api.Partition();
            StorageDescriptor newSd = new StorageDescriptor(sd);
            hivePartition.setDbName(identifier.getDatabaseName());
            hivePartition.setTableName(identifier.getTableName());
            hivePartition.setValues(new ArrayList<String>(partitionSpec.values()));
            hivePartition.setSd(newSd);
            hivePartition.setCreateTime(currentTime);
            hivePartition.setLastAccessTime(currentTime);
            String partitionLocation = this.getPartitionLocation(dataFilePath, partitionSpec);
            this.locationHelper.specifyPartitionLocation(hivePartition, partitionLocation);
            hivePartitions.add(hivePartition);
        }
        try {
            this.clients.execute(client -> client.add_partitions(hivePartitions, true, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dropPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        boolean tagToPart;
        TableSchema schema = this.loadTableSchema(identifier);
        CoreOptions options = CoreOptions.fromMap((Map)schema.options());
        boolean bl = tagToPart = options.tagToPartitionField() != null;
        if (this.metastorePartitioned(schema)) {
            List<Map<String, String>> metaPartitions = tagToPart ? partitions : this.removePartitionsExistsInOtherBranches(identifier, partitions);
            Table hmsTable = this.getHmsTable(identifier);
            boolean externalTable = this.isExternalTable(hmsTable);
            String dataFilePath = this.getDataFilePath(identifier, hmsTable);
            for (Map<String, String> part : metaPartitions) {
                ArrayList<String> partitionValues = new ArrayList<String>(part.values());
                try {
                    this.clients.execute(client -> client.dropPartition(identifier.getDatabaseName(), identifier.getTableName(), partitionValues, false));
                    if (externalTable) continue;
                    Path partitionLocation = new Path(this.getPartitionLocation(dataFilePath, part));
                    try {
                        if (!this.fileIO.exists(partitionLocation)) continue;
                        this.fileIO.deleteDirectoryQuietly(partitionLocation);
                    }
                    catch (Exception ee) {
                        LOG.error("Delete directory[{}] fail for table {} partition.", new Object[]{partitionLocation, identifier, ee});
                    }
                }
                catch (NoSuchObjectException partitionLocation) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!tagToPart) {
            super.dropPartitions(identifier, partitions);
        }
    }

    private String getDataFilePath(Identifier tableIdentifier, Table hmsTable) {
        String tableLocation = this.getTableLocation(tableIdentifier, hmsTable).toUri().toString();
        return hmsTable.getParameters().containsKey(CoreOptions.DATA_FILE_PATH_DIRECTORY.key()) ? tableLocation + "/" + (String)hmsTable.getParameters().get(CoreOptions.DATA_FILE_PATH_DIRECTORY.key()) : tableLocation;
    }

    private String getPartitionLocation(String dataFilePath, Map<String, String> partitionSpec) {
        return dataFilePath + "/" + PartitionPathUtils.generatePartitionPath(new LinkedHashMap<String, String>(partitionSpec));
    }

    public void alterPartitions(Identifier identifier, List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
        TableSchema tableSchema = this.loadTableSchema(identifier);
        if (!tableSchema.partitionKeys().isEmpty() && new CoreOptions(tableSchema.options()).partitionedTableInMetastore()) {
            for (PartitionStatistics partition : partitions) {
                Map spec = partition.spec();
                List partitionValues = tableSchema.partitionKeys().stream().map(spec::get).collect(Collectors.toList());
                HashMap<String, String> statistic = new HashMap<String, String>();
                statistic.put("numFiles", String.valueOf(partition.fileCount()));
                statistic.put("totalSize", String.valueOf(partition.fileSizeInBytes()));
                statistic.put("numRows", String.valueOf(partition.recordCount()));
                String modifyTimeSeconds = String.valueOf(partition.lastFileCreationTime() / 1000L);
                statistic.put("lastUpdateTime", modifyTimeSeconds);
                statistic.put(HIVE_LAST_UPDATE_TIME_PROP, modifyTimeSeconds);
                try {
                    org.apache.hadoop.hive.metastore.api.Partition hivePartition = (org.apache.hadoop.hive.metastore.api.Partition)this.clients.run(client -> client.getPartition(identifier.getDatabaseName(), identifier.getObjectName(), partitionValues));
                    hivePartition.setValues(partitionValues);
                    hivePartition.setLastAccessTime((int)(partition.lastFileCreationTime() / 1000L));
                    hivePartition.getParameters().putAll(statistic);
                    this.clients.execute(client -> client.alter_partition(identifier.getDatabaseName(), identifier.getObjectName(), hivePartition));
                }
                catch (NoSuchObjectException hivePartition) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void markDonePartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        try {
            this.clients.execute(client -> {
                for (Map partition : partitions) {
                    client.markPartitionForEvent(identifier.getDatabaseName(), identifier.getTableName(), partition, PartitionEventType.LOAD_DONE);
                }
            });
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (UnknownTableException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Partition> listPartitions(Identifier identifier) throws Catalog.TableNotExistException {
        FileStoreTable table = (FileStoreTable)this.getTable(identifier);
        String tagToPartitionField = table.coreOptions().tagToPartitionField();
        if (tagToPartitionField != null) {
            try {
                List partitions = (List)this.clients.run(client -> client.listPartitions(identifier.getDatabaseName(), identifier.getTableName(), (short)Short.MAX_VALUE));
                return partitions.stream().map(part -> {
                    Map parameters = part.getParameters();
                    long recordCount = Long.parseLong(parameters.getOrDefault("numRows", "1"));
                    long fileSizeInBytes = Long.parseLong(parameters.getOrDefault("totalSize", "1"));
                    long fileCount = Long.parseLong(parameters.getOrDefault("numFiles", "1"));
                    long lastFileCreationTime = Long.parseLong(parameters.getOrDefault("lastUpdateTime", System.currentTimeMillis() + ""));
                    return new Partition(Collections.singletonMap(tagToPartitionField, part.getValues().get(0)), recordCount, fileSizeInBytes, fileCount, lastFileCreationTime, false);
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return CatalogUtils.listPartitionsFromFileSystem((org.apache.paimon.table.Table)table);
    }

    private List<Map<String, String>> removePartitionsExistsInOtherBranches(Identifier identifier, List<Map<String, String>> inputs) throws Catalog.TableNotExistException {
        FileStoreTable mainTable = (FileStoreTable)this.getTable(new Identifier(identifier.getDatabaseName(), identifier.getTableName()));
        InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(mainTable.coreOptions().partitionDefaultName(), mainTable.rowType().project(mainTable.partitionKeys()), mainTable.partitionKeys().toArray(new String[0]), mainTable.coreOptions().legacyPartitionName());
        ArrayList<String> branchNames = new ArrayList<String>(mainTable.branchManager().branches());
        branchNames.add("main");
        HashSet<Map<String, String>> inputsToRemove = new HashSet<Map<String, String>>(inputs);
        for (String branchName : branchNames) {
            Optional branchSchema;
            if (branchName.equals(identifier.getBranchNameOrDefault()) || !(branchSchema = this.tableSchemaInFileSystem(mainTable.location(), branchName)).isPresent()) continue;
            mainTable.switchToBranch(branchName).newScan().withPartitionsFilter(new ArrayList<Map<String, String>>(inputsToRemove)).listPartitions().stream().map(arg_0 -> ((InternalRowPartitionComputer)partitionComputer).generatePartValues(arg_0)).forEach(inputsToRemove::remove);
        }
        return new ArrayList<Map<String, String>>(inputsToRemove);
    }

    protected void dropDatabaseImpl(String name) {
        try {
            org.apache.hadoop.hive.metastore.api.Database database = (org.apache.hadoop.hive.metastore.api.Database)this.clients.run(client -> client.getDatabase(name));
            String location = this.locationHelper.getDatabaseLocation(database);
            this.locationHelper.dropPathIfRequired(new Path(location), this.fileIO);
            this.clients.execute(client -> client.dropDatabase(name, true, false, true));
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to drop database " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropDatabase " + name, e);
        }
    }

    protected void alterDatabaseImpl(String name, List<PropertyChange> changes) {
        try {
            org.apache.hadoop.hive.metastore.api.Database database = (org.apache.hadoop.hive.metastore.api.Database)this.clients.run(client -> client.getDatabase(name));
            HashMap<String, String> parameter = new HashMap<String, String>(database.getParameters());
            Pair setPropertiesToRemoveKeys = PropertyChange.getSetPropertiesToRemoveKeys(changes);
            Map setProperties = (Map)setPropertiesToRemoveKeys.getLeft();
            Set removeKeys = (Set)setPropertiesToRemoveKeys.getRight();
            if (!setProperties.isEmpty()) {
                parameter.putAll(setProperties);
            }
            if (!removeKeys.isEmpty()) {
                parameter.keySet().removeAll(removeKeys);
            }
            org.apache.hadoop.hive.metastore.api.Database alterDatabase = this.convertToHiveDatabase(name, parameter);
            this.clients.execute(client -> client.alterDatabase(name, alterDatabase));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to alter database " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to alterDatabase " + name, e);
        }
    }

    protected List<String> listTablesImpl(String databaseName) {
        try {
            List tableNames = (List)this.clients.run(client -> client.getAllTables(databaseName));
            int batchSize = this.getBatchGetTableSize();
            List hmsTables = Lists.partition((List)tableNames, (int)batchSize).stream().flatMap(batchTableNames -> {
                try {
                    return ((List)this.clients.run(client -> client.getTableObjectsByName(databaseName, batchTableNames))).stream();
                }
                catch (TException e) {
                    throw new RuntimeException("Failed to getTableObjectsByName in database " + databaseName, e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted in call to getTableObjectsByName " + databaseName, e);
                }
            }).collect(Collectors.toList());
            ArrayList<String> result = new ArrayList<String>(hmsTables.size());
            for (Table table : hmsTables) {
                if (!HiveCatalog.isPaimonTable(table) && (this.formatTableDisabled() || !this.isFormatTable(table))) continue;
                result.add(table.getTableName());
            }
            return result;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables in database " + databaseName, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables " + databaseName, e);
        }
    }

    protected TableMetadata loadTableMetadata(Identifier identifier) throws Catalog.TableNotExistException {
        return this.loadTableMetadata(identifier, this.getHmsTable(identifier));
    }

    private TableMetadata loadTableMetadata(Identifier identifier, Table table) throws Catalog.TableNotExistException {
        return new TableMetadata(this.loadTableSchema(identifier, table), this.isExternalTable(table), identifier.getFullName() + "." + table.getCreateTime());
    }

    public TableSchema loadTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        Table table = this.getHmsTable(identifier);
        return this.loadTableSchema(identifier, table);
    }

    private TableSchema loadTableSchema(Identifier identifier, Table table) throws Catalog.TableNotExistException {
        if (HiveCatalog.isPaimonTable(table)) {
            return (TableSchema)this.tableSchemaInFileSystem(this.getTableLocation(identifier, table), identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
        }
        if (!this.formatTableDisabled()) {
            try {
                Schema schema = HiveTableUtils.tryToFormatSchema(table);
                return TableSchema.create((long)0L, (Schema)schema);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        throw new Catalog.TableNotExistException(identifier);
    }

    public View getView(Identifier identifier) throws Catalog.ViewNotExistException {
        Table table;
        try {
            table = this.getHmsTable(identifier);
        }
        catch (Catalog.TableNotExistException e) {
            throw new Catalog.ViewNotExistException(identifier);
        }
        if (!HiveCatalog.isView(table)) {
            throw new Catalog.ViewNotExistException(identifier);
        }
        RowType rowType = HiveTableUtils.createRowType(table);
        HashMap options = new HashMap(table.getParameters());
        String comment = (String)options.remove("comment");
        return new ViewImpl(identifier, rowType.getFields(), table.getViewExpandedText(), Collections.emptyMap(), comment, options);
    }

    public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws Catalog.ViewAlreadyExistException, Catalog.DatabaseNotExistException {
        this.getDatabase(identifier.getDatabaseName());
        try {
            this.getView(identifier);
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.ViewAlreadyExistException(identifier);
        }
        catch (Catalog.ViewNotExistException viewNotExistException) {
            Table hiveTable = org.apache.hadoop.hive.ql.metadata.Table.getEmptyTable((String)identifier.getDatabaseName(), (String)identifier.getObjectName());
            hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
            HashMap properties = new HashMap(view.options());
            if (view.comment().isPresent()) {
                properties.put("comment", view.comment().get());
            }
            hiveTable.setParameters(properties);
            hiveTable.setPartitionKeys(new ArrayList());
            hiveTable.setViewOriginalText(view.query());
            hiveTable.setViewExpandedText(view.query());
            hiveTable.setTableType(org.apache.hadoop.hive.metastore.TableType.VIRTUAL_VIEW.name());
            StorageDescriptor sd = hiveTable.getSd();
            List columns = view.rowType().getFields().stream().map(this::convertToFieldSchema).collect(Collectors.toList());
            sd.setCols(columns);
            try {
                this.clients.execute(client -> client.createTable(hiveTable));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
            }
            return;
        }
    }

    public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException {
        try {
            this.getView(identifier);
        }
        catch (Catalog.ViewNotExistException e) {
            if (ignoreIfNotExists) {
                return;
            }
            throw e;
        }
        try {
            this.clients.execute(client -> client.dropTable(identifier.getDatabaseName(), identifier.getTableName(), false, false, false));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop view " + identifier.getFullName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to drop view " + identifier.getFullName(), e);
        }
    }

    public List<String> listViews(String databaseName) throws Catalog.DatabaseNotExistException {
        if (CatalogUtils.isSystemDatabase((String)databaseName)) {
            return Collections.emptyList();
        }
        this.getDatabase(databaseName);
        try {
            return (List)this.clients.run(client -> client.getTables(databaseName, "*", org.apache.hadoop.hive.metastore.TableType.VIRTUAL_VIEW));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list views in database " + databaseName, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getTables " + databaseName, e);
        }
    }

    public PagedList<View> listViewDetailsPaged(String databaseName, Integer maxResults, String pageToken) throws Catalog.DatabaseNotExistException {
        if (CatalogUtils.isSystemDatabase((String)databaseName)) {
            return new PagedList(Collections.emptyList(), null);
        }
        this.getDatabase(databaseName);
        PagedList pagedViewNames = this.listViewsPaged(databaseName, maxResults, pageToken);
        return new PagedList(pagedViewNames.getElements().stream().map(viewName -> {
            try {
                return this.getView(Identifier.create((String)databaseName, (String)viewName));
            }
            catch (Catalog.ViewNotExistException ignored) {
                LOG.warn("view {}.{} does not exist", (Object)databaseName, viewName);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()), pagedViewNames.getNextPageToken());
    }

    public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.ViewAlreadyExistException {
        try {
            this.getView(fromView);
        }
        catch (Catalog.ViewNotExistException e) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.ViewNotExistException(fromView);
        }
        try {
            this.getView(toView);
            throw new Catalog.ViewAlreadyExistException(toView);
        }
        catch (Catalog.ViewNotExistException viewNotExistException) {
            this.renameHiveTable(fromView, toView);
            return;
        }
    }

    public void createFormatTable(Identifier identifier, Schema schema) {
        if (this.formatTableDisabled()) {
            throw new UnsupportedOperationException("Format table is not enabled for " + identifier);
        }
        List fields = schema.fields();
        List partitionKeys = schema.partitionKeys();
        List primaryKeys = schema.primaryKeys();
        Map options = schema.options();
        int highestFieldId = RowType.currentHighestFieldId((List)fields);
        TableSchema newSchema = new TableSchema(0L, fields, highestFieldId, partitionKeys, primaryKeys, options, schema.comment());
        try {
            Pair<Path, Boolean> pair = this.initialTableLocation(schema.options(), identifier);
            Path location = (Path)pair.getLeft();
            boolean externalTable = (Boolean)pair.getRight();
            Table hiveTable = this.createHiveFormatTable(identifier, newSchema, location, externalTable);
            this.clients.execute(client -> client.createTable(hiveTable));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
    }

    private boolean usingExternalTable(Map<String, String> tableOptions) {
        CatalogTableType tableType = (CatalogTableType)OptionsUtils.convertToEnum((Object)this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), CatalogTableType.MANAGED.toString()), CatalogTableType.class);
        String externalPropValue = tableOptions.getOrDefault(HIVE_EXTERNAL_TABLE_PROP.toLowerCase(), tableOptions.get(HIVE_EXTERNAL_TABLE_PROP.toUpperCase()));
        return CatalogTableType.EXTERNAL.equals((Object)tableType) || "TRUE".equalsIgnoreCase(externalPropValue);
    }

    protected void dropTableImpl(Identifier identifier, List<Path> externalPaths) {
        try {
            boolean externalTable = this.isExternalTable(this.getHmsTable(identifier));
            this.clients.execute(client -> client.dropTable(identifier.getDatabaseName(), identifier.getTableName(), !externalTable, false, true));
            if (externalTable) {
                return;
            }
            Path path = this.getTableLocation(identifier);
            try {
                if (this.fileIO.exists(path)) {
                    this.fileIO.deleteDirectoryQuietly(path);
                }
                for (Path externalPath : externalPaths) {
                    if (!this.fileIO.exists(externalPath)) continue;
                    this.fileIO.deleteDirectoryQuietly(externalPath);
                }
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
        }
        catch (Catalog.TableNotExistException | TException e) {
            throw new RuntimeException("Failed to drop table " + identifier.getFullName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable " + identifier.getFullName(), e);
        }
    }

    protected void createTableImpl(Identifier identifier, Schema schema) {
        TableSchema tableSchema;
        Pair<Path, Boolean> pair = this.initialTableLocation(schema.options(), identifier);
        Path location = (Path)pair.getLeft();
        boolean externalTable = (Boolean)pair.getRight();
        try {
            tableSchema = this.runWithLock(identifier, () -> this.schemaManager(identifier, location).createTable(schema, externalTable));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
        try {
            this.clients.execute(client -> client.createTable(this.createHiveTable(identifier, tableSchema, location, externalTable)));
        }
        catch (Exception e) {
            try {
                if (!externalTable) {
                    this.fileIO.deleteDirectoryQuietly(location);
                }
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{location, identifier, ee});
            }
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
    }

    private Table createHiveTable(Identifier identifier, TableSchema tableSchema, Path location, boolean externalTable) {
        HashMap<String, String> tblProperties;
        Map options = tableSchema.options();
        Preconditions.checkArgument((Options.fromMap((Map)options).get(CoreOptions.TYPE) != TableType.FORMAT_TABLE ? 1 : 0) != 0);
        if (this.syncAllProperties()) {
            tblProperties = new HashMap<String, String>(options);
            tblProperties.putAll(this.convertToPropertiesTableKey(tableSchema));
        } else {
            tblProperties = OptionsUtils.convertToPropertiesPrefixKey((Map)options, (String)HIVE_PREFIX);
            if (options.containsKey(CoreOptions.PARTITION_EXPIRATION_TIME.key())) {
                tblProperties.put(CoreOptions.PARTITION_EXPIRATION_TIME.key(), (String)options.get(CoreOptions.PARTITION_EXPIRATION_TIME.key()));
            }
            if (options.containsKey(CoreOptions.DATA_FILE_PATH_DIRECTORY.key())) {
                tblProperties.put(CoreOptions.DATA_FILE_PATH_DIRECTORY.key(), (String)options.get(CoreOptions.DATA_FILE_PATH_DIRECTORY.key()));
            }
        }
        Table table = this.newHmsTable(identifier, tblProperties, null, externalTable);
        this.updateHmsTable(table, identifier, tableSchema, null, location);
        return table;
    }

    private Table createHiveFormatTable(Identifier identifier, TableSchema tableSchema, Path location, boolean externalTable) {
        CoreOptions coreOptions = new CoreOptions(tableSchema.options());
        Preconditions.checkArgument((coreOptions.type() == TableType.FORMAT_TABLE ? 1 : 0) != 0);
        FormatTable.Format provider = FormatTable.parseFormat((String)coreOptions.formatType());
        HashMap<String, String> tblProperties = new HashMap<String, String>();
        Table table = this.newHmsTable(identifier, tblProperties, provider, externalTable);
        this.updateHmsTable(table, identifier, tableSchema, provider, location);
        return table;
    }

    protected void renameTableImpl(Identifier fromTable, Identifier toTable) {
        block5: {
            try {
                Path fromPath = this.getTableLocation(fromTable);
                Table table = this.renameHiveTable(fromTable, toTable);
                Path toPath = this.getTableLocation(toTable);
                if (this.isExternalTable(table) || fromPath.equals((Object)toPath) || new SchemaManager(this.fileIO, fromPath).listAllIds().isEmpty()) break block5;
                try {
                    this.fileIO.rename(fromPath, toPath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to rename changes of table " + toTable.getFullName() + " to underlying files.", e);
                }
                this.locationHelper.specifyTableLocation(table, toPath.toString());
                this.clients.execute(client -> client.alter_table(toTable.getDatabaseName(), toTable.getTableName(), table));
            }
            catch (TException e) {
                throw new RuntimeException("Failed to rename table " + fromTable.getFullName(), e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted in call to renameTable", e);
            }
        }
    }

    private Table renameHiveTable(Identifier fromTable, Identifier toTable) {
        try {
            String fromDB = fromTable.getDatabaseName();
            String fromTableName = fromTable.getTableName();
            Table table = (Table)this.clients.run(client -> client.getTable(fromDB, fromTableName));
            table.setDbName(toTable.getDatabaseName());
            table.setTableName(toTable.getTableName());
            this.clients.execute(client -> client.alter_table(fromDB, fromTableName, table));
            return table;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename table " + fromTable.getFullName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to renameTable", e);
        }
    }

    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        TableSchema schema;
        Table table = this.getHmsTable(identifier);
        if (!HiveCatalog.isPaimonTable(table)) {
            throw new UnsupportedOperationException("Only data table support alter table.");
        }
        SchemaManager schemaManager = this.schemaManager(identifier, this.getTableLocation(identifier));
        try {
            schema = this.runWithLock(identifier, () -> schemaManager.commitChanges(changes));
        }
        catch (RuntimeException | Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException | Catalog.TableNotExistException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to alter table " + identifier.getFullName(), e);
        }
        if (!"main".equals(identifier.getBranchNameOrDefault())) {
            return;
        }
        try {
            this.alterTableToHms(table, identifier, schema);
        }
        catch (Exception te) {
            schemaManager.deleteSchema(schema.id());
            throw new RuntimeException(te);
        }
    }

    private void alterTableToHms(Table table, Identifier identifier, TableSchema newSchema) throws TException, InterruptedException {
        this.updateHmsTablePars(table, newSchema);
        Path location = this.getTableLocation(identifier, table);
        this.updateHmsTable(table, identifier, newSchema, null, location);
        this.clients.execute(client -> HiveAlterTableUtils.alterTable(client, identifier, table));
    }

    public boolean caseSensitive() {
        return this.catalogOptions.getOptional(CatalogOptions.CASE_SENSITIVE).orElse(false);
    }

    protected boolean allowCustomTablePath() {
        return true;
    }

    public boolean syncAllProperties() {
        return (Boolean)this.catalogOptions.get(CatalogOptions.SYNC_ALL_PROPERTIES);
    }

    public void repairCatalog() {
        List databases;
        try {
            databases = this.listDatabasesInFileSystem(new Path(this.warehouse));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (String database : databases) {
            this.repairDatabase(database);
        }
    }

    public void repairDatabase(String databaseName) {
        List tables;
        CatalogUtils.checkNotSystemDatabase((String)databaseName);
        try {
            this.getDatabase(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            this.createDatabaseImpl(databaseName, Collections.emptyMap());
        }
        try {
            org.apache.hadoop.hive.metastore.api.Database database = (org.apache.hadoop.hive.metastore.api.Database)this.clients.run(client -> client.getDatabase(databaseName));
            tables = this.listTablesInFileSystem(new Path(this.locationHelper.getDatabaseLocation(database)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String table : tables) {
            try {
                this.repairTable(Identifier.create((String)databaseName, (String)table));
            }
            catch (Catalog.TableNotExistException tableNotExistException) {}
        }
    }

    public void repairTable(Identifier identifier) throws Catalog.TableNotExistException {
        CatalogUtils.checkNotBranch((Identifier)identifier, (String)"repairTable");
        CatalogUtils.checkNotSystemTable((Identifier)identifier, (String)"repairTable");
        Path location = this.getTableLocation(identifier);
        TableSchema tableSchema = (TableSchema)this.tableSchemaInFileSystem(location, identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
        try {
            Table newTable = null;
            try {
                Table table = this.getHmsTable(identifier);
                newTable = this.createHiveTable(identifier, tableSchema, location, this.isExternalTable(table));
                Preconditions.checkArgument((boolean)HiveCatalog.isPaimonTable(table), (String)"Table %s is not a paimon table in hive metastore.", (Object[])new Object[]{identifier.getFullName()});
                if (!newTable.getSd().getCols().equals(table.getSd().getCols()) || !newTable.getParameters().equals(table.getParameters())) {
                    this.alterTableToHms(table, identifier, tableSchema);
                }
            }
            catch (Catalog.TableNotExistException e) {
                if (newTable == null) {
                    newTable = this.createHiveTable(identifier, tableSchema, location, this.usingExternalTable(tableSchema.options()));
                }
                Table finalNewTable = newTable;
                this.clients.execute(client -> client.createTable(finalNewTable));
            }
            if (!tableSchema.partitionKeys().isEmpty() && !newTable.getPartitionKeys().isEmpty()) {
                CoreOptions options = new CoreOptions(tableSchema.options());
                InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(options.partitionDefaultName(), tableSchema.logicalPartitionType(), tableSchema.partitionKeys().toArray(new String[0]), options.legacyPartitionName());
                this.createPartitions(identifier, this.getTable(identifier).newReadBuilder().newScan().listPartitions().stream().map(arg_0 -> ((InternalRowPartitionComputer)partitionComputer).generatePartValues(arg_0)).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws Exception {
    }

    public String warehouse() {
        return this.warehouse;
    }

    public CatalogLoader catalogLoader() {
        return new HiveCatalogLoader(this.fileIO, new SerializableHiveConf(this.hiveConf), this.clientClassName, this.options, this.warehouse);
    }

    public Table getHmsTable(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return (Table)this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (TException e) {
            throw new RuntimeException("Cannot determine if table " + identifier.getFullName() + " is a paimon table.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to tableExists " + identifier.getFullName(), e);
        }
    }

    private static boolean isPaimonTable(Table table) {
        boolean isPaimonTable = INPUT_FORMAT_CLASS_NAME.equals(table.getSd().getInputFormat()) && OUTPUT_FORMAT_CLASS_NAME.equals(table.getSd().getOutputFormat());
        return isPaimonTable || LegacyHiveClasses.isPaimonTable(table);
    }

    private boolean isFormatTable(Table table) {
        try {
            HiveTableUtils.tryToFormatSchema(table);
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static boolean isView(Table table) {
        return table != null && org.apache.hadoop.hive.metastore.TableType.VIRTUAL_VIEW.name().equals(table.getTableType());
    }

    private boolean isExternalTable(Table table) {
        return table != null && org.apache.hadoop.hive.metastore.TableType.EXTERNAL_TABLE.name().equals(table.getTableType());
    }

    private Table newHmsTable(Identifier identifier, Map<String, String> tableParameters, @Nullable FormatTable.Format provider, boolean externalTable) {
        long currentTimeMillis = System.currentTimeMillis();
        Table table = new Table(identifier.getTableName(), identifier.getDatabaseName(), System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, null, Collections.emptyList(), tableParameters, null, null, externalTable ? org.apache.hadoop.hive.metastore.TableType.EXTERNAL_TABLE.name() : org.apache.hadoop.hive.metastore.TableType.MANAGED_TABLE.name());
        if (provider == null) {
            table.getParameters().put(TABLE_TYPE_PROP, PAIMON_TABLE_IDENTIFIER);
            table.getParameters().put("storage_handler", STORAGE_HANDLER_CLASS_NAME);
        } else {
            table.getParameters().put(TABLE_TYPE_PROP, provider.name());
            table.getParameters().put(CoreOptions.FILE_FORMAT.key(), provider.name().toLowerCase());
            table.getParameters().put(CoreOptions.TYPE.key(), TableType.FORMAT_TABLE.toString());
        }
        if (externalTable) {
            table.getParameters().put(HIVE_EXTERNAL_TABLE_PROP, "TRUE");
        }
        return table;
    }

    private String getSerdeClassName(@Nullable FormatTable.Format provider) {
        if (provider == null) {
            return SERDE_CLASS_NAME;
        }
        switch (provider) {
            case CSV: {
                return "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
            }
            case PARQUET: {
                return "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
            }
            case ORC: {
                return "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
            }
            case JSON: {
                return "org.apache.hive.hcatalog.data.JsonSerDe";
            }
        }
        return SERDE_CLASS_NAME;
    }

    private String getInputFormatName(@Nullable FormatTable.Format provider) {
        if (provider == null) {
            return INPUT_FORMAT_CLASS_NAME;
        }
        switch (provider) {
            case CSV: 
            case JSON: {
                return "org.apache.hadoop.mapred.TextInputFormat";
            }
            case PARQUET: {
                return "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
            }
            case ORC: {
                return "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat";
            }
        }
        return INPUT_FORMAT_CLASS_NAME;
    }

    private String getOutputFormatClassName(@Nullable FormatTable.Format provider) {
        if (provider == null) {
            return OUTPUT_FORMAT_CLASS_NAME;
        }
        switch (provider) {
            case CSV: 
            case JSON: {
                return "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat";
            }
            case PARQUET: {
                return "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
            }
            case ORC: {
                return "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat";
            }
        }
        return OUTPUT_FORMAT_CLASS_NAME;
    }

    private Map<String, String> setSerDeInfoParam(@Nullable FormatTable.Format provider) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (provider == FormatTable.Format.CSV) {
            param.put("field.delim", (String)this.options.get(FormatTableOptions.FIELD_DELIMITER));
        }
        return param;
    }

    private void updateHmsTable(Table table, Identifier identifier, TableSchema schema, @Nullable FormatTable.Format provider, Path location) {
        StorageDescriptor sd = table.getSd() != null ? table.getSd() : new StorageDescriptor();
        sd.setInputFormat(this.getInputFormatName(provider));
        sd.setOutputFormat(this.getOutputFormatClassName(provider));
        SerDeInfo serDeInfo = sd.getSerdeInfo() != null ? sd.getSerdeInfo() : new SerDeInfo();
        serDeInfo.setParameters(this.setSerDeInfoParam(provider));
        serDeInfo.setSerializationLib(this.getSerdeClassName(provider));
        sd.setSerdeInfo(serDeInfo);
        CoreOptions options = new CoreOptions(schema.options());
        if (options.partitionedTableInMetastore() && !schema.partitionKeys().isEmpty()) {
            Map fieldMap = schema.fields().stream().collect(Collectors.toMap(DataField::name, Function.identity()));
            ArrayList<FieldSchema> partitionFields = new ArrayList<FieldSchema>();
            for (String partitionKey : schema.partitionKeys()) {
                partitionFields.add(this.convertToFieldSchema((DataField)fieldMap.get(partitionKey)));
            }
            table.setPartitionKeys(partitionFields);
            HashSet partitionKeys = new HashSet(schema.partitionKeys());
            ArrayList<FieldSchema> normalFields = new ArrayList<FieldSchema>();
            for (DataField field : schema.fields()) {
                if (partitionKeys.contains(field.name())) continue;
                normalFields.add(this.convertToFieldSchema(field));
            }
            sd.setCols(normalFields);
        } else {
            if (options.tagToPartitionField() != null) {
                Preconditions.checkArgument((boolean)schema.partitionKeys().isEmpty(), (Object)"Partition table can not use timeTravelToPartitionField.");
                table.setPartitionKeys(Collections.singletonList(this.convertToFieldSchema(new DataField(0, options.tagToPartitionField(), (DataType)DataTypes.STRING()))));
            }
            sd.setCols(schema.fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        }
        table.setSd(sd);
        if (schema.comment() != null) {
            table.getParameters().put("comment", schema.comment());
        }
        if (location == null) {
            location = this.getTableLocation(identifier, table);
        }
        this.locationHelper.specifyTableLocation(table, location.toString());
    }

    private void updateHmsTablePars(Table table, TableSchema schema) {
        if (this.syncAllProperties()) {
            table.getParameters().putAll(schema.options());
            table.getParameters().putAll(this.convertToPropertiesTableKey(schema));
        } else {
            table.getParameters().putAll(OptionsUtils.convertToPropertiesPrefixKey((Map)schema.options(), (String)HIVE_PREFIX));
        }
    }

    private Map<String, String> convertToPropertiesTableKey(TableSchema tableSchema) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!tableSchema.primaryKeys().isEmpty()) {
            properties.put(CoreOptions.PRIMARY_KEY.key(), String.join((CharSequence)",", tableSchema.primaryKeys()));
        }
        if (!tableSchema.partitionKeys().isEmpty()) {
            properties.put(CoreOptions.PARTITION.key(), String.join((CharSequence)",", tableSchema.partitionKeys()));
        }
        if (!tableSchema.bucketKeys().isEmpty()) {
            properties.put(CoreOptions.BUCKET_KEY.key(), String.join((CharSequence)",", tableSchema.bucketKeys()));
        }
        return properties;
    }

    @VisibleForTesting
    public IMetaStoreClient getHmsClient() {
        try {
            return (IMetaStoreClient)this.clients.run(client -> client);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close hms client:", e);
        }
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.toTypeInfo(dataField.type()).getTypeName(), dataField.description());
    }

    private SchemaManager schemaManager(Identifier identifier, Path location) {
        return new SchemaManager(this.fileIO, location, identifier.getBranchNameOrDefault());
    }

    public <T> T runWithLock(Identifier identifier, Callable<T> callable) throws Exception {
        if (!this.lockEnabled()) {
            return callable.call();
        }
        HiveCatalogLock lock = new HiveCatalogLock(this.clients, HiveCatalogLock.checkMaxSleep(this.hiveConf), HiveCatalogLock.acquireTimeout(this.hiveConf));
        return (T)Lock.fromCatalog((CatalogLock)lock, (Identifier)identifier).runWithLock(callable);
    }

    public static HiveConf createHiveConf(@Nullable String hiveConfDir, @Nullable String hadoopConfDir, Configuration defaultHadoopConf) {
        if (StringUtils.isNullOrWhitespaceOnly((String)hiveConfDir)) {
            hiveConfDir = HiveCatalog.possibleHiveConfPath();
        }
        Configuration hadoopConf = defaultHadoopConf;
        if (!StringUtils.isNullOrWhitespaceOnly((String)hadoopConfDir) && !HadoopUtils.addHadoopConfIfFound((Configuration)hadoopConf, (String)hadoopConfDir, (Options)new Options())) {
            String possiableUsedConfFiles = "core-site.xml | hdfs-site.xml | yarn-site.xml | mapred-site.xml";
            throw new RuntimeException("Failed to load the hadoop conf from specified path:" + hadoopConfDir, new FileNotFoundException("Please check the path none of the conf files (" + possiableUsedConfFiles + ") exist in the folder."));
        }
        LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
        if (hiveConfDir != null) {
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            org.apache.hadoop.fs.Path hiveSite = new org.apache.hadoop.fs.Path(hiveConfDir, HIVE_SITE_FILE);
            if (!hiveSite.toUri().isAbsolute()) {
                hiveSite = new org.apache.hadoop.fs.Path(new File(hiveSite.toString()).toURI());
            }
            try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load hive-site.xml from specified path:" + hiveSite, e);
            }
            hiveConf.addResource(hiveSite);
            return hiveConf;
        }
        HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        URL hiveSite = Thread.currentThread().getContextClassLoader().getResource(HIVE_SITE_FILE);
        if (hiveSite != null) {
            LOG.info("Found {} in classpath: {}", (Object)HIVE_SITE_FILE, (Object)hiveSite);
            hiveConf.addResource(hiveSite);
        }
        return hiveConf;
    }

    public static Catalog createHiveCatalog(CatalogContext context) {
        FileIO fileIO;
        Path warehouse;
        HiveConf hiveConf = HiveCatalog.createHiveConf(context);
        Options options = context.options();
        String warehouseStr = (String)options.get(CatalogOptions.WAREHOUSE);
        if (warehouseStr == null) {
            warehouseStr = hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, HiveConf.ConfVars.METASTOREWAREHOUSE.defaultStrVal);
        }
        Path uri = (warehouse = new Path(warehouseStr)).toUri().getScheme() == null ? new Path(FileSystem.getDefaultUri((Configuration)hiveConf)) : warehouse;
        try {
            fileIO = FileIO.get((Path)uri, (CatalogContext)context);
            fileIO.checkOrMkdirs(warehouse);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new HiveCatalog(fileIO, hiveConf, (String)options.get(HiveCatalogOptions.METASTORE_CLIENT_CLASS), options, warehouse.toUri().toString());
    }

    public static HiveConf createHiveConf(CatalogContext context) {
        String uri = (String)context.options().get(CatalogOptions.URI);
        String hiveConfDir = (String)context.options().get(HiveCatalogOptions.HIVE_CONF_DIR);
        String hadoopConfDir = (String)context.options().get(HiveCatalogOptions.HADOOP_CONF_DIR);
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir, context.hadoopConf());
        context.options().toMap().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect:  either set " + CatalogOptions.URI.key() + " for paimon " + "hive" + " catalog or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. The may cause unpredictable consensus problem.");
        }
        return hiveConf;
    }

    public static String possibleHiveConfPath() {
        return System.getenv("HIVE_CONF_DIR");
    }

    public int getBatchGetTableSize() {
        try {
            int size = Integer.parseInt(this.hiveConf.get(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.varname, String.valueOf(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.getDefaultValue())));
            if (size < 1) {
                return 300;
            }
            return size;
        }
        catch (Exception e) {
            LOG.warn("parse batch size failed {}, use default batch size", (Object)this.hiveConf.get(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.varname), (Object)e);
            return 300;
        }
    }
}

