/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.clone;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.hive.clone.HivePartitionFiles;
import org.apache.paimon.hive.clone.HiveTableCloneExtractor;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.RowType;

public interface HiveCloneExtractor {
    public static final List<HiveCloneExtractor> EXTRACTORS = FactoryUtil.discoverFactories((ClassLoader)HiveCloneExtractor.class.getClassLoader(), HiveCloneExtractor.class);

    public boolean matches(Table var1);

    public List<FieldSchema> extractSchema(IMetaStoreClient var1, Table var2, String var3, String var4) throws Exception;

    public List<HivePartitionFiles> extractFiles(Map<String, String> var1, IMetaStoreClient var2, Table var3, FileIO var4, Identifier var5, RowType var6, String var7, @Nullable PartitionPredicate var8) throws Exception;

    public List<String> extractPartitionKeys(Table var1);

    public Map<String, String> extractOptions(Table var1);

    public boolean supportCloneSplits(String var1);

    public static HiveCloneExtractor getExtractor(Table table) {
        for (HiveCloneExtractor extractor : EXTRACTORS) {
            if (!extractor.matches(table)) continue;
            return extractor;
        }
        return HiveTableCloneExtractor.INSTANCE;
    }
}

