/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class HiveTypeUtilsTest {
    @Test
    public void testLogicalTypeToTypeInfo() {
        TypeInfo boolTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.BOOLEAN());
        Assertions.assertThat((String)boolTypeInfo.getTypeName()).isEqualTo("boolean");
        TypeInfo tinyintTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.TINYINT());
        Assertions.assertThat((String)tinyintTypeInfo.getTypeName()).isEqualTo("tinyint");
        TypeInfo smallintTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.SMALLINT());
        Assertions.assertThat((String)smallintTypeInfo.getTypeName()).isEqualTo("smallint");
        TypeInfo intTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.INT());
        Assertions.assertThat((String)intTypeInfo.getTypeName()).isEqualTo("int");
        TypeInfo bigintTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.BIGINT());
        Assertions.assertThat((String)bigintTypeInfo.getTypeName()).isEqualTo("bigint");
        TypeInfo floatTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.FLOAT());
        Assertions.assertThat((String)floatTypeInfo.getTypeName()).isEqualTo("float");
        TypeInfo doubleTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.DOUBLE());
        Assertions.assertThat((String)doubleTypeInfo.getTypeName()).isEqualTo("double");
        TypeInfo decimalTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.DECIMAL((int)38, (int)0));
        Assertions.assertThat((String)decimalTypeInfo.getTypeName()).isEqualTo("decimal(38,0)");
        TypeInfo decimal1TypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.DECIMAL((int)2, (int)2));
        Assertions.assertThat((String)decimal1TypeInfo.getTypeName()).isEqualTo("decimal(2,2)");
        TypeInfo charTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.CHAR((int)1));
        Assertions.assertThat((String)charTypeInfo.getTypeName()).isEqualTo("char(1)");
        TypeInfo maxLengthCharType = HiveTypeUtils.toTypeInfo((DataType)DataTypes.CHAR((int)Integer.MAX_VALUE));
        Assertions.assertThat((String)maxLengthCharType.getTypeName()).isEqualTo("string");
        TypeInfo varcharTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.VARCHAR((int)10));
        Assertions.assertThat((String)varcharTypeInfo.getTypeName()).isEqualTo("varchar(10)");
        TypeInfo maxLengthVarcharType = HiveTypeUtils.toTypeInfo((DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE));
        Assertions.assertThat((String)maxLengthVarcharType.getTypeName()).isEqualTo("string");
        TypeInfo binaryTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.BINARY((int)10));
        Assertions.assertThat((String)binaryTypeInfo.getTypeName()).isEqualTo("binary");
        TypeInfo varbinaryTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.VARBINARY((int)10));
        Assertions.assertThat((String)varbinaryTypeInfo.getTypeName()).isEqualTo("binary");
        TypeInfo dateTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.DATE());
        Assertions.assertThat((String)dateTypeInfo.getTypeName()).isEqualTo("date");
        TypeInfo timestampTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.TIMESTAMP());
        Assertions.assertThat((String)timestampTypeInfo.getTypeName()).isEqualTo("timestamp");
        TypeInfo arrayTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()));
        Assertions.assertThat((String)arrayTypeInfo.getTypeName()).isEqualTo("array<int>");
        TypeInfo mapTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.STRING()));
        Assertions.assertThat((String)mapTypeInfo.getTypeName()).isEqualTo("map<bigint,string>");
        TypeInfo rowTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(0, "id", (DataType)new IntType()), new DataField(1, "name", (DataType)new VarCharType(Integer.MAX_VALUE))}));
        Assertions.assertThat((String)rowTypeInfo.getTypeName()).isEqualTo("struct<id:int,name:string>");
        TypeInfo timestampWithLocalZoneTypeInfo = HiveTypeUtils.toTypeInfo((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE());
        Assertions.assertThat((String)timestampWithLocalZoneTypeInfo.getTypeName()).isEqualTo("timestamp");
    }
}

