/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.junit.Assert;

public class TestHiveMetastore {
    private static final int DEFAULT_POOL_SIZE = 15;
    private static File hiveLocalDir;
    private static String derbyPath;
    private HiveConf hiveConf;
    private ExecutorService executorService;
    private TServer server;
    private HiveMetaStore.HMSHandler baseHandler;

    private static void setup() {
        try {
            hiveLocalDir = Files.createTempDirectory("hive", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
            derbyPath = new File(hiveLocalDir, "metastore_db").getPath();
            File derbyLogFile = new File(hiveLocalDir, "derby.log");
            System.setProperty("derby.stream.error.file", derbyLogFile.getAbsolutePath());
            TestHiveMetastore.setupMetastoreDB("jdbc:derby:" + derbyPath + ";create=true");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                FileSystem fs;
                Path localDirPath = new Path(hiveLocalDir.getAbsolutePath());
                try {
                    fs = FileSystem.get((URI)localDirPath.toUri(), (Configuration)new Configuration());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String errMsg = "Failed to delete " + localDirPath;
                try {
                    if (!fs.delete(localDirPath, true)) {
                        Assert.assertFalse((String)errMsg, (boolean)fs.exists(localDirPath));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(errMsg, e);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup local dir for hive metastore", e);
        }
    }

    public void start(int port) {
        this.start(new HiveConf(new Configuration(), TestHiveMetastore.class), 15, port);
    }

    public void start() {
        this.start(new HiveConf(new Configuration(), TestHiveMetastore.class), 15, 9083);
    }

    public void start(HiveConf conf, int poolSize, int portNum) {
        try {
            TServerSocket socket = new TServerSocket(portNum);
            int port = socket.getServerSocket().getLocalPort();
            this.initConf(conf, port);
            this.hiveConf = conf;
            this.server = this.newThriftServer(socket, poolSize, this.hiveConf);
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.submit(() -> this.server.serve());
            System.setProperty(HiveConf.ConfVars.METASTOREURIS.varname, this.hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
            System.setProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TestHiveMetastore.warehouseDir());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start TestHiveMetastore", e);
        }
    }

    public void stop() throws Exception {
        this.reset();
        if (this.server != null) {
            this.server.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.baseHandler != null) {
            this.baseHandler.shutdown();
        }
        System.clearProperty(HiveConf.ConfVars.METASTOREURIS.varname);
        System.clearProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
    }

    public void reset() throws Exception {
        TestHiveMetastore.setup();
        Path warehouseRoot = new Path(hiveLocalDir.getAbsolutePath());
        FileSystem fs = FileSystem.get((URI)warehouseRoot.toUri(), (Configuration)this.hiveConf);
        for (FileStatus fileStatus : fs.listStatus(warehouseRoot)) {
            if (fileStatus.getPath().getName().equals("derby.log") || fileStatus.getPath().getName().equals("metastore_db")) continue;
            fs.delete(fileStatus.getPath(), true);
        }
    }

    private static String warehouseDir() {
        return "file:" + hiveLocalDir.getAbsolutePath();
    }

    private TServer newThriftServer(TServerSocket socket, int poolSize, HiveConf conf) throws Exception {
        HiveConf serverConf = new HiveConf(conf);
        serverConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:" + derbyPath + ";create=true");
        this.baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", serverConf);
        IHMSHandler handler = RetryingHMSHandler.getProxy((HiveConf)serverConf, (IHMSHandler)this.baseHandler, (boolean)false);
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor((TProcessor)new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler))).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(poolSize).maxWorkerThreads(poolSize);
        return new TThreadPoolServer(args);
    }

    private void initConf(HiveConf conf, int port) {
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://localhost:" + port);
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TestHiveMetastore.warehouseDir());
        conf.set(HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname, "false");
        conf.set(HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES.varname, "false");
        conf.set(HiveConf.ConfVars.HIVE_IN_TEST.varname, HiveConf.ConfVars.HIVE_IN_TEST.getDefaultValue());
    }

    private static void setupMetastoreDB(String dbURL) throws SQLException, IOException {
        Connection connection = DriverManager.getConnection(dbURL);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("hive-schema-3.1.0.derby.sql");
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            TestHiveMetastore.runScript(connection, reader);
        }
    }

    private static void runScript(Connection conn, Reader reader) throws SQLException, IOException {
        StringBuilder command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuilder();
                }
                if ((trimmedLine = line.trim()).startsWith("--") || trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (trimmedLine.endsWith(";")) {
                    command.append(line.substring(0, line.lastIndexOf(";")));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    statement.execute(command.toString());
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (IOException | SQLException e) {
            e.fillInStackTrace();
            throw e;
        }
        finally {
            conn.rollback();
        }
    }

    static {
        TestHiveMetastore.setup();
    }
}

