/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.paimon.hive.LocalZonedTimestampTypeUtils;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class HiveTypeUtils {
    public static TypeInfo toTypeInfo(DataType logicalType) {
        return (TypeInfo)logicalType.accept((DataTypeVisitor)PaimonToHiveTypeVisitor.INSTANCE);
    }

    public static DataType toPaimonType(String type) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)type);
        return HiveTypeUtils.toPaimonType(typeInfo);
    }

    public static DataType toPaimonType(TypeInfo typeInfo) {
        return HiveToPaimonTypeVisitor.visit(typeInfo);
    }

    private static class HiveToPaimonTypeVisitor {
        private HiveToPaimonTypeVisitor() {
        }

        static DataType visit(TypeInfo type) {
            return HiveToPaimonTypeVisitor.visit(type, new HiveToPaimonTypeVisitor());
        }

        static DataType visit(TypeInfo type, HiveToPaimonTypeVisitor visitor) {
            if (type instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)type;
                ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList typeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                RowType.Builder builder = RowType.builder();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    builder.field((String)fieldNames.get(i), HiveToPaimonTypeVisitor.visit((TypeInfo)typeInfos.get(i), visitor));
                }
                return builder.build();
            }
            if (type instanceof MapTypeInfo) {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)type;
                return DataTypes.MAP((DataType)HiveToPaimonTypeVisitor.visit(mapTypeInfo.getMapKeyTypeInfo(), visitor), (DataType)HiveToPaimonTypeVisitor.visit(mapTypeInfo.getMapValueTypeInfo(), visitor));
            }
            if (type instanceof ListTypeInfo) {
                ListTypeInfo listTypeInfo = (ListTypeInfo)type;
                return DataTypes.ARRAY((DataType)HiveToPaimonTypeVisitor.visit(listTypeInfo.getListElementTypeInfo(), visitor));
            }
            return visitor.atomic(type);
        }

        public DataType atomic(TypeInfo atomic) {
            if (LocalZonedTimestampTypeUtils.isHiveLocalZonedTimestampType(atomic)) {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE();
            }
            if (TypeInfoFactory.booleanTypeInfo.equals((Object)atomic)) {
                return DataTypes.BOOLEAN();
            }
            if (TypeInfoFactory.byteTypeInfo.equals((Object)atomic)) {
                return DataTypes.TINYINT();
            }
            if (TypeInfoFactory.shortTypeInfo.equals((Object)atomic)) {
                return DataTypes.SMALLINT();
            }
            if (TypeInfoFactory.intTypeInfo.equals((Object)atomic)) {
                return DataTypes.INT();
            }
            if (TypeInfoFactory.longTypeInfo.equals((Object)atomic)) {
                return DataTypes.BIGINT();
            }
            if (TypeInfoFactory.floatTypeInfo.equals((Object)atomic)) {
                return DataTypes.FLOAT();
            }
            if (TypeInfoFactory.doubleTypeInfo.equals((Object)atomic)) {
                return DataTypes.DOUBLE();
            }
            if (atomic instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)atomic;
                return DataTypes.DECIMAL((int)decimalTypeInfo.getPrecision(), (int)decimalTypeInfo.getScale());
            }
            if (atomic instanceof CharTypeInfo) {
                return DataTypes.CHAR((int)((CharTypeInfo)atomic).getLength());
            }
            if (atomic instanceof VarcharTypeInfo) {
                return DataTypes.VARCHAR((int)((VarcharTypeInfo)atomic).getLength());
            }
            if (TypeInfoFactory.stringTypeInfo.equals((Object)atomic)) {
                return DataTypes.VARCHAR((int)Integer.MAX_VALUE);
            }
            if (TypeInfoFactory.binaryTypeInfo.equals((Object)atomic)) {
                return DataTypes.VARBINARY((int)Integer.MAX_VALUE);
            }
            if (TypeInfoFactory.dateTypeInfo.equals((Object)atomic)) {
                return DataTypes.DATE();
            }
            if (TypeInfoFactory.timestampTypeInfo.equals((Object)atomic)) {
                return DataTypes.TIMESTAMP_MILLIS();
            }
            throw new UnsupportedOperationException("Not a supported type: " + atomic.getTypeName());
        }
    }

    private static class PaimonToHiveTypeVisitor
    extends DataTypeDefaultVisitor<TypeInfo> {
        private static final PaimonToHiveTypeVisitor INSTANCE = new PaimonToHiveTypeVisitor();

        private PaimonToHiveTypeVisitor() {
        }

        public TypeInfo visit(BooleanType booleanType) {
            return TypeInfoFactory.booleanTypeInfo;
        }

        public TypeInfo visit(TinyIntType tinyIntType) {
            return TypeInfoFactory.byteTypeInfo;
        }

        public TypeInfo visit(SmallIntType smallIntType) {
            return TypeInfoFactory.shortTypeInfo;
        }

        public TypeInfo visit(IntType intType) {
            return TypeInfoFactory.intTypeInfo;
        }

        public TypeInfo visit(BigIntType bigIntType) {
            return TypeInfoFactory.longTypeInfo;
        }

        public TypeInfo visit(FloatType floatType) {
            return TypeInfoFactory.floatTypeInfo;
        }

        public TypeInfo visit(DoubleType doubleType) {
            return TypeInfoFactory.doubleTypeInfo;
        }

        public TypeInfo visit(DecimalType decimalType) {
            return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        public TypeInfo visit(CharType charType) {
            if (charType.getLength() > 255) {
                return TypeInfoFactory.stringTypeInfo;
            }
            return TypeInfoFactory.getCharTypeInfo((int)charType.getLength());
        }

        public TypeInfo visit(VarCharType varCharType) {
            if (varCharType.getLength() > 65535) {
                return TypeInfoFactory.stringTypeInfo;
            }
            return TypeInfoFactory.getVarcharTypeInfo((int)varCharType.getLength());
        }

        public TypeInfo visit(BinaryType binaryType) {
            return TypeInfoFactory.binaryTypeInfo;
        }

        public TypeInfo visit(VarBinaryType varBinaryType) {
            return TypeInfoFactory.binaryTypeInfo;
        }

        public TypeInfo visit(DateType dateType) {
            return TypeInfoFactory.dateTypeInfo;
        }

        public TypeInfo visit(TimeType timeType) {
            return TypeInfoFactory.stringTypeInfo;
        }

        public TypeInfo visit(TimestampType timestampType) {
            return TypeInfoFactory.timestampTypeInfo;
        }

        public TypeInfo visit(LocalZonedTimestampType localZonedTimestampType) {
            return LocalZonedTimestampTypeUtils.hiveLocalZonedTimestampType();
        }

        public TypeInfo visit(ArrayType arrayType) {
            DataType elementType = arrayType.getElementType();
            return TypeInfoFactory.getListTypeInfo((TypeInfo)((TypeInfo)elementType.accept((DataTypeVisitor)this)));
        }

        public TypeInfo visit(MultisetType multisetType) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)((TypeInfo)multisetType.getElementType().accept((DataTypeVisitor)this)), (TypeInfo)TypeInfoFactory.intTypeInfo);
        }

        public TypeInfo visit(MapType mapType) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)((TypeInfo)mapType.getKeyType().accept((DataTypeVisitor)this)), (TypeInfo)((TypeInfo)mapType.getValueType().accept((DataTypeVisitor)this)));
        }

        public TypeInfo visit(RowType rowType) {
            List fieldNames = rowType.getFields().stream().map(DataField::name).collect(Collectors.toList());
            List typeInfos = rowType.getFields().stream().map(DataField::type).map(type -> (TypeInfo)type.accept((DataTypeVisitor)this)).collect(Collectors.toList());
            return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
        }

        protected TypeInfo defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }
}

