/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.source.DeletionFile;

public interface DeletionVector {
    public void delete(long var1);

    public void merge(DeletionVector var1);

    default public boolean checkedDelete(long position) {
        if (this.isDeleted(position)) {
            return false;
        }
        this.delete(position);
        return true;
    }

    public boolean isDeleted(long var1);

    public boolean isEmpty();

    public long getCardinality();

    public byte[] serializeToBytes();

    public static DeletionVector deserializeFromBytes(byte[] bytes) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int magicNum = buffer.getInt();
            if (magicNum == 1581511376) {
                return BitmapDeletionVector.deserializeFromByteBuffer(buffer);
            }
            throw new RuntimeException("Invalid magic number: " + magicNum);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize deletion vector", e);
        }
    }

    public static DeletionVector read(FileIO fileIO, DeletionFile deletionFile) throws IOException {
        Path path = new Path(deletionFile.path());
        try (SeekableInputStream input = fileIO.newInputStream(path);){
            input.seek(deletionFile.offset());
            DataInputStream dis = new DataInputStream(input);
            int actualSize = dis.readInt();
            if ((long)actualSize != deletionFile.length()) {
                throw new RuntimeException("Size not match, actual size: " + actualSize + ", expected size: " + deletionFile.length() + ", file path: " + path);
            }
            byte[] bytes = new byte[actualSize];
            dis.readFully(bytes);
            DeletionVector deletionVector = DeletionVector.deserializeFromBytes(bytes);
            return deletionVector;
        }
    }

    public static Factory emptyFactory() {
        return fileName -> Optional.empty();
    }

    public static Factory factory(@Nullable DeletionVectorsMaintainer dvMaintainer) {
        if (dvMaintainer == null) {
            return DeletionVector.emptyFactory();
        }
        return dvMaintainer::deletionVectorOf;
    }

    public static Factory factory(FileIO fileIO, List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles) {
        DeletionFile.Factory factory2 = DeletionFile.factory(files, deletionFiles);
        return fileName -> {
            Optional<DeletionFile> deletionFile = factory2.create(fileName);
            if (deletionFile.isPresent()) {
                return Optional.of(DeletionVector.read(fileIO, deletionFile.get()));
            }
            return Optional.empty();
        };
    }

    public static interface Factory {
        public Optional<DeletionVector> create(String var1) throws IOException;
    }
}

