/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.StringUtils;

public class FieldListaggAgg
extends FieldAggregator {
    public static final String NAME = "listagg";
    private final String delimiter;

    public FieldListaggAgg(DataType dataType, CoreOptions options, String field) {
        super(dataType);
        this.delimiter = options.fieldListAggDelimiter(field);
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        Object concatenate;
        if (inputField == null || accumulator == null) {
            concatenate = inputField == null ? accumulator : inputField;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case VARCHAR: {
                    BinaryString mergeFieldSD = (BinaryString)accumulator;
                    BinaryString inFieldSD = (BinaryString)inputField;
                    concatenate = StringUtils.concat(mergeFieldSD, BinaryString.fromString(this.delimiter), inFieldSD);
                    break;
                }
                default: {
                    String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        return concatenate;
    }
}

