/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.metrics.ScanStats;

public class ScanMetrics {
    private static final int HISTOGRAM_WINDOW_SIZE = 100;
    public static final String GROUP_NAME = "scan";
    private final MetricGroup metricGroup;
    private Histogram durationHistogram;
    private ScanStats latestScan;
    public static final String LAST_SCAN_DURATION = "lastScanDuration";
    public static final String SCAN_DURATION = "scanDuration";
    public static final String LAST_SCANNED_MANIFESTS = "lastScannedManifests";
    public static final String LAST_SKIPPED_BY_PARTITION_AND_STATS = "lastSkippedByPartitionAndStats";
    public static final String LAST_SKIPPED_BY_BUCKET_AND_LEVEL_FILTER = "lastSkippedByBucketAndLevelFilter";
    public static final String LAST_SKIPPED_BY_WHOLE_BUCKET_FILES_FILTER = "lastSkippedByWholeBucketFilesFilter";
    public static final String LAST_SCAN_SKIPPED_TABLE_FILES = "lastScanSkippedTableFiles";
    public static final String LAST_SCAN_RESULTED_TABLE_FILES = "lastScanResultedTableFiles";

    public ScanMetrics(MetricRegistry registry, String tableName) {
        this.metricGroup = registry.tableMetricGroup(GROUP_NAME, tableName);
        this.registerGenericScanMetrics();
    }

    @VisibleForTesting
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    private void registerGenericScanMetrics() {
        this.metricGroup.gauge(LAST_SCAN_DURATION, () -> this.latestScan == null ? 0L : this.latestScan.getDuration());
        this.durationHistogram = this.metricGroup.histogram(SCAN_DURATION, 100);
        this.metricGroup.gauge(LAST_SCANNED_MANIFESTS, () -> this.latestScan == null ? 0L : this.latestScan.getScannedManifests());
        this.metricGroup.gauge(LAST_SKIPPED_BY_PARTITION_AND_STATS, () -> this.latestScan == null ? 0L : this.latestScan.getSkippedByPartitionAndStats());
        this.metricGroup.gauge(LAST_SKIPPED_BY_BUCKET_AND_LEVEL_FILTER, () -> this.latestScan == null ? 0L : this.latestScan.getSkippedByBucketAndLevelFilter());
        this.metricGroup.gauge(LAST_SKIPPED_BY_WHOLE_BUCKET_FILES_FILTER, () -> this.latestScan == null ? 0L : this.latestScan.getSkippedByWholeBucketFiles());
        this.metricGroup.gauge(LAST_SCAN_SKIPPED_TABLE_FILES, () -> this.latestScan == null ? 0L : this.latestScan.getSkippedTableFiles());
        this.metricGroup.gauge(LAST_SCAN_RESULTED_TABLE_FILES, () -> this.latestScan == null ? 0L : this.latestScan.getResultedTableFiles());
    }

    public void reportScan(ScanStats scanStats) {
        this.latestScan = scanStats;
        this.durationHistogram.update(scanStats.getDuration());
    }
}

