/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.tag.TagPreview;
import org.apache.paimon.types.RowType;

public class HiveSplitGenerator {
    public static InputSplit[] generateSplits(FileStoreTable table, JobConf jobConf) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        HiveUtils.createPredicate(table.schema(), jobConf, false).ifPresent(predicates::add);
        String locations = jobConf.get("mapreduce.input.fileinputformat.inputdir");
        String tagToPartField = table.coreOptions().tagToPartitionField();
        TagPreview tagPreview = TagPreview.create(table.coreOptions());
        ArrayList splits = new ArrayList();
        for (String location : locations.split(",")) {
            DataTableScan scan;
            if (tagToPartField != null) {
                String tag = HiveUtils.extractTagName(location, tagToPartField);
                Map<String, String> dynamicOptions = tagPreview == null ? Collections.singletonMap(CoreOptions.SCAN_TAG_NAME.key(), tag) : tagPreview.timeTravel(table, tag);
                scan = table.copy((Map)dynamicOptions).newScan();
                if (predicates.size() > 0) {
                    scan.withFilter(PredicateBuilder.and(predicates));
                }
            } else {
                ArrayList<Predicate> predicatePerPartition = new ArrayList<Predicate>(predicates);
                HiveSplitGenerator.createPartitionPredicate(table.schema().logicalRowType(), table.schema().partitionKeys(), location, table.coreOptions().partitionDefaultName()).ifPresent(predicatePerPartition::add);
                scan = table.newScan();
                if (predicatePerPartition.size() > 0) {
                    scan.withFilter(PredicateBuilder.and(predicatePerPartition));
                }
            }
            scan.dropStats().plan().splits().forEach(split -> splits.add(new PaimonInputSplit(location, (DataSplit)split, table)));
        }
        return splits.toArray(new InputSplit[0]);
    }

    private static Optional<Predicate> createPartitionPredicate(RowType rowType, List<String> partitionKeys, String partitionDir, String defaultPartName) {
        HashSet<String> partitionKeySet = new HashSet<String>(partitionKeys);
        LinkedHashMap<String, String> partition = new LinkedHashMap<String, String>();
        for (String s : partitionDir.split("/")) {
            String[] kv;
            if ((s = s.trim()).isEmpty() || (kv = s.split("=")).length != 2 || !partitionKeySet.contains(kv[0])) continue;
            partition.put(kv[0], kv[1]);
        }
        if (partition.isEmpty() || partition.size() != partitionKeys.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(PartitionPredicate.createPartitionPredicate(partition, rowType, defaultPartName));
    }
}

