/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.migrate;

import java.io.IOException;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.metadata.IcebergMetadata;
import org.apache.paimon.iceberg.migrate.IcebergMigrateMetadata;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMigrateHadoopMetadata
implements IcebergMigrateMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergMigrateHadoopMetadata.class);
    private static final String VERSION_HINT_FILENAME = "version-hint.text";
    private static final String ICEBERG_WAREHOUSE = "iceberg_warehouse";
    private final Identifier icebergIdentifier;
    private final Options icebergOptions;
    private Path icebergLatestMetaVersionPath;
    private IcebergPathFactory icebergMetaPathFactory;
    private FileIO fileIO;

    public IcebergMigrateHadoopMetadata(Identifier icebergIdentifier, Options icebergOptions) {
        this.icebergIdentifier = icebergIdentifier;
        this.icebergOptions = icebergOptions;
    }

    @Override
    public IcebergMetadata icebergMetadata() {
        Preconditions.checkArgument(this.icebergOptions.get(ICEBERG_WAREHOUSE) != null, "'iceberg_warehouse' is null. In hadoop-catalog, you should explicitly set this argument for finding iceberg metadata.");
        Path icebergWarehouse = new Path(this.icebergOptions.get(ICEBERG_WAREHOUSE));
        try {
            this.fileIO = FileIO.get(icebergWarehouse, CatalogContext.create(this.icebergOptions));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.icebergMetaPathFactory = new IcebergPathFactory(new Path(icebergWarehouse, new Path(String.format("%s/%s/metadata", this.icebergIdentifier.getDatabaseName(), this.icebergIdentifier.getTableName()))));
        long icebergLatestMetaVersion = this.getIcebergLatestMetaVersion();
        this.icebergLatestMetaVersionPath = this.icebergMetaPathFactory.toMetadataPath(icebergLatestMetaVersion);
        LOG.info("iceberg latest snapshot metadata file location: {}", (Object)this.icebergLatestMetaVersionPath);
        return IcebergMetadata.fromPath(this.fileIO, this.icebergLatestMetaVersionPath);
    }

    @Override
    public String icebergLatestMetadataLocation() {
        return this.icebergLatestMetaVersionPath.toString();
    }

    @Override
    public void deleteOriginTable() {
        Path tablePath = this.icebergMetaPathFactory.metadataDirectory().getParent();
        LOG.info("Iceberg table path to be deleted:{}", (Object)tablePath);
        try {
            if (this.fileIO.isDir(tablePath)) {
                this.fileIO.deleteDirectoryQuietly(tablePath);
            }
        }
        catch (IOException e) {
            LOG.warn("exception occurred when deleting origin table.", (Throwable)e);
        }
    }

    private long getIcebergLatestMetaVersion() {
        Path versionHintPath = new Path(this.icebergMetaPathFactory.metadataDirectory(), VERSION_HINT_FILENAME);
        try {
            return Integer.parseInt(this.fileIO.readFileUtf8(versionHintPath));
        }
        catch (IOException e) {
            throw new RuntimeException("read iceberg version-hint.text failed. Iceberg metadata path: " + this.icebergMetaPathFactory.metadataDirectory(), e);
        }
    }
}

