/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.FileWriterContext;
import org.apache.paimon.io.SimpleStatsProducer;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    private final RowType rowType;
    private final SimpleStatsProducer statsProducer;
    private final boolean isStatsDisabled;
    private final boolean statsRequirePerRecord;

    public StatsCollectingSingleFileWriter(FileIO fileIO, FileWriterContext context, Path path, Function<T, InternalRow> converter, RowType rowType, boolean asyncWrite) {
        super(fileIO, context.factory(), path, converter, context.compression(), asyncWrite);
        this.rowType = rowType;
        this.statsProducer = context.statsProducer();
        this.isStatsDisabled = this.statsProducer.isStatsDisabled();
        this.statsRequirePerRecord = this.statsProducer.requirePerRecord();
    }

    @Override
    public void write(T record) throws IOException {
        InternalRow rowData = this.writeImpl(record);
        if (!this.isStatsDisabled && this.statsRequirePerRecord) {
            this.statsProducer.collect(rowData);
        }
    }

    @Override
    public void writeBundle(BundleRecords bundle) throws IOException {
        if (this.statsRequirePerRecord) {
            throw new IllegalArgumentException(String.format("Can't write bundle for %s, we may lose all the statistical information.", this.statsProducer.getClass().getName()));
        }
        super.writeBundle(bundle);
    }

    public SimpleColStats[] fieldStats(long fileSize) throws IOException {
        Preconditions.checkState(this.closed, "Cannot access metric unless the writer is closed.");
        if (this.isStatsDisabled) {
            return (SimpleColStats[])IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> SimpleColStats.NONE).toArray(SimpleColStats[]::new);
        }
        return this.statsProducer.extract(this.fileIO, this.path, fileSize);
    }
}

