/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.HiveTestBase;
import org.apache.paimon.hive.PaimonMetaHook;
import org.apache.paimon.hive.PaimonStorageHandler;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CreateTableITCase
extends HiveTestBase {
    @Test
    public void testCreateExternalTableWithoutPaimonTable() {
        String tableName = "without_paimon_table";
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + this.path + "'"));
        Assertions.assertThatThrownBy(() -> hiveShell.execute(hiveSql)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Schema file not found in location file:" + this.path + ". Please create table first.");
    }

    @Test
    public void testCreateExternalTableWithPaimonTable() throws Exception {
        String tableName = "with_paimon_table";
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new DataField[]{new DataField(0, "col1", (DataType)DataTypes.INT(), "first comment"), new DataField(1, "Col2", (DataType)DataTypes.STRING(), "second comment"), new DataField(2, "COL3", (DataType)DataTypes.DECIMAL((int)5, (int)3), "last comment")}), Collections.emptyList(), Collections.emptyList(), (Map)Maps.newHashMap(), "");
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        new SchemaManager((FileIO)LocalFileIO.create(), tablePath).createTable(schema);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath.toUri().toString() + "'"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        List result = hiveShell.executeQuery("SHOW CREATE TABLE " + tableName);
        Assertions.assertThat((List)result).containsAnyOf((Object[])new String[]{"CREATE EXTERNAL TABLE `with_paimon_table`(", "  `col1` int COMMENT 'first comment', ", "  `col2` string COMMENT 'second comment', ", "  `col3` decimal(5,3) COMMENT 'last comment')", "ROW FORMAT SERDE ", "  'org.apache.paimon.hive.PaimonSerDe' ", "STORED BY ", "  'org.apache.paimon.hive.PaimonStorageHandler' "});
    }

    @Test
    public void testCreateTableUsePartitionedBy() {
        String tableName = "support_partitioned_by_table";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field'", ")", "PARTITIONED BY ( ", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).primaryKeys()).contains((Object[])new String[]{"dt", "hh", "user_id"});
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).partitionKeys()).contains((Object[])new String[]{"dt", "hh"});
        Assertions.assertThat((Map)((TableSchema)tableSchema.get()).options()).containsEntry((Object)CoreOptions.METASTORE_PARTITIONED_TABLE.key(), (Object)"true");
    }

    @Test
    public void testLowerTableName() throws Catalog.TableNotExistException {
        String tableName = "UPPER_NAME";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field'", ")", "PARTITIONED BY ( ", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        List queryResult = hiveShell.executeQuery(String.format("describe formatted %s", tableName));
        for (String result : queryResult) {
            if (!result.contains("Location")) continue;
            String location = result.split("\t")[1];
            String tableNameFromPath = location.substring(location.lastIndexOf("/") + 1);
            Assertions.assertThat((String)tableNameFromPath).isEqualTo(tableName.toLowerCase());
        }
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName.toLowerCase());
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.path);
        CatalogContext catalogContext = CatalogContext.create((Options)conf);
        Catalog catalog = CatalogFactory.createCatalog((CatalogContext)catalogContext);
        org.apache.paimon.table.Table table = catalog.getTable(identifier);
        Assertions.assertThat((String)table.name()).isEqualTo(tableName.toLowerCase());
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
    }

    @Test
    public void testLowerDBName() throws Catalog.TableNotExistException {
        String upperDB = "UPPER_DB";
        hiveShell.execute(String.format("create database %s", upperDB));
        String tableName = "UPPER_NAME";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + upperDB + "." + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field'", ")", "PARTITIONED BY ( ", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        hiveShell.execute("USE " + upperDB);
        List queryResult = hiveShell.executeQuery(String.format("describe formatted %s", tableName));
        for (String result : queryResult) {
            if (!result.contains("Location")) continue;
            String location = result.split("\t")[1];
            int index = location.lastIndexOf(upperDB.toLowerCase() + ".db");
            Assertions.assertThat((int)index).isGreaterThan(0);
            String dbNameFromPath = location.substring(index, location.lastIndexOf("/"));
            Assertions.assertThat((String)dbNameFromPath).isEqualTo(upperDB.toLowerCase() + ".db");
        }
        Identifier identifier = Identifier.create((String)upperDB.toLowerCase(), (String)tableName.toLowerCase());
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.path);
        CatalogContext catalogContext = CatalogContext.create((Options)conf);
        Catalog catalog = CatalogFactory.createCatalog((CatalogContext)catalogContext);
        org.apache.paimon.table.Table table = catalog.getTable(identifier);
        Assertions.assertThat((String)table.name()).isEqualTo(tableName.toLowerCase());
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
    }

    @Test
    public void testCreateTableWithPrimaryKey() {
        String tableName = "primary_key_table";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field',", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).primaryKeys()).contains((Object[])new String[]{"dt", "hh", "user_id"});
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).partitionKeys()).isEmpty();
    }

    @Test
    public void testCreateTableWithPartition() {
        String tableName = "partition_table";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field',", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id',", "  'partition'='dt,hh'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).primaryKeys()).contains((Object[])new String[]{"dt", "hh", "user_id"});
        Assertions.assertThat((List)((TableSchema)tableSchema.get()).partitionKeys()).contains((Object[])new String[]{"dt", "hh"});
    }

    @Test
    public void testCreateTableSpecifyProperties() {
        String tableName = "specify_properties_table";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "item_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The item_id field',", "behavior " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The behavior field',", "dt " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The dt field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "TBLPROPERTIES (", "  'primary-key'='dt,hh,user_id',", "  'partition'='dt,hh',", "  'bucket' = '2',", "  'bucket-key' = 'user_id'", ")"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        Optional tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
        Assertions.assertThat((Map)((TableSchema)tableSchema.get()).options()).containsEntry((Object)"bucket", (Object)"2");
        Assertions.assertThat((Map)((TableSchema)tableSchema.get()).options()).containsEntry((Object)"bucket-key", (Object)"user_id");
    }

    @Test
    public void testCreateTableIsPaimonSystemTable() {
        String tableName = "test$schema";
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "col1 " + TypeInfoFactory.intTypeInfo.getTypeName() + " COMMENT 'The col1 field'", ")", "STORED BY '" + PaimonStorageHandler.class.getName() + "'"));
        Assertions.assertThatThrownBy(() -> hiveShell.execute(hiveSql)).hasRootCauseInstanceOf(ParseException.class).hasMessageContaining("cannot recognize input near 'test' '$' 'schema' in table name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableFailing() throws Exception {
        String tableName = "tes1";
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new DataField[]{new DataField(0, "col1", (DataType)DataTypes.INT(), "first comment"), new DataField(1, "col2", (DataType)DataTypes.STRING(), "second comment"), new DataField(2, "col3", (DataType)DataTypes.DECIMAL((int)5, (int)3), "last comment"), new DataField(3, "col4", (DataType)DataTypes.DECIMAL((int)5, (int)3), "last comment")}), Collections.emptyList(), Collections.emptyList(), (Map)Maps.newHashMap(), "");
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        new SchemaManager((FileIO)LocalFileIO.create(), tablePath).createTable(schema);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + MockPaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath.toUri().toString() + "'"));
        try {
            hiveShell.execute(hiveSql);
        }
        catch (Throwable isPresent) {
        }
        finally {
            boolean isPresent = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest().isPresent();
            Assertions.assertThat((boolean)isPresent).isTrue();
        }
        tableName = "tes2";
        hiveShell.execute("SET hive.metastore.warehouse.dir=" + this.path);
        String hiveSql2 = String.join((CharSequence)"\n", Arrays.asList("CREATE TABLE " + tableName + " (", "user_id " + TypeInfoFactory.longTypeInfo.getTypeName() + " COMMENT 'The user_id field',", "hh " + TypeInfoFactory.stringTypeInfo.getTypeName() + " COMMENT 'The hh field'", ")", "STORED BY '" + MockPaimonStorageHandler.class.getName() + "'"));
        try {
            hiveShell.execute(hiveSql2);
        }
        catch (Exception identifier2) {
        }
        finally {
            identifier = Identifier.create((String)"test_db", (String)tableName);
            tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
            boolean isPresent = new SchemaManager((FileIO)LocalFileIO.create(), tablePath).latest().isPresent();
            Assertions.assertThat((boolean)isPresent).isFalse();
        }
    }

    public static class MockPaimonStorageHandler
    extends PaimonStorageHandler {
        public HiveMetaHook getMetaHook() {
            return new MockPaimonMetaHook(this.getConf());
        }
    }

    public static class MockPaimonMetaHook
    extends PaimonMetaHook {
        public MockPaimonMetaHook(Configuration conf) {
            super(conf);
        }

        public void commitCreateTable(Table table) throws MetaException {
            throw new RuntimeException("mock create table failed");
        }
    }
}

