/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.FlinkGenericCatalog;
import org.apache.paimon.flink.FlinkGenericCatalogFactory;
import org.apache.paimon.hive.annotation.Minio;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.s3.MinioTestContainer;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public class FlinkGenericCatalogITCase
extends AbstractTestBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    protected TableEnvironment tEnv;
    @HiveSQL(files={})
    protected static HiveShell hiveShell;
    @Minio
    private static MinioTestContainer minioTestContainer;

    private static HiveCatalog createHiveCatalog(HiveConf hiveConf) {
        return new HiveCatalog("testcatalog", null, hiveConf, HiveShimLoader.getHiveVersion(), true);
    }

    @Before
    public void before() throws Exception {
        hiveShell.execute("CREATE DATABASE IF NOT EXISTS test_db");
        hiveShell.execute("USE test_db");
        hiveShell.execute("CREATE TABLE hive_table ( a INT, b STRING )");
        hiveShell.execute("INSERT INTO hive_table VALUES (100, 'Hive'), (200, 'Table')");
        hiveShell.executeQuery("SHOW TABLES");
        this.tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        HiveCatalog hiveCatalog = FlinkGenericCatalogITCase.createHiveCatalog(hiveShell.getHiveConf());
        FlinkGenericCatalog catalog = FlinkGenericCatalogFactory.createCatalog((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), new HashMap(), (String)hiveCatalog.getName(), (Catalog)hiveCatalog);
        catalog.open();
        this.tEnv.registerCatalog(hiveCatalog.getName(), (Catalog)catalog);
        this.sql("USE CATALOG " + hiveCatalog.getName(), new Object[0]);
        this.sql("USE test_db", new Object[0]);
    }

    @After
    public void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
        hiveShell.execute("DROP DATABASE IF EXISTS test_db2 CASCADE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Row> sql(String query, Object ... args) {
        try (CloseableIterator iter = this.tEnv.executeSql(String.format(query, args)).collect();){
            ImmutableList immutableList = ImmutableList.copyOf((Iterator)iter);
            return immutableList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testPaimonTableToBlackHole() {
        this.sql("CREATE TABLE paimon_t ( f0 INT, f1 INT ) WITH ('connector'='paimon', 'file.format' = 'avro' )", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM paimon_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        this.sql("CREATE TABLE bh (f0 INT, f1 INT) WITH ('connector'='blackhole')", new Object[0]);
        this.sql("INSERT INTO bh SELECT * FROM paimon_t", new Object[0]);
    }

    @Test
    public void testReadPaimonSystemTable() {
        this.sql("CREATE TABLE paimon_t (\n    user_id BIGINT,\n    item_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    PRIMARY KEY (dt, user_id) NOT ENFORCED\n) PARTITIONED BY (dt)  WITH ('connector'='paimon', 'file.format' = 'avro' )", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 2, 'click', '2023-11-01')", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (2, 3, 'click', '2023-11-02')", new Object[0]);
        List<Row> result = this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots", new Object[0]);
        Assertions.assertThat(result).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1L, 0L, "APPEND"}), Row.of((Object[])new Object[]{2L, 0L, "APPEND"})});
    }
}

