/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.HiveSchema;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class HiveTableSchemaTest {
    private static final RowType ROW_TYPE = new RowType(Arrays.asList(new DataField(0, "a", (DataType)DataTypes.INT(), "first comment"), new DataField(1, "b", (DataType)DataTypes.STRING(), "second comment"), new DataField(2, "c", (DataType)DataTypes.DECIMAL((int)5, (int)3), "last comment")));
    @TempDir
    java.nio.file.Path tempDir;

    @Test
    public void testExtractSchemaWithEmptyDDLAndNoPaimonTable() {
        Properties tableWithEmptyDDL = this.createTableWithEmptyDDL();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> HiveSchema.extract(null, (Properties)tableWithEmptyDDL)).withMessage("Schema file not found in location " + this.tempDir.toString() + ". Please create table first.");
    }

    @Test
    public void testExtractSchemaWithEmptyDDLAndExistsPaimonTable() throws Exception {
        this.createSchema();
        Properties tableWithEmptyDDL = this.createTableWithEmptyDDL();
        HiveSchema schema = HiveSchema.extract(null, (Properties)tableWithEmptyDDL);
        Assertions.assertThat((List)schema.fieldNames()).isEqualTo(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((List)schema.fieldTypes()).isEqualTo(Arrays.asList(DataTypes.INT(), DataTypes.STRING(), DataTypes.DECIMAL((int)5, (int)3)));
        Assertions.assertThat((List)schema.fieldComments()).isEqualTo(Arrays.asList("first comment", "second comment", "last comment"));
    }

    @Test
    public void testExtractSchemaWithExistsDDLAndNoPaimonTable() {
        Properties tableWithExistsDDL = this.createTableWithExistsDDL();
        HiveSchema schema = HiveSchema.extract(null, (Properties)tableWithExistsDDL);
        Assertions.assertThat((List)schema.fieldNames()).isEqualTo(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((List)schema.fieldTypes()).isEqualTo(Arrays.asList(DataTypes.INT(), DataTypes.STRING(), DataTypes.DECIMAL((int)5, (int)3)));
        Assertions.assertThat((List)schema.fieldComments()).isEqualTo(Arrays.asList("col1 comment", "col2 comment", "col3 comment"));
    }

    @Test
    public void testExtractSchemaWithExistsDDLAndExistsPaimonTable() throws Exception {
        this.createSchema();
        Properties tableWithExistsDDL = this.createTableWithExistsDDL();
        HiveSchema schema = HiveSchema.extract(null, (Properties)tableWithExistsDDL);
        Assertions.assertThat((List)schema.fieldNames()).isEqualTo(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((List)schema.fieldTypes()).isEqualTo(Arrays.asList(DataTypes.INT(), DataTypes.STRING(), DataTypes.DECIMAL((int)5, (int)3)));
        Assertions.assertThat((List)schema.fieldComments()).isEqualTo(Arrays.asList("first comment", "second comment", "last comment"));
    }

    @Test
    public void testMismatchedColumnNameAndType() throws Exception {
        this.createSchema();
        Properties properties = new Properties();
        properties.setProperty("columns", "a,mismatched,c");
        properties.setProperty("columns.types", String.join((CharSequence)":", Arrays.asList(TypeInfoFactory.intTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName(), TypeInfoFactory.getDecimalTypeInfo((int)6, (int)3).getTypeName())));
        properties.setProperty("columns.comments", "\u0000\u0000");
        properties.setProperty("location", this.tempDir.toString());
        String expected = "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nMismatched fields are:\nField #2\nHive DDL          : mismatched string\nPaimon Schema: b string\n--------------------\nField #3\nHive DDL          : c decimal(6,3)\nPaimon Schema: c decimal(5,3)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(expected);
    }

    @Test
    public void testTooFewColumns() throws Exception {
        this.createSchema();
        Properties properties = new Properties();
        properties.setProperty("columns", "a");
        properties.setProperty("columns.types", TypeInfoFactory.intTypeInfo.getTypeName());
        properties.setProperty("location", this.tempDir.toString());
        properties.setProperty("columns.comments", "");
        String expected = "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are 1 fields in Hive DDL: a\nThere are 3 fields in Paimon schema: a, b, c";
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).withMessageContaining(expected);
    }

    @Test
    public void testTooManyColumns() throws Exception {
        this.createSchema();
        Properties properties = new Properties();
        properties.setProperty("columns", "a,b,c,d,e");
        properties.setProperty("columns.types", String.join((CharSequence)":", Arrays.asList(TypeInfoFactory.intTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName(), TypeInfoFactory.getDecimalTypeInfo((int)5, (int)3).getTypeName(), TypeInfoFactory.intTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName())));
        properties.setProperty("columns.comments", "\u0000\u0000\u0000\u0000");
        properties.setProperty("location", this.tempDir.toString());
        String expected = "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are 5 fields in Hive DDL: a, b, c, d, e\nThere are 3 fields in Paimon schema: a, b, c";
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).withMessageContaining(expected);
    }

    private void createSchema() throws Exception {
        new SchemaManager((FileIO)LocalFileIO.create(), new Path(this.tempDir.toString())).createTable(new Schema(ROW_TYPE.getFields(), Collections.emptyList(), Collections.emptyList(), new HashMap(), ""));
    }

    @Test
    public void testMismatchedPartitionKeyAndType() throws Exception {
        this.createSchemaWithPartition();
        Properties properties = new Properties();
        properties.setProperty("partition_columns", "a/mismatched");
        properties.setProperty("partition_columns.types", String.join((CharSequence)":", Arrays.asList(TypeInfoFactory.longTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName())));
        properties.setProperty("columns", "c");
        properties.setProperty("columns.types", TypeInfoFactory.getDecimalTypeInfo((int)5, (int)3).getTypeName());
        properties.setProperty("columns.comments", "");
        properties.setProperty("location", this.tempDir.toString());
        String expected = String.join((CharSequence)"\n", "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nMismatched partition keys are:\nPartition Key #1\nHive DDL          : a bigint\nPaimon Schema: a int\n--------------------\nPartition Key #2\nHive DDL          : mismatched string\nPaimon Schema: b string");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(expected);
    }

    @Test
    public void testTooFewPartitionKeys() throws Exception {
        this.createSchemaWithPartition();
        Properties properties = new Properties();
        properties.setProperty("partition_columns", "a");
        properties.setProperty("partition_columns.types", TypeInfoFactory.intTypeInfo.getTypeName());
        properties.setProperty("columns", "c");
        properties.setProperty("columns.types", TypeInfoFactory.getDecimalTypeInfo((int)5, (int)3).getTypeName());
        properties.setProperty("columns.comments", "");
        properties.setProperty("location", this.tempDir.toString());
        String expected = "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are 1 partition keys in Hive DDL: a\nThere are 2 partition keys in Paimon schema: a, b";
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).withMessageContaining(expected);
    }

    @Test
    public void testTooManyPartitionKeys() throws Exception {
        this.createSchemaWithPartition();
        Properties properties = new Properties();
        properties.setProperty("partition_columns", "a/b/d");
        properties.setProperty("partition_columns.types", String.join((CharSequence)":", Arrays.asList(TypeInfoFactory.intTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName(), TypeInfoFactory.intTypeInfo.getTypeName())));
        properties.setProperty("columns", "c");
        properties.setProperty("columns.types", TypeInfoFactory.getDecimalTypeInfo((int)5, (int)3).getTypeName());
        properties.setProperty("columns.comments", "");
        properties.setProperty("location", this.tempDir.toString());
        String expected = "Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are 3 partition keys in Hive DDL: a, b, d\nThere are 2 partition keys in Paimon schema: a, b";
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> HiveSchema.extract(null, (Properties)properties)).withMessageContaining(expected);
    }

    private void createSchemaWithPartition() throws Exception {
        new SchemaManager((FileIO)LocalFileIO.create(), new Path(this.tempDir.toString())).createTable(new Schema(ROW_TYPE.getFields(), Arrays.asList("a", "b"), Arrays.asList("a", "b", "c"), new HashMap(), ""));
    }

    private Properties createTableWithEmptyDDL() {
        String tableName = "empty_ddl_test_table";
        Properties properties = new Properties();
        properties.setProperty("name", tableName);
        properties.setProperty("columns", "");
        properties.setProperty("columns.types", "");
        properties.setProperty("location", this.tempDir.toString());
        return properties;
    }

    private Properties createTableWithExistsDDL() {
        String tableName = "test_table";
        Properties properties = new Properties();
        properties.setProperty("name", tableName);
        properties.setProperty("columns", "a,b,c");
        properties.setProperty("columns.types", String.join((CharSequence)":", Arrays.asList(TypeInfoFactory.intTypeInfo.getTypeName(), TypeInfoFactory.stringTypeInfo.getTypeName(), TypeInfoFactory.getDecimalTypeInfo((int)5, (int)3).getTypeName())));
        properties.setProperty("columns.comments", "col1 comment\u0000col2 comment\u0000col3 comment");
        properties.setProperty("location", this.tempDir.toString());
        return properties;
    }
}

