/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.hive.FileStoreTestUtils;
import org.apache.paimon.hive.PaimonStorageHandler;
import org.apache.paimon.hive.RandomGenericRowDataGenerator;
import org.apache.paimon.hive.objectinspector.PaimonObjectInspectorFactory;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.StreamTableCommit;
import org.apache.paimon.table.sink.StreamTableWrite;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public class HiveWriteITCase {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    @HiveSQL(files={})
    private static HiveShell hiveShell;
    private static String engine;
    private String commitUser;
    private long commitIdentifier;

    @BeforeClass
    public static void beforeClass() {
        engine = "mr";
    }

    @Before
    public void before() {
        hiveShell.execute("SET hive.execution.engine=mr");
        hiveShell.execute("CREATE DATABASE IF NOT EXISTS test_db");
        hiveShell.execute("USE test_db");
        this.commitUser = UUID.randomUUID().toString();
        this.commitIdentifier = 0L;
    }

    @After
    public void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
    }

    private String createChangelogExternalTable(RowType rowType, List<String> partitionKeys, List<String> primaryKeys, List<InternalRow> data) throws Exception {
        return this.createChangelogExternalTable(rowType, partitionKeys, primaryKeys, data, "");
    }

    private String createChangelogExternalTable(RowType rowType, List<String> partitionKeys, List<String> primaryKeys, List<InternalRow> data, String tableName) throws Exception {
        String path = folder.newFolder().toURI().toString();
        String tableNameNotNull = StringUtils.isNullOrWhitespaceOnly((String)tableName) ? "hive_test_table" : tableName;
        String tablePath = String.format("%s/test_db.db/%s", path, tableNameNotNull);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)path);
        conf.set(CoreOptions.BUCKET, (Object)2);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Identifier identifier = Identifier.create((String)"test_db", (String)tableNameNotNull);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, partitionKeys, primaryKeys, identifier);
        return this.writeData(table, tablePath, data);
    }

    private String createAppendOnlyExternalTable(RowType rowType, List<String> partitionKeys, List<InternalRow> data) throws Exception {
        return this.createAppendOnlyExternalTable(rowType, partitionKeys, data, "");
    }

    private String createAppendOnlyExternalTable(RowType rowType, List<String> partitionKeys, List<InternalRow> data, String tableName) throws Exception {
        String path = folder.newFolder().toURI().toString();
        String tableNameNotNull = StringUtils.isNullOrWhitespaceOnly((String)tableName) ? "hive_test_table" : tableName;
        String tablePath = String.format("%s/test_db.db/%s", path, tableNameNotNull);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)path);
        conf.set(CoreOptions.BUCKET, (Object)2);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Identifier identifier = Identifier.create((String)"test_db", (String)tableNameNotNull);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, partitionKeys, Collections.emptyList(), identifier);
        return this.writeData(table, tablePath, data);
    }

    private String writeData(Table table, String path, List<InternalRow> data) throws Exception {
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        for (InternalRow rowData : data) {
            write.write(rowData);
            if (ThreadLocalRandom.current().nextInt(5) != 0) continue;
            commit.commit(this.commitIdentifier, write.prepareCommit(false, this.commitIdentifier));
            ++this.commitIdentifier;
        }
        commit.commit(this.commitIdentifier, write.prepareCommit(true, this.commitIdentifier));
        ++this.commitIdentifier;
        write.close();
        commit.close();
        String tableName = "test_table_" + UUID.randomUUID().toString().substring(0, 4);
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + path + "'")));
        return tableName;
    }

    @Test
    public void testInsert() throws Exception {
        List<InternalRow> emptyData = Collections.emptyList();
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " values (1,2,3,'Hello'),(4,5,6,'Fine')");
        List select = hiveShell.executeQuery("select * from " + outputTableName);
        Assertions.assertThat((List)select).containsExactly((Object[])new String[]{"1\t2\t3\tHello", "4\t5\t6\tFine"});
    }

    @Test
    public void testWriteOnlyWithChangeLogTableOption() throws Exception {
        String innerName = "hive_test_table_output";
        String path = folder.newFolder().toURI().toString();
        String tablePath = String.format("%s/test_db.db/%s", path, innerName);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)path);
        conf.set(CoreOptions.BUCKET, (Object)1);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Identifier identifier = Identifier.create((String)"test_db", (String)innerName);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Arrays.asList("a", "pt"), identifier);
        String tableName = "test_table_" + UUID.randomUUID().toString().substring(0, 4);
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath + "'")));
        for (int i = 0; i < 5; ++i) {
            hiveShell.execute("insert into " + tableName + " values (1,2,3,'Hello'),(4,5,6,'Fine')");
        }
        StreamTableScan scan = table.newReadBuilder().newStreamScan();
        DataSplit split = (DataSplit)scan.plan().splits().get(0);
        Assertions.assertThat((long)split.snapshotId()).isEqualTo(5L);
    }

    @Test
    public void testWriteOnlyWithAppendOnlyTableOption() throws Exception {
        String innerName = "hive_test_table_output";
        int maxCompact = 3;
        String path = folder.newFolder().toURI().toString();
        String tablePath = String.format("%s/test_db.db/%s", path, innerName);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)path);
        conf.set(CoreOptions.BUCKET, (Object)1);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        conf.set(CoreOptions.COMPACTION_MAX_FILE_NUM, (Object)maxCompact);
        Identifier identifier = Identifier.create((String)"test_db", (String)innerName);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Collections.emptyList(), identifier);
        String tableName = "test_table_" + UUID.randomUUID().toString().substring(0, 4);
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath + "'")));
        for (int i = 0; i < maxCompact; ++i) {
            hiveShell.execute("insert into " + tableName + " values (1,2,3,'Hello'),(4,5,6,'Fine')");
        }
        StreamTableScan scan = table.newReadBuilder().newStreamScan();
        DataSplit split = (DataSplit)scan.plan().splits().get(0);
        Assertions.assertThat((long)split.snapshotId()).isEqualTo((long)maxCompact);
    }

    @Test
    public void testInsertFromSelectWithPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{2, 20, 100L, null}), GenericRow.of((Object[])new Object[]{1, 30, 200L, BinaryString.fromString((String)"Store")}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Arrays.asList("pt", "a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertFromSelectNoPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.of((Object[])new Object[]{1, 20L, BinaryString.fromString((String)"Hello"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.of((Object[])new Object[]{2, 30L, BinaryString.fromString((String)"World"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi Again"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2, 30L, BinaryString.fromString((String)"World"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.of((Object[])new Object[]{2, 40L, null, Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}), GenericRow.of((Object[])new Object[]{3, 50L, BinaryString.fromString((String)"Store"), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.DECIMAL((int)5, (int)3)}, (String[])new String[]{"a", "b", "c", "d"}), Collections.emptyList(), Arrays.asList("a", "b"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.DECIMAL((int)5, (int)3)}, (String[])new String[]{"a", "b", "c", "d"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertFromSelectWhereWithPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{2, 20, 100L, null}), GenericRow.of((Object[])new Object[]{1, 30, 200L, BinaryString.fromString((String)"Store")}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Arrays.asList("pt", "a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName + " where a > 10");
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName + " where a > 10");
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertFromSelectOrderWithPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{2, 20, 100L, null}), GenericRow.of((Object[])new Object[]{1, 30, 200L, BinaryString.fromString((String)"Store")}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Arrays.asList("pt", "a"), data);
        String outputTableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), Arrays.asList("pt", "b"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName + " order by b desc");
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName + " order by b desc");
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertFromJoiningWithPartitionWithPk() throws Exception {
        List<InternalRow> leftData = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}));
        List<InternalRow> rightData = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 1L, BinaryString.fromString((String)"HZY")}), GenericRow.of((Object[])new Object[]{2, 10, 2L, BinaryString.fromString((String)"LN")}), GenericRow.of((Object[])new Object[]{1, 20, 3L, BinaryString.fromString((String)"GOOD")}), GenericRow.of((Object[])new Object[]{1, 10, 4L, BinaryString.fromString((String)"")}));
        List<InternalRow> emptyData = Collections.emptyList();
        String leftTable = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), leftData);
        String rightTable = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), rightData);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"}), Collections.singletonList("pt"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT r.pt as pt,l.a as a,l.b as b ,r.c as c FROM " + leftTable + " l left join " + rightTable + " r on l.a = r.a");
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement(" SELECT r.pt as pt,l.a as a,l.b as b ,r.c as c FROM " + leftTable + " l left join " + rightTable + " r on l.a = r.a");
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertAllSupportedTypes() throws Exception {
        int key;
        String root = folder.newFolder().toString();
        String tablePath = String.format("%s/test_db.db/hive_test_table", root);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)root);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RandomGenericRowDataGenerator.ROW_TYPE, Collections.emptyList(), Collections.singletonList("f_int"));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<GenericRow> input = new ArrayList<GenericRow>();
        for (int i = random.nextInt(50); i > 0; --i) {
            GenericRow rowData;
            while ((rowData = RandomGenericRowDataGenerator.generate()).isNullAt(3)) {
            }
            input.add(rowData);
        }
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        for (GenericRow rowData : input) {
            write.write((InternalRow)rowData);
        }
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE test_table", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath + "'")));
        List<InternalRow> emptyData = Collections.emptyList();
        String outputTableName = this.createChangelogExternalTable(RandomGenericRowDataGenerator.ROW_TYPE, Collections.emptyList(), Collections.singletonList("f_int"), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM test_table");
        List actual = hiveShell.executeStatement("select * from " + outputTableName);
        HashMap<Integer, GenericRow> expected = new HashMap<Integer, GenericRow>();
        for (GenericRow rowData : input) {
            key = rowData.getInt(3);
            expected.put(key, rowData);
        }
        for (Object[] actualRow : actual) {
            key = (Integer)actualRow[3];
            Assertions.assertThat((boolean)expected.containsKey(key)).isTrue();
            GenericRow expectedRow = (GenericRow)expected.get(key);
            Assertions.assertThat((int)actualRow.length).isEqualTo(expectedRow.getFieldCount());
            block10: for (int i = 0; i < actualRow.length; ++i) {
                if (expectedRow.isNullAt(i)) {
                    Assertions.assertThat((Object)actualRow[i]).isNull();
                    continue;
                }
                ObjectInspector oi = PaimonObjectInspectorFactory.create((DataType)RandomGenericRowDataGenerator.LOGICAL_TYPES.get(i));
                switch (oi.getCategory()) {
                    case PRIMITIVE: {
                        AbstractPrimitiveJavaObjectInspector primitiveOi = (AbstractPrimitiveJavaObjectInspector)oi;
                        Object expectedObject = primitiveOi.getPrimitiveJavaObject(expectedRow.getField(i));
                        if (expectedObject instanceof byte[]) {
                            Assertions.assertThat((byte[])((byte[])actualRow[i])).containsExactly((byte[])expectedObject);
                            continue block10;
                        }
                        if (expectedObject instanceof HiveDecimal) {
                            Assertions.assertThat((Object)actualRow[i]).isEqualTo((Object)expectedRow.getField(i).toString());
                            continue block10;
                        }
                        Assertions.assertThat((String)String.valueOf(actualRow[i])).isEqualTo(String.valueOf(expectedObject));
                        continue block10;
                    }
                    case LIST: {
                        ListObjectInspector listOi = (ListObjectInspector)oi;
                        Assertions.assertThat((Object)actualRow[i]).isEqualTo((Object)String.valueOf(listOi.getList(expectedRow.getField(i))).replace(" ", ""));
                        continue block10;
                    }
                    case MAP: {
                        MapObjectInspector mapOi = (MapObjectInspector)oi;
                        HashMap expectedMap = new HashMap();
                        mapOi.getMap(expectedRow.getField(i)).forEach((k, v) -> expectedMap.put(k.toString(), String.valueOf(v)));
                        String actualString = actualRow[i].toString();
                        actualString = actualString.substring(1, actualString.length() - 1);
                        for (String kv : actualString.split(",")) {
                            if (kv.trim().isEmpty()) continue;
                            String[] split = kv.split(":");
                            String k2 = split[0].substring(1, split[0].length() - 1);
                            Assertions.assertThat((String)split[1]).isEqualTo((String)expectedMap.get(k2));
                            expectedMap.remove(k2);
                        }
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            expected.remove(key);
        }
        Assertions.assertThat(expected).isEmpty();
    }

    @Test
    public void testInsertArrayOfPrimitiveType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericArray(Collections.singletonList(BinaryString.fromString((String)"xiaoyang")).toArray()), new GenericArray(Collections.singletonList(BinaryString.fromString((String)"hi")).toArray()), new GenericArray(Collections.singletonList(Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)).toArray())}), GenericRow.of((Object[])new Object[]{1, new GenericArray(Collections.singletonList(BinaryString.fromString((String)"hzy")).toArray()), new GenericArray(Collections.singletonList(BinaryString.fromString((String)"hello")).toArray()), new GenericArray(Collections.singletonList(Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3)).toArray())}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.CHAR((int)20)), DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)100)), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)5, (int)3))}, (String[])new String[]{"a", "b", "c", "d"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.CHAR((int)20)), DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)100)), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)5, (int)3))}, (String[])new String[]{"a", "b", "c", "d"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertArrayOfArrayType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericArray(Collections.singletonList(new GenericArray(Collections.singletonList(BinaryString.fromString((String)"xiaoyang")).toArray())).toArray()), new GenericArray(Collections.singletonList(new GenericArray(Collections.singletonList(new GenericArray(Collections.singletonList(BinaryString.fromString((String)"xiaoyang")).toArray())).toArray())).toArray())}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())))}, (String[])new String[]{"a", "b", "c"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())))}, (String[])new String[]{"a", "b", "c"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertArrayOfMapType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericArray(Collections.singletonList(new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaoyang"), BinaryString.fromString((String)"xiaolan")))).toArray())}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertArrayOfRowType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericArray(Collections.singletonList(GenericRow.of((Object[])new Object[]{GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"xiaoyang")}), BinaryString.fromString((String)"xiaolan")})).toArray())}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(2, "b1", (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(4, "b1_1", (DataType)DataTypes.STRING())})), new DataField(3, "b2", (DataType)DataTypes.STRING())}))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(2, "b1", (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(4, "b1_1", (DataType)DataTypes.STRING())})), new DataField(3, "b2", (DataType)DataTypes.STRING())}))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertMapOfPrimitiveType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaoyang"), BinaryString.fromString((String)"xiaolan")))}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertMapOfArrayType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaoyang"), new GenericArray(Collections.singletonList(BinaryString.fromString((String)"xiaoyang")).toArray())))}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertMapOfMapType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaolan"), new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaoyang"), BinaryString.fromString((String)"xiaolan")))))}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }

    @Test
    public void testInsertMapOfRowType() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, new GenericMap(Collections.singletonMap(BinaryString.fromString((String)"xiaolan"), GenericRow.of((Object[])new Object[]{GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"xiaoyang")}), BinaryString.fromString((String)"xiaolan")})))}));
        List<InternalRow> emptyData = Collections.emptyList();
        String tableName = this.createChangelogExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(5, "c1", (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(6, "c1_1", (DataType)DataTypes.STRING())})), new DataField(7, "c2", (DataType)DataTypes.STRING())}))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Arrays.asList("a"), data);
        String outputTableName = this.createAppendOnlyExternalTable(RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(5, "c1", (DataType)DataTypes.ROW((DataField[])new DataField[]{new DataField(6, "c1_1", (DataType)DataTypes.STRING())})), new DataField(7, "c2", (DataType)DataTypes.STRING())}))}, (String[])new String[]{"a", "b"}), Collections.emptyList(), emptyData, "hive_test_table_output");
        hiveShell.execute("insert into " + outputTableName + " SELECT * FROM " + tableName);
        List select = hiveShell.executeStatement("select * from " + outputTableName);
        List expect = hiveShell.executeStatement("select * from " + tableName);
        Assertions.assertThat((Object[])select.toArray()).containsExactlyInAnyOrder(expect.toArray());
    }
}

