/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.hive.FileStoreTestUtils;
import org.apache.paimon.hive.PaimonStorageHandler;
import org.apache.paimon.hive.RandomGenericRowDataGenerator;
import org.apache.paimon.hive.objectinspector.PaimonObjectInspectorFactory;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.StreamTableCommit;
import org.apache.paimon.table.sink.StreamTableWrite;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public class PaimonStorageHandlerITCase {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    @HiveSQL(files={})
    private static HiveShell hiveShell;
    private static String engine;
    private String warehouse;
    private String tablePath;
    private Identifier identifier;
    private String externalTable;
    private long commitIdentifier;

    @BeforeClass
    public static void beforeClass() {
        engine = "mr";
    }

    @Before
    public void before() throws IOException {
        if ("mr".equals(engine)) {
            hiveShell.execute("SET hive.execution.engine=mr");
        } else if ("tez".equals(engine)) {
            hiveShell.execute("SET hive.execution.engine=tez");
            hiveShell.execute("SET tez.local.mode=true");
            hiveShell.execute("SET hive.jar.directory=" + folder.getRoot().getAbsolutePath());
            hiveShell.execute("SET tez.staging-dir=" + folder.getRoot().getAbsolutePath());
            hiveShell.execute("SET hive.tez.exec.inplace.progress=false");
        } else {
            throw new UnsupportedOperationException("Unsupported engine " + engine);
        }
        hiveShell.execute("CREATE DATABASE IF NOT EXISTS test_db");
        hiveShell.execute("USE test_db");
        this.warehouse = folder.newFolder().toURI().toString();
        this.tablePath = String.format("%s/test_db.db/%s", this.warehouse, "hive_test_table");
        this.identifier = Identifier.create((String)"test_db", (String)"hive_test_table");
        this.externalTable = "test_table_" + UUID.randomUUID().toString().substring(0, 4);
        this.commitIdentifier = 0L;
    }

    @After
    public void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
    }

    @Test
    public void testReadExternalTableNoPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi"), 100L}), GenericRow.of((Object[])new Object[]{1, 20L, BinaryString.fromString((String)"Hello"), 200L}), GenericRow.of((Object[])new Object[]{2, 30L, BinaryString.fromString((String)"World"), 300L}), GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi Again"), 1000L}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2, 30L, BinaryString.fromString((String)"World"), 300L}), GenericRow.of((Object[])new Object[]{2, 40L, null, 400L}), GenericRow.of((Object[])new Object[]{3, 50L, BinaryString.fromString((String)"Store"), 200L}));
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.BIGINT()}, (String[])new String[]{"a", "b", "c", "d"});
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, Collections.emptyList(), Arrays.asList("a", "b"), this.identifier);
        this.createExternalTable();
        this.writeData(table, data);
        List actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY b");
        List<String> expected = Arrays.asList("1\t10\tHi Again\t1000", "1\t20\tHello\t200", "2\t40\tNULL\t400", "3\t50\tStore\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT c, b FROM " + this.externalTable + " ORDER BY b");
        expected = Arrays.asList("Hi Again\t10", "Hello\t20", "NULL\t40", "Store\t50");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " WHERE d > 200 ORDER BY b");
        expected = Arrays.asList("1\t10\tHi Again\t1000", "2\t40\tNULL\t400");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT a, sum(d) FROM " + this.externalTable + " GROUP BY a ORDER BY a");
        expected = Arrays.asList("1\t1200", "2\t400", "3\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT d, sum(b) FROM " + this.externalTable + " GROUP BY d ORDER BY d");
        expected = Arrays.asList("200\t70", "400\t40", "1000\t10");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT T1.a, T1.b, T1.d + T2.d FROM " + this.externalTable + " T1 INNER JOIN " + this.externalTable + " T2 ON T1.a = T2.a AND T1.b = T2.b ORDER BY T1.a, T1.b");
        expected = Arrays.asList("1\t10\t2000", "1\t20\t400", "2\t40\t800", "3\t50\t400");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT T1.a, T1.b, T2.b, T1.d + T2.d FROM " + this.externalTable + " T1 INNER JOIN " + this.externalTable + " T2 ON T1.a = T2.a ORDER BY T1.a, T1.b, T2.b");
        expected = Arrays.asList("1\t10\t10\t2000", "1\t10\t20\t1200", "1\t20\t10\t1200", "1\t20\t20\t400", "2\t40\t40\t800", "3\t50\t50\t400");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        long snapshotId = ((FileStoreTable)table).snapshotManager().latestSnapshot().id();
        data = Collections.singletonList(GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi Time Travel"), 10000L}));
        this.writeData(table, data);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY b");
        expected = Arrays.asList("1\t10\tHi Time Travel\t10000", "1\t20\tHello\t200", "2\t40\tNULL\t400", "3\t50\tStore\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        hiveShell.execute("SET paimon.scan.snapshot-id=" + snapshotId);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY b");
        expected = Arrays.asList("1\t10\tHi Again\t1000", "1\t20\tHello\t200", "2\t40\tNULL\t400", "3\t50\tStore\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        hiveShell.execute("SET paimon.scan.snapshot-id=null");
    }

    @Test
    public void testReadExternalTableWithPartitionWithPk() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}), GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{2, 20, 100L, null}), GenericRow.of((Object[])new Object[]{1, 30, 200L, BinaryString.fromString((String)"Store")}));
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"});
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, Collections.singletonList("pt"), Arrays.asList("pt", "a"), this.identifier);
        this.createExternalTable();
        this.writeData(table, data);
        List actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY pt, a");
        List<String> expected = Arrays.asList("1\t10\t100\tHi Again", "1\t30\t200\tStore", "2\t10\t200\tHello", "2\t20\t100\tNULL");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT c, a FROM " + this.externalTable + " ORDER BY c, a");
        expected = Arrays.asList("NULL\t20", "Hello\t10", "Hi Again\t10", "Store\t30");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " WHERE b > 100 ORDER BY pt, a");
        expected = Arrays.asList("1\t30\t200\tStore", "2\t10\t200\tHello");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT pt, sum(b), max(c) FROM " + this.externalTable + " GROUP BY pt ORDER BY pt");
        expected = Arrays.asList("1\t300\tStore", "2\t300\tHello");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT a, sum(b), max(c) FROM " + this.externalTable + " GROUP BY a ORDER BY a");
        expected = Arrays.asList("10\t300\tHi Again", "20\t100\tNULL", "30\t200\tStore");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT b, sum(a), max(c) FROM " + this.externalTable + " GROUP BY b ORDER BY b");
        expected = Arrays.asList("100\t30\tHi Again", "200\t40\tStore");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT a, b FROM (SELECT T1.a AS a, T1.b + T2.b AS b FROM " + this.externalTable + " T1 JOIN " + this.externalTable + " T2 ON T1.a = T2.a) T3 ORDER BY a, b");
        expected = Arrays.asList("10\t200", "10\t300", "10\t300", "10\t400", "20\t200", "30\t400");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT b, a FROM (SELECT T1.b AS b, T1.a + T2.a AS a FROM " + this.externalTable + " T1 JOIN " + this.externalTable + " T2 ON T1.b = T2.b) T3 ORDER BY b, a");
        expected = Arrays.asList("100\t20", "100\t30", "100\t30", "100\t40", "200\t20", "200\t40", "200\t40", "200\t60");
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void testReadExternalTableNoPartitionAppendOnly() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi"), 100L}), GenericRow.of((Object[])new Object[]{1, 20L, BinaryString.fromString((String)"Hello"), 200L}), GenericRow.of((Object[])new Object[]{2, 30L, BinaryString.fromString((String)"World"), 300L}), GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi Again"), 1000L}), GenericRow.of((Object[])new Object[]{2, 40L, null, 400L}), GenericRow.of((Object[])new Object[]{3, 50L, BinaryString.fromString((String)"Store"), 200L}));
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.BIGINT()}, (String[])new String[]{"a", "b", "c", "d"});
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, Collections.emptyList(), Collections.emptyList(), this.identifier);
        this.createExternalTable();
        this.writeData(table, data);
        List actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY a, b, c");
        List<String> expected = Arrays.asList("1\t10\tHi\t100", "1\t10\tHi Again\t1000", "1\t20\tHello\t200", "2\t30\tWorld\t300", "2\t40\tNULL\t400", "3\t50\tStore\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT c, b FROM " + this.externalTable + " ORDER BY c");
        expected = Arrays.asList("NULL\t40", "Hello\t20", "Hi\t10", "Hi Again\t10", "Store\t50", "World\t30");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " WHERE d < 300 ORDER BY b, d");
        expected = Arrays.asList("1\t10\tHi\t100", "1\t20\tHello\t200", "3\t50\tStore\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT a, sum(d) FROM " + this.externalTable + " GROUP BY a ORDER BY a");
        expected = Arrays.asList("1\t1300", "2\t700", "3\t200");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT T1.a, T1.b, T2.b FROM " + this.externalTable + " T1 JOIN " + this.externalTable + " T2 ON T1.a = T2.a WHERE T1.a > 1 ORDER BY T1.a, T1.b, T2.b");
        expected = Arrays.asList("2\t30\t30", "2\t30\t40", "2\t40\t30", "2\t40\t40", "3\t50\t50");
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void testReadExternalTableWithPartitionAppendOnly() throws Exception {
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi")}), GenericRow.of((Object[])new Object[]{2, 10, 200L, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{1, 20, 300L, BinaryString.fromString((String)"World")}), GenericRow.of((Object[])new Object[]{1, 10, 100L, BinaryString.fromString((String)"Hi Again")}), GenericRow.of((Object[])new Object[]{2, 20, 400L, null}), GenericRow.of((Object[])new Object[]{1, 30, 500L, BinaryString.fromString((String)"Store")}));
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pt", "a", "b", "c"});
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType, Collections.singletonList("pt"), Collections.emptyList(), this.identifier);
        this.createExternalTable();
        this.writeData(table, data);
        List actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " ORDER BY pt, a, c");
        List<String> expected = Arrays.asList("1\t10\t100\tHi", "1\t10\t100\tHi Again", "1\t20\t300\tWorld", "1\t30\t500\tStore", "2\t10\t200\tHello", "2\t20\t400\tNULL");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT c, b FROM " + this.externalTable + " ORDER BY c");
        expected = Arrays.asList("NULL\t400", "Hello\t200", "Hi\t100", "Hi Again\t100", "Store\t500", "World\t300");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " WHERE b < 400 ORDER BY b, c");
        expected = Arrays.asList("1\t10\t100\tHi", "1\t10\t100\tHi Again", "2\t10\t200\tHello", "1\t20\t300\tWorld");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT pt, max(a), min(c) FROM " + this.externalTable + " GROUP BY pt ORDER BY pt");
        expected = Arrays.asList("1\t30\tHi", "2\t20\tHello");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT a, sum(b), min(c) FROM " + this.externalTable + " GROUP BY a ORDER BY a");
        expected = Arrays.asList("10\t400\tHello", "20\t700\tWorld", "30\t500\tStore");
        Assertions.assertThat((List)actual).isEqualTo(expected);
        actual = hiveShell.executeQuery("SELECT T1.a, T1.b, T2.b FROM " + this.externalTable + " T1 JOIN " + this.externalTable + " T2 ON T1.a = T2.a WHERE T1.a > 10 ORDER BY T1.a, T1.b, T2.b");
        expected = Arrays.asList("20\t300\t300", "20\t300\t400", "20\t400\t300", "20\t400\t400", "30\t500\t500");
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    private void writeData(Table table, List<InternalRow> data) throws Exception {
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        for (InternalRow rowData : data) {
            write.write(rowData);
            if (ThreadLocalRandom.current().nextInt(5) != 0) continue;
            commit.commit(this.commitIdentifier, write.prepareCommit(false, this.commitIdentifier));
            ++this.commitIdentifier;
        }
        commit.commit(this.commitIdentifier, write.prepareCommit(true, this.commitIdentifier));
        ++this.commitIdentifier;
        write.close();
        commit.close();
    }

    @Test
    public void testReadAllSupportedTypes() throws Exception {
        int key;
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RandomGenericRowDataGenerator.ROW_TYPE, Collections.emptyList(), Collections.singletonList("f_int"));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<GenericRow> input = new ArrayList<GenericRow>();
        for (int i = random.nextInt(10); i > 0; --i) {
            GenericRow rowData;
            while ((rowData = RandomGenericRowDataGenerator.generate()).isNullAt(3)) {
            }
            input.add(rowData);
        }
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        for (GenericRow rowData : input) {
            write.write((InternalRow)rowData);
        }
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        this.createExternalTable();
        List actual = hiveShell.executeStatement("SELECT * FROM `" + this.externalTable + "`  WHERE f_int > 0");
        HashMap<Integer, GenericRow> expected = new HashMap<Integer, GenericRow>();
        for (GenericRow rowData : input) {
            key = rowData.getInt(3);
            if (key <= 0) continue;
            expected.put(key, rowData);
        }
        for (Object[] actualRow : actual) {
            key = (Integer)actualRow[3];
            Assertions.assertThat((boolean)expected.containsKey(key)).isTrue();
            GenericRow expectedRow = (GenericRow)expected.get(key);
            Assertions.assertThat((int)actualRow.length).isEqualTo(expectedRow.getFieldCount());
            block10: for (int i = 0; i < actualRow.length; ++i) {
                if (expectedRow.isNullAt(i)) {
                    Assertions.assertThat((Object)actualRow[i]).isNull();
                    continue;
                }
                ObjectInspector oi = PaimonObjectInspectorFactory.create((DataType)RandomGenericRowDataGenerator.LOGICAL_TYPES.get(i));
                switch (oi.getCategory()) {
                    case PRIMITIVE: {
                        AbstractPrimitiveJavaObjectInspector primitiveOi = (AbstractPrimitiveJavaObjectInspector)oi;
                        Object expectedObject = primitiveOi.getPrimitiveJavaObject(expectedRow.getField(i));
                        if (expectedObject instanceof byte[]) {
                            Assertions.assertThat((byte[])((byte[])actualRow[i])).containsExactly((byte[])expectedObject);
                            continue block10;
                        }
                        if (expectedObject instanceof HiveDecimal) {
                            Assertions.assertThat((Object)actualRow[i]).isEqualTo((Object)expectedRow.getField(i).toString());
                            continue block10;
                        }
                        Assertions.assertThat((String)String.valueOf(actualRow[i])).isEqualTo(String.valueOf(expectedObject));
                        continue block10;
                    }
                    case LIST: {
                        ListObjectInspector listOi = (ListObjectInspector)oi;
                        Assertions.assertThat((Object)actualRow[i]).isEqualTo((Object)String.valueOf(listOi.getList(expectedRow.getField(i))).replace(" ", ""));
                        continue block10;
                    }
                    case MAP: {
                        MapObjectInspector mapOi = (MapObjectInspector)oi;
                        HashMap expectedMap = new HashMap();
                        mapOi.getMap(expectedRow.getField(i)).forEach((k, v) -> expectedMap.put(k.toString(), String.valueOf(v)));
                        String actualString = actualRow[i].toString();
                        actualString = actualString.substring(1, actualString.length() - 1);
                        for (String kv : actualString.split(",")) {
                            if (kv.trim().isEmpty()) continue;
                            String[] split = kv.split(":");
                            String k2 = split[0].substring(1, split[0].length() - 1);
                            Assertions.assertThat((String)split[1]).isEqualTo((String)expectedMap.get(k2));
                            expectedMap.remove(k2);
                        }
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            expected.remove(key);
        }
        Assertions.assertThat(expected).isEmpty();
    }

    @Test
    public void testPredicatePushDown() throws Exception {
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.BUCKET, (Object)1);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.INT()}, (String[])new String[]{"a"}), Collections.emptyList(), Collections.emptyList());
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{null}));
        commit.commit(1L, write.prepareCommit(true, 1L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{2}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{3}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{null}));
        commit.commit(2L, write.prepareCommit(true, 2L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{4}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{5}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{6}));
        commit.commit(3L, write.prepareCommit(true, 3L));
        write.close();
        commit.close();
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE test_table", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + this.tablePath + "'")));
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a = 1 OR a = 5")).containsExactly((Object[])new String[]{"1", "5"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a <> 1 AND a <> 4 AND a <> 5")).containsExactly((Object[])new String[]{"2", "3", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE NOT (a = 1 OR a = 5) AND NOT a = 4")).containsExactly((Object[])new String[]{"2", "3", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a < 4")).containsExactly((Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a <= 3")).containsExactly((Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a > 3")).containsExactly((Object[])new String[]{"4", "5", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a >= 4")).containsExactly((Object[])new String[]{"4", "5", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a IN (0, 1, 3, 7)")).containsExactly((Object[])new String[]{"1", "3"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a IN (0, NULL, 3, 7)")).containsExactly((Object[])new String[]{"3"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a NOT IN (0, 1, 3, 2, 5, 7)")).containsExactly((Object[])new String[]{"4", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a NOT IN (0, 1, NULL, 2, 5, 7)")).isEmpty();
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a BETWEEN 2 AND 3")).containsExactly((Object[])new String[]{"2", "3"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a NOT BETWEEN 2 AND 4")).containsExactly((Object[])new String[]{"1", "5", "6"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a IS NULL")).containsExactly((Object[])new String[]{"NULL", "NULL"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM test_table WHERE a IS NOT NULL")).containsExactly((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    }

    @Test
    public void testDateAndTimestamp() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)(random.nextBoolean() ? CoreOptions.FileFormatType.ORC : CoreOptions.FileFormatType.PARQUET));
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.DATE(), DataTypes.TIMESTAMP((int)random.nextInt(10))}, (String[])new String[]{"dt", "ts"}), Collections.emptyList(), Collections.emptyList());
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{375, Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2022, 5, 17, 17, 29, 20, 100000000))}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{null, null}));
        commit.commit(1L, write.prepareCommit(true, 1L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{376, null}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{null, Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2022, 6, 18, 8, 30, 0, 100000000))}));
        commit.commit(2L, write.prepareCommit(true, 2L));
        write.close();
        commit.close();
        this.createExternalTable();
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM `" + this.externalTable + "` WHERE dt = '1971-01-11'")).containsExactly((Object[])new String[]{"1971-01-11\t2022-05-17 17:29:20.1"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM `" + this.externalTable + "` WHERE ts = '2022-05-17 17:29:20.1'")).containsExactly((Object[])new String[]{"1971-01-11\t2022-05-17 17:29:20.1"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM `" + this.externalTable + "` WHERE dt = '1971-01-12'")).containsExactly((Object[])new String[]{"1971-01-12\tNULL"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM `" + this.externalTable + "` WHERE ts = '2022-06-18 08:30:00.1'")).containsExactly((Object[])new String[]{"NULL\t2022-06-18 08:30:00.1"});
    }

    @Test
    public void testTime() throws Exception {
        Table table = FileStoreTestUtils.createFileStoreTable(this.getBasicConf(), RowType.of((DataType[])new DataType[]{DataTypes.INT().notNull(), DataTypes.TIME(), DataTypes.TIME((int)2)}, (String[])new String[]{"pk", "time0", "time2"}), Collections.emptyList(), Collections.singletonList("pk"));
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1, 0, 0}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{2, 86399999, 86399999}));
        commit.commit(1L, write.prepareCommit(true, 1L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{3, 45001000, 45001000}));
        commit.commit(2L, write.prepareCommit(true, 2L));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{4, null, null}));
        commit.commit(4L, write.prepareCommit(true, 3L));
        write.close();
        commit.close();
        this.createExternalTable();
        Assertions.assertThat((List)hiveShell.executeQuery("SHOW CREATE TABLE " + this.externalTable)).contains((Object[])new String[]{"  `time0` string COMMENT 'from deserializer', ", "  `time2` string COMMENT 'from deserializer')"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM " + this.externalTable)).containsExactlyInAnyOrder((Object[])new String[]{"1\t00:00\t00:00", "2\t23:59:59.999\t23:59:59.999", "3\t12:30:01\t12:30:01", "4\tNULL\tNULL"});
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT * FROM " + this.externalTable + " WHERE time0 = '12:30:01'")).containsExactlyInAnyOrder((Object[])new String[]{"3\t12:30:01\t12:30:01"});
    }

    @Test
    public void testMapKey() throws Exception {
        Options conf = this.getBasicConf();
        conf.set(CoreOptions.FILE_FORMAT, (Object)(ThreadLocalRandom.current().nextBoolean() ? CoreOptions.FileFormatType.ORC : CoreOptions.FileFormatType.PARQUET));
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.TIMESTAMP((int)3), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.TIMESTAMP((int)5), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)2, (int)1), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.VARCHAR((int)10), (DataType)DataTypes.STRING())}, (String[])new String[]{"date_key", "timestamp3_key", "timestamp5_key", "decimal_key", "string_key", "varchar_key"}), Collections.emptyList(), Collections.emptyList());
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        Map<Integer, BinaryString> dateMap = Collections.singletonMap(375, BinaryString.fromString((String)"Date 1971-01-11"));
        Map<Timestamp, BinaryString> timestamp3Map = Collections.singletonMap(Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2023, 7, 18, 12, 29, 59, 123000000)), BinaryString.fromString((String)"Test timestamp(3)"));
        Map<Timestamp, BinaryString> timestamp5Map = Collections.singletonMap(Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2023, 7, 18, 12, 29, 59, 123450000)), BinaryString.fromString((String)"Test timestamp(5)"));
        Map<Decimal, BinaryString> decimalMap = Collections.singletonMap(Decimal.fromBigDecimal((BigDecimal)new BigDecimal("1.2"), (int)2, (int)1), BinaryString.fromString((String)"\u4e00\u70b9\u4e8c"));
        Map<BinaryString, BinaryString> stringMap = Collections.singletonMap(BinaryString.fromString((String)"Engine"), BinaryString.fromString((String)"Hive"));
        Map<BinaryString, BinaryString> varcharMap = Collections.singletonMap(BinaryString.fromString((String)"Name"), BinaryString.fromString((String)"Paimon"));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{new GenericMap(dateMap), new GenericMap(timestamp3Map), new GenericMap(timestamp5Map), new GenericMap(decimalMap), new GenericMap(stringMap), new GenericMap(varcharMap)}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        this.createExternalTable();
        Assertions.assertThat((List)hiveShell.executeQuery("SELECT date_key[CAST('1971-01-11' AS DATE)],timestamp3_key[CAST('2023-7-18 12:29:59.123' AS TIMESTAMP)],timestamp5_key[CAST('2023-7-18 12:29:59.12345' AS TIMESTAMP)],decimal_key[1.2],string_key['Engine'],varchar_key['Name'] FROM `" + this.externalTable + "`")).containsExactly((Object[])new String[]{"Date 1971-01-11\tTest timestamp(3)\tTest timestamp(5)\t\u4e00\u70b9\u4e8c\tHive\tPaimon"});
    }

    private Options getBasicConf() {
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.warehouse);
        conf.set(CoreOptions.BUCKET, (Object)2);
        return conf;
    }

    private void createExternalTable() {
        hiveShell.execute(String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + this.externalTable + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + this.tablePath + "'")));
    }
}

