/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.hive.SearchArgumentToPredicateConverter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SearchArgumentToPredicateConverterTest {
    private static final List<String> COLUMN_NAMES = Arrays.asList("f_int", "f_bigint", "f_double");
    private static final List<DataType> COLUMN_TYPES = Arrays.asList(DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DOUBLE());
    private static final PredicateBuilder BUILDER = new PredicateBuilder(RowType.of((DataType[])COLUMN_TYPES.toArray(new DataType[0]), (String[])COLUMN_NAMES.toArray(new String[0])));

    @Test
    public void testLiteral() {
        this.testLiteral(PredicateLeaf.Type.BOOLEAN, false, (DataType)DataTypes.BOOLEAN(), false);
        this.testLiteral(PredicateLeaf.Type.LONG, 10L, (DataType)DataTypes.TINYINT(), (byte)10);
        this.testLiteral(PredicateLeaf.Type.LONG, 100L, (DataType)DataTypes.SMALLINT(), (short)100);
        this.testLiteral(PredicateLeaf.Type.LONG, 1000L, (DataType)DataTypes.INT(), 1000);
        this.testLiteral(PredicateLeaf.Type.LONG, 10000L, (DataType)DataTypes.BIGINT(), 10000L);
        this.testLiteral(PredicateLeaf.Type.FLOAT, 0.2, (DataType)DataTypes.FLOAT(), Float.valueOf(0.2f));
        this.testLiteral(PredicateLeaf.Type.FLOAT, 0.2, (DataType)DataTypes.DOUBLE(), 0.2);
        this.testLiteral(PredicateLeaf.Type.DECIMAL, new HiveDecimalWritable(HiveDecimal.create((String)"123456.789")), (DataType)DataTypes.DECIMAL((int)9, (int)3), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("123456.789"), (int)9, (int)3));
        this.testLiteral(PredicateLeaf.Type.DECIMAL, new HiveDecimalWritable(HiveDecimal.create((String)"123456789123456789.123456789")), (DataType)DataTypes.DECIMAL((int)27, (int)9), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("123456789123456789.123456789"), (int)27, (int)9));
        this.testLiteral(PredicateLeaf.Type.STRING, "Paimon", (DataType)DataTypes.STRING(), BinaryString.fromString((String)"Paimon"));
        this.testLiteral(PredicateLeaf.Type.DATE, Date.valueOf("1971-01-11"), (DataType)DataTypes.DATE(), 375);
        this.testLiteral(PredicateLeaf.Type.TIMESTAMP, Timestamp.valueOf("2022-05-17 16:25:53"), (DataType)DataTypes.TIMESTAMP((int)3), org.apache.paimon.data.Timestamp.fromSQLTimestamp((Timestamp)Timestamp.valueOf("2022-05-17 16:25:53")));
    }

    private void testLiteral(PredicateLeaf.Type hiveType, Object hiveLiteral, DataType flinkType, Object flinkLiteral) {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.equals("a", hiveType, hiveLiteral).build();
        SearchArgumentToPredicateConverter converter = new SearchArgumentToPredicateConverter(sarg, Collections.singletonList("a"), Collections.singletonList(flinkType), null);
        Predicate expected = new PredicateBuilder(RowType.of((DataType[])new DataType[]{flinkType}, (String[])new String[]{"a"})).equal(0, flinkLiteral);
        Predicate actual = converter.convert().orElse(null);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testEqual() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).build();
        Predicate expected = BUILDER.equal(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotEqual() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().build();
        Predicate expected = BUILDER.notEqual(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testLessThan() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.lessThan("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).build();
        Predicate expected = BUILDER.lessThan(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testGreaterOrEqual() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().lessThan("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().build();
        Predicate expected = BUILDER.greaterOrEqual(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testLessOrEqual() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.lessThanEquals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).build();
        Predicate expected = BUILDER.lessOrEqual(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testGreaterThan() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().lessThanEquals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().build();
        Predicate expected = BUILDER.greaterThan(1, (Object)100L);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testIn() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.in("f_bigint", PredicateLeaf.Type.LONG, new Object[]{100L, 200L, 300L}).build();
        Predicate expected = BUILDER.in(1, Arrays.asList(100L, 200L, 300L));
        this.assertExpected(sarg, expected);
        builder = SearchArgumentFactory.newBuilder();
        Object[] literals = new Object[30];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = (long)i * 100L;
        }
        sarg = builder.in("f_bigint", PredicateLeaf.Type.LONG, literals).build();
        expected = BUILDER.in(1, Arrays.asList(literals));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testInNull() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.in("f_bigint", PredicateLeaf.Type.LONG, new Object[]{100L, null, 300L}).build();
        Predicate expected = BUILDER.in(1, Arrays.asList(100L, null, 300L));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotIn() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().in("f_bigint", PredicateLeaf.Type.LONG, new Object[]{100L, 200L, 300L}).end().build();
        Predicate expected = BUILDER.notIn(1, Arrays.asList(100L, 200L, 300L));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotInNull() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().in("f_bigint", PredicateLeaf.Type.LONG, new Object[]{100L, null, 300L}).end().build();
        Predicate expected = BUILDER.notIn(1, Arrays.asList(100L, null, 300L));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testLargeIn() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        Object[] literals = new Object[30];
        literals[0] = null;
        for (int i = 1; i < literals.length; ++i) {
            literals[i] = (long)i * 100L;
        }
        SearchArgument sarg = builder.in("f_bigint", PredicateLeaf.Type.LONG, literals).build();
        Predicate expected = BUILDER.in(1, Arrays.asList(literals));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testLargeNotIn() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        Object[] literals = new Object[30];
        literals[0] = null;
        for (int i = 1; i < literals.length; ++i) {
            literals[i] = (long)i * 100L;
        }
        SearchArgument sarg = builder.startNot().in("f_bigint", PredicateLeaf.Type.LONG, literals).end().build();
        Predicate expected = BUILDER.notIn(1, Arrays.asList(literals));
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testBetween() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.between("f_bigint", PredicateLeaf.Type.LONG, (Object)100L, (Object)200L).build();
        Predicate expected = PredicateBuilder.and((Predicate[])new Predicate[]{BUILDER.greaterOrEqual(1, (Object)100L), BUILDER.lessOrEqual(1, (Object)200L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotBetween() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().between("f_bigint", PredicateLeaf.Type.LONG, (Object)100L, (Object)200L).end().build();
        Predicate expected = PredicateBuilder.or((Predicate[])new Predicate[]{BUILDER.lessThan(1, (Object)100L), BUILDER.greaterThan(1, (Object)200L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testIsNull() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.isNull("f_bigint", PredicateLeaf.Type.LONG).build();
        Predicate expected = BUILDER.isNull(1);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testIsNotNull() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().isNull("f_bigint", PredicateLeaf.Type.LONG).end().build();
        Predicate expected = BUILDER.isNotNull(1);
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testOr() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startOr().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).equals("f_bigint", PredicateLeaf.Type.LONG, (Object)200L).equals("f_bigint", PredicateLeaf.Type.LONG, (Object)300L).end().build();
        Predicate expected = PredicateBuilder.or((Predicate[])new Predicate[]{BUILDER.equal(1, (Object)100L), BUILDER.equal(1, (Object)200L), BUILDER.equal(1, (Object)300L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotOr() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().startOr().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).equals("f_bigint", PredicateLeaf.Type.LONG, (Object)200L).equals("f_bigint", PredicateLeaf.Type.LONG, (Object)300L).end().end().build();
        Predicate expected = PredicateBuilder.and((Predicate[])new Predicate[]{BUILDER.notEqual(1, (Object)100L), BUILDER.notEqual(1, (Object)200L), BUILDER.notEqual(1, (Object)300L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testAnd() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startAnd().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)200L).end().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)300L).end().end().build();
        Predicate expected = PredicateBuilder.and((Predicate[])new Predicate[]{BUILDER.notEqual(1, (Object)100L), BUILDER.notEqual(1, (Object)200L), BUILDER.notEqual(1, (Object)300L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testNotAnd() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startNot().startAnd().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)200L).end().startNot().equals("f_bigint", PredicateLeaf.Type.LONG, (Object)300L).end().end().end().build();
        Predicate expected = PredicateBuilder.or((Predicate[])new Predicate[]{BUILDER.equal(1, (Object)100L), BUILDER.equal(1, (Object)200L), BUILDER.equal(1, (Object)300L)});
        this.assertExpected(sarg, expected);
    }

    @Test
    public void testUnsupported() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.nullSafeEquals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).build();
        this.assertExpected(sarg, null);
    }

    @Test
    public void testKeepPartialResult() {
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        SearchArgument sarg = builder.startAnd().startNot().nullSafeEquals("f_bigint", PredicateLeaf.Type.LONG, (Object)100L).end().lessThanEquals("f_bigint", PredicateLeaf.Type.LONG, (Object)200L).startNot().lessThan("f_bigint", PredicateLeaf.Type.LONG, (Object)0L).end().end().build();
        Predicate expected = PredicateBuilder.and((Predicate[])new Predicate[]{BUILDER.lessOrEqual(1, (Object)200L), BUILDER.greaterOrEqual(1, (Object)0L)});
        this.assertExpected(sarg, expected);
    }

    private void assertExpected(SearchArgument sarg, Predicate expected) {
        SearchArgumentToPredicateConverter converter = new SearchArgumentToPredicateConverter(sarg, COLUMN_NAMES, COLUMN_TYPES, null);
        Predicate actual = converter.convert().orElse(null);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

