/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.io.DataFileTestDataGenerator;
import org.apache.paimon.table.source.DataSplit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PaimonInputSplitTest {
    @TempDir
    Path tempDir;

    @Test
    public void testWriteAndRead() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        DataFileTestDataGenerator gen = DataFileTestDataGenerator.builder().numBuckets(1).build();
        ArrayList<DataFileTestDataGenerator.Data> generated = new ArrayList<DataFileTestDataGenerator.Data>();
        for (int i = random.nextInt(100) + 1; i > 0; --i) {
            generated.add(gen.next());
        }
        BinaryRow wantedPartition = ((DataFileTestDataGenerator.Data)generated.get((int)0)).partition;
        DataSplit dataSplit = DataSplit.builder().withSnapshot(ThreadLocalRandom.current().nextLong(100L)).withPartition(wantedPartition).withBucket(0).withDataFiles(generated.stream().filter(d -> d.partition.equals((Object)wantedPartition)).map(d -> d.meta).collect(Collectors.toList())).build();
        PaimonInputSplit split = new PaimonInputSplit(this.tempDir.toString(), dataSplit);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        split.write((DataOutput)output);
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream input = new DataInputStream(bais);
        PaimonInputSplit actual = new PaimonInputSplit();
        actual.readFields((DataInput)input);
        Assertions.assertThat((Object)actual).isEqualTo((Object)split);
    }
}

