/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.hive.RandomGenericRowDataGenerator;
import org.apache.paimon.hive.objectinspector.PaimonInternalRowObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonInternalRowObjectInspectorTest {
    @Test
    public void testGetStructFieldRef() {
        PaimonInternalRowObjectInspector oi = new PaimonInternalRowObjectInspector(RandomGenericRowDataGenerator.FIELD_NAMES, RandomGenericRowDataGenerator.LOGICAL_TYPES, RandomGenericRowDataGenerator.FIELD_COMMENTS);
        List structFields = oi.getAllStructFieldRefs();
        List<ObjectInspector.Category> expectedOiCategories = Arrays.asList(ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.PRIMITIVE, ObjectInspector.Category.LIST, ObjectInspector.Category.MAP);
        for (int i = 0; i < RandomGenericRowDataGenerator.FIELD_NAMES.size(); ++i) {
            StructField structField = oi.getStructFieldRef(RandomGenericRowDataGenerator.FIELD_NAMES.get(i));
            Assertions.assertThat((Object)structField).isSameAs(structFields.get(i));
            Assertions.assertThat((String)structField.getFieldName()).isEqualTo(RandomGenericRowDataGenerator.FIELD_NAMES.get(i));
            Assertions.assertThat((int)structField.getFieldID()).isEqualTo(i);
            Assertions.assertThat((String)structField.getFieldComment()).isEqualTo(RandomGenericRowDataGenerator.FIELD_COMMENTS.get(i));
            ObjectInspector fieldOi = structField.getFieldObjectInspector();
            Assertions.assertThat((String)fieldOi.getTypeName()).isEqualTo(RandomGenericRowDataGenerator.TYPE_NAMES.get(i));
            Assertions.assertThat((Comparable)fieldOi.getCategory()).isEqualTo((Object)expectedOiCategories.get(i));
        }
    }

    @Test
    public void testGetTypeName() {
        PaimonInternalRowObjectInspector oi = new PaimonInternalRowObjectInspector(RandomGenericRowDataGenerator.FIELD_NAMES, RandomGenericRowDataGenerator.LOGICAL_TYPES, RandomGenericRowDataGenerator.FIELD_COMMENTS);
        String expected = "struct<" + String.join((CharSequence)",", Arrays.asList("f_boolean:boolean", "f_byte:tinyint", "f_short:smallint", "f_int:int", "f_long:bigint", "f_float:float", "f_double:double", "f_decimal_5_3:decimal(5,3)", "f_decimal_28_6:decimal(28,6)", "f_char_10:char(10)", "f_varchar_10:varchar(10)", "f_string:string", "f_binary:binary", "f_date:date", "f_time:string", "f_timestamp:timestamp", "f_list_long:array<bigint>", "f_map_string_int:map<string,int>")) + ">";
        Assertions.assertThat((String)oi.getTypeName()).isEqualTo(expected);
    }

    @Test
    public void testGetStructFieldData() {
        PaimonInternalRowObjectInspector oi = new PaimonInternalRowObjectInspector(RandomGenericRowDataGenerator.FIELD_NAMES, RandomGenericRowDataGenerator.LOGICAL_TYPES, RandomGenericRowDataGenerator.FIELD_COMMENTS);
        GenericRow rowData = RandomGenericRowDataGenerator.generate();
        List structFieldsData = oi.getStructFieldsDataAsList((Object)rowData);
        for (int i = 0; i < structFieldsData.size(); ++i) {
            Assertions.assertThat(structFieldsData.get(i)).isEqualTo(rowData.getField(i));
        }
        List structFields = oi.getAllStructFieldRefs();
        for (int i = 0; i < structFields.size(); ++i) {
            Assertions.assertThat((Object)oi.getStructFieldData((Object)rowData, (StructField)structFields.get(i))).isEqualTo(rowData.getField(i));
        }
    }
}

