/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.hive.objectinspector.PaimonMapObjectInspector;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonMapObjectInspectorTest {
    @Test
    public void testCategoryAndTypeName() {
        PaimonMapObjectInspector oi = new PaimonMapObjectInspector((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT());
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.MAP);
        Assertions.assertThat((String)oi.getTypeName()).isEqualTo("map<string,bigint>");
    }

    @Test
    public void testGetMapAndValue() {
        PaimonMapObjectInspector oi = new PaimonMapObjectInspector((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT());
        BinaryString[] keyArray = new BinaryString[]{BinaryString.fromString((String)"Hi"), BinaryString.fromString((String)"Hello"), BinaryString.fromString((String)"Test")};
        Long[] valueArray = new Long[]{1L, null, 2L};
        HashMap<BinaryString, Long> javaMap = new HashMap<BinaryString, Long>();
        for (int i = 0; i < keyArray.length; ++i) {
            javaMap.put(keyArray[i], valueArray[i]);
        }
        GenericMap mapData = new GenericMap(javaMap);
        Assertions.assertThat((int)oi.getMapSize((Object)mapData)).isEqualTo(3);
        for (int i = 0; i < keyArray.length; ++i) {
            Assertions.assertThat((Object)oi.getMapValueElement((Object)mapData, (Object)keyArray[i])).isEqualTo((Object)valueArray[i]);
        }
        Assertions.assertThat((Object)oi.getMapValueElement((Object)mapData, (Object)BinaryString.fromString((String)"NotKey"))).isNull();
        Assertions.assertThat((Object)oi.getMapValueElement((Object)mapData, null)).isNull();
        Assertions.assertThat((Map)oi.getMap((Object)mapData)).isEqualTo(javaMap);
        Assertions.assertThat((int)oi.getMapSize(null)).isEqualTo(-1);
        Assertions.assertThat((Object)oi.getMapValueElement(null, (Object)BinaryString.fromString((String)"Hi"))).isNull();
        Assertions.assertThat((Map)oi.getMap(null)).isNull();
    }
}

