/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonTimestampObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonTimestampObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonTimestampObjectInspector oi = new PaimonTimestampObjectInspector();
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(Timestamp.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(TimestampWritable.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonTimestampObjectInspector oi = new PaimonTimestampObjectInspector();
        LocalDateTime local = LocalDateTime.of(2022, 4, 27, 15, 0, 0, 100000000);
        org.apache.paimon.data.Timestamp input = org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)local);
        Assertions.assertThat((String)oi.getPrimitiveJavaObject((Object)input).toString()).isEqualTo("2022-04-27 15:00:00.1");
        Assertions.assertThat((Date)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonTimestampObjectInspector oi = new PaimonTimestampObjectInspector();
        LocalDateTime local = LocalDateTime.of(2022, 4, 27, 15, 0, 0, 100000000);
        org.apache.paimon.data.Timestamp input = org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)local);
        Assertions.assertThat((String)oi.getPrimitiveWritableObject((Object)input).getTimestamp().toString()).isEqualTo("2022-04-27 15:00:00.1");
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonTimestampObjectInspector oi = new PaimonTimestampObjectInspector();
        org.apache.paimon.data.Timestamp input1 = org.apache.paimon.data.Timestamp.fromEpochMillis((long)10007L);
        Object copy1 = oi.copyObject((Object)input1);
        Assertions.assertThat((Object)copy1).isEqualTo((Object)input1);
        Timestamp input2 = new Timestamp(10007L);
        Object copy2 = oi.copyObject((Object)input2);
        Assertions.assertThat((Object)copy2).isEqualTo((Object)input2);
        Assertions.assertThat((Object)copy2).isNotSameAs((Object)input2);
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

