/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferCompressingStream
implements Closeable,
Flushable {
    private ByteBuffer target;
    private final long stream;
    private int consumed = 0;
    private int produced = 0;
    private boolean closed = false;
    private boolean initialized = false;
    private boolean finalize = true;
    private int level = 3;
    private byte[] dict = null;
    private ZstdDictCompress fastDict = null;

    protected ByteBuffer flushBuffer(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDirectBufferCompressingStream(ByteBuffer byteBuffer, int n) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        ZstdDirectBufferCompressingStream zstdDirectBufferCompressingStream = this;
        synchronized (zstdDirectBufferCompressingStream) {
            this.target = byteBuffer;
            this.level = n;
            this.stream = ZstdDirectBufferCompressingStream.createCStream();
        }
    }

    public static int recommendedOutputBufferSize() {
        return (int)ZstdDirectBufferCompressingStream.recommendedCOutSize();
    }

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3);

    private native int initCStreamWithDict(long var1, byte[] var3, int var4, int var5);

    private native int initCStreamWithFastDict(long var1, ZstdDictCompress var3);

    private native int compressDirectByteBuffer(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private native int flushStream(long var1, ByteBuffer var3, int var4, int var5);

    private native int endStream(long var1, ByteBuffer var3, int var4, int var5);

    public synchronized ZstdDirectBufferCompressingStream setDict(byte[] byArray) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = byArray;
        this.fastDict = null;
        return this;
    }

    public synchronized ZstdDirectBufferCompressingStream setDict(ZstdDictCompress zstdDictCompress) throws IOException {
        if (this.initialized) {
            throw new IOException("Change of parameter on initialized stream");
        }
        this.dict = null;
        this.fastDict = zstdDictCompress;
        return this;
    }

    public void setFinalize(boolean bl) {
        this.finalize = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compress(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.initialized) {
            n = 0;
            ZstdDictCompress zstdDictCompress = this.fastDict;
            if (zstdDictCompress != null) {
                zstdDictCompress.acquireSharedLock();
                try {
                    n = this.initCStreamWithFastDict(this.stream, zstdDictCompress);
                }
                finally {
                    zstdDictCompress.releaseSharedLock();
                }
            } else {
                n = this.dict != null ? this.initCStreamWithDict(this.stream, this.dict, this.dict.length, this.level) : this.initCStream(this.stream, this.level);
            }
            if (Zstd.isError(n)) {
                throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(n));
            }
            this.initialized = true;
        }
        while (byteBuffer.hasRemaining()) {
            if (!this.target.hasRemaining()) {
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (!this.target.hasRemaining()) {
                    throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                }
            }
            if (Zstd.isError(n = this.compressDirectByteBuffer(this.stream, this.target, this.target.position(), this.target.remaining(), byteBuffer, byteBuffer.position(), byteBuffer.remaining()))) {
                throw new IOException("Compression error: " + Zstd.getErrorName(n));
            }
            this.target.position(this.target.position() + this.produced);
            byteBuffer.position(byteBuffer.position() + this.consumed);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (this.initialized) {
            int n;
            do {
                if (Zstd.isError(n = this.flushStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                    throw new IOException("Compression error: " + Zstd.getErrorName(n));
                }
                this.target.position(this.target.position() + this.produced);
                this.target = this.flushBuffer(this.target);
                if (!this.target.isDirect()) {
                    throw new IllegalArgumentException("Target buffer should be a direct buffer");
                }
                if (n <= 0 || this.target.hasRemaining()) continue;
                throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
            } while (n > 0);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.initialized) {
                    int n;
                    do {
                        if (Zstd.isError(n = this.endStream(this.stream, this.target, this.target.position(), this.target.remaining()))) {
                            throw new IOException("Compression error: " + Zstd.getErrorName(n));
                        }
                        this.target.position(this.target.position() + this.produced);
                        this.target = this.flushBuffer(this.target);
                        if (!this.target.isDirect()) {
                            throw new IllegalArgumentException("Target buffer should be a direct buffer");
                        }
                        if (n <= 0 || this.target.hasRemaining()) continue;
                        throw new IOException("The target buffer has no more space, even after flushing, and there are still bytes to compress");
                    } while (n > 0);
                }
            }
            finally {
                ZstdDirectBufferCompressingStream.freeCStream(this.stream);
                this.closed = true;
                this.initialized = false;
                this.target = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.finalize) {
            this.close();
        }
    }

    static {
        Native.load();
    }
}

