/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.orc.ThreadLocalClassLoaderConfiguration;
import org.apache.paimon.format.orc.writer.OrcBulkWriter;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.shade.org.apache.orc.OrcConf;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.impl.PhysicalFsWriter;
import org.apache.paimon.shade.org.apache.orc.impl.WriterImpl;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.paimon.utils.Preconditions;

public class OrcWriterFactory
implements FormatWriterFactory {
    private final Vectorizer<InternalRow> vectorizer;
    private final Properties writerProperties;
    private final Map<String, String> confMap;
    private OrcFile.WriterOptions writerOptions;
    private final CoreOptions coreOptions;

    public OrcWriterFactory(Vectorizer<InternalRow> vectorizer) {
        this(vectorizer, new Configuration());
    }

    public OrcWriterFactory(Vectorizer<InternalRow> vectorizer, Configuration configuration) {
        this(vectorizer, new Properties(), configuration);
    }

    public OrcWriterFactory(Vectorizer<InternalRow> vectorizer, Properties writerProperties, Configuration configuration) {
        this.vectorizer = Preconditions.checkNotNull(vectorizer);
        this.writerProperties = Preconditions.checkNotNull(writerProperties);
        this.confMap = new HashMap<String, String>();
        for (Map.Entry entry : configuration) {
            this.confMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.coreOptions = new CoreOptions(this.confMap);
    }

    @Override
    public FormatWriter create(PositionOutputStream out, String compression) throws IOException {
        if (null != compression) {
            this.writerProperties.setProperty(OrcConf.COMPRESS.getAttribute(), compression);
        }
        OrcFile.WriterOptions opts = this.getWriterOptions();
        opts.physicalWriter(new PhysicalFsWriter(new FSDataOutputStream(out, null){

            public void close() throws IOException {
            }
        }, opts, new WriterEncryptionVariant[0]));
        Path unusedPath = new Path(UUID.randomUUID().toString());
        return new OrcBulkWriter(this.vectorizer, new WriterImpl(null, unusedPath, opts), out, this.coreOptions.orcWriteBatch());
    }

    @VisibleForTesting
    protected OrcFile.WriterOptions getWriterOptions() {
        if (null == this.writerOptions) {
            ThreadLocalClassLoaderConfiguration conf = new ThreadLocalClassLoaderConfiguration();
            for (Map.Entry<String, String> entry : this.confMap.entrySet()) {
                conf.set(entry.getKey(), entry.getValue());
            }
            this.writerOptions = OrcFile.writerOptions(this.writerProperties, conf);
            this.writerOptions.setSchema(this.vectorizer.getSchema());
        }
        return this.writerOptions;
    }
}

