/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.paimon.hive.LocationKeyExtractor;
import org.apache.paimon.hive.PaimonMetaHook;
import org.apache.paimon.hive.PaimonSerDe;
import org.apache.paimon.hive.mapred.PaimonInputFormat;
import org.apache.paimon.hive.mapred.PaimonOutputCommitter;
import org.apache.paimon.hive.mapred.PaimonOutputFormat;

public class PaimonStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final String MAPRED_OUTPUT_COMMITTER = "mapred.output.committer.class";
    private static final String PAIMON_WRITE = "paimon.write";
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return PaimonInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return PaimonOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return PaimonSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new PaimonMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        Properties properties = tableDesc.getProperties();
        map.put("paimon.internal.location", LocationKeyExtractor.getPaimonLocation(this.conf, properties));
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        Properties properties = tableDesc.getProperties();
        map.put("paimon.internal.location", LocationKeyExtractor.getPaimonLocation(this.conf, properties));
        map.put(MAPRED_OUTPUT_COMMITTER, PaimonOutputCommitter.class.getName());
        map.put(PAIMON_WRITE, Boolean.TRUE.toString());
        properties.put(PAIMON_WRITE, Boolean.TRUE.toString());
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        if (tableDesc != null && tableDesc.getProperties() != null && tableDesc.getProperties().get(PAIMON_WRITE) != null) {
            jobConf.set(MAPRED_OUTPUT_COMMITTER, PaimonOutputCommitter.class.getName());
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposed.residualPredicate = (ExprNodeGenericFuncDesc)predicate;
        decomposed.pushedPredicate = (ExprNodeGenericFuncDesc)predicate;
        return decomposed;
    }
}

