/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.hive.mapred.PaimonRecordReader;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.tag.TagPreview;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.PartitionPathUtils;

public class PaimonInputFormat
implements InputFormat<Void, RowDataContainer> {
    public InputSplit[] getSplits(JobConf jobConf, int numSplits) {
        FileStoreTable table = HiveUtils.createFileStoreTable(jobConf);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        HiveUtils.createPredicate(table.schema(), jobConf, false).ifPresent(predicates::add);
        String locations = jobConf.get("mapreduce.input.fileinputformat.inputdir");
        String tagToPartField = table.coreOptions().tagToPartitionField();
        TagPreview tagPreview = TagPreview.create(table.coreOptions());
        ArrayList splits = new ArrayList();
        for (String location : locations.split(",")) {
            InnerTableScan scan;
            if (tagToPartField != null) {
                String tag = PaimonInputFormat.extractTagName(location, tagToPartField);
                Map<String, String> dynamicOptions = tagPreview == null ? Collections.singletonMap(CoreOptions.SCAN_TAG_NAME.key(), tag) : tagPreview.timeTravel(table, tag);
                scan = table.copy((Map)dynamicOptions).newScan();
                if (predicates.size() > 0) {
                    scan.withFilter(PredicateBuilder.and(predicates));
                }
            } else {
                ArrayList<Predicate> predicatePerPartition = new ArrayList<Predicate>(predicates);
                this.createPartitionPredicate(table.schema().logicalRowType(), table.schema().partitionKeys(), location).ifPresent(predicatePerPartition::add);
                scan = table.newScan();
                if (predicatePerPartition.size() > 0) {
                    scan.withFilter(PredicateBuilder.and(predicatePerPartition));
                }
            }
            scan.plan().splits().forEach(split -> splits.add(new PaimonInputSplit(location, (DataSplit)split)));
        }
        return splits.toArray(new InputSplit[0]);
    }

    private Optional<Predicate> createPartitionPredicate(RowType rowType, List<String> partitionKeys, String partitionDir) {
        HashSet<String> partitionKeySet = new HashSet<String>(partitionKeys);
        LinkedHashMap<String, String> partition = new LinkedHashMap<String, String>();
        for (String s : partitionDir.split("/")) {
            String[] kv;
            if ((s = s.trim()).isEmpty() || (kv = s.split("=")).length != 2 || !partitionKeySet.contains(kv[0])) continue;
            partition.put(kv[0], kv[1]);
        }
        if (partition.isEmpty() || partition.size() != partitionKeys.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(PredicateBuilder.partition(partition, rowType));
    }

    public RecordReader<Void, RowDataContainer> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        FileStoreTable table = HiveUtils.createFileStoreTable(jobConf);
        PaimonInputSplit split = (PaimonInputSplit)inputSplit;
        ReadBuilder readBuilder = table.newReadBuilder();
        HiveUtils.createPredicate(table.schema(), jobConf, true).ifPresent(readBuilder::withFilter);
        List<String> paimonColumns = table.schema().fieldNames();
        return new PaimonRecordReader(readBuilder, split, paimonColumns, this.getHiveColumns(jobConf).orElse(paimonColumns), Arrays.asList(this.getSelectedColumns(jobConf)), table.coreOptions().tagToPartitionField());
    }

    private Optional<List<String>> getHiveColumns(JobConf jobConf) {
        String columns = jobConf.get("schema.evolution.columns");
        if (columns == null) {
            columns = jobConf.get("columns");
        }
        String delimiter = jobConf.get("column.name.delimite", String.valueOf(','));
        if (columns == null || delimiter == null) {
            return Optional.empty();
        }
        return Optional.of(Arrays.asList(columns.split(delimiter)));
    }

    private String[] getSelectedColumns(JobConf jobConf) {
        return (String[])Arrays.stream(ColumnProjectionUtils.getReadColumnNames((Configuration)jobConf)).distinct().toArray(String[]::new);
    }

    public static String extractTagName(String location, String tagToPartField) {
        LinkedHashMap<String, String> partSpec = PartitionPathUtils.extractPartitionSpecFromPath(new Path(location));
        return partSpec.get(tagToPartField);
    }
}

