/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.hive.LocationKeyExtractor;
import org.apache.paimon.hive.SearchArgumentToPredicateConverter;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;

public class HiveUtils {
    public static FileStoreTable createFileStoreTable(JobConf jobConf) {
        Options options = HiveUtils.extractCatalogConfig((Configuration)jobConf);
        options.set(CoreOptions.PATH, LocationKeyExtractor.getPaimonLocation(jobConf));
        CatalogContext catalogContext = CatalogContext.create(options, (Configuration)jobConf);
        return FileStoreTableFactory.create(catalogContext);
    }

    public static Optional<Predicate> createPredicate(TableSchema tableSchema, JobConf jobConf, boolean limitToReadColumnNames) {
        String tagToPartField;
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((Configuration)jobConf);
        if (sarg == null) {
            return Optional.empty();
        }
        Set<String> readColumnNames = null;
        if (limitToReadColumnNames) {
            readColumnNames = Arrays.stream(ColumnProjectionUtils.getReadColumnNames((Configuration)jobConf)).collect(Collectors.toSet());
        }
        if ((tagToPartField = tableSchema.options().get(CoreOptions.METASTORE_TAG_TO_PARTITION.key())) != null) {
            if (readColumnNames == null) {
                readColumnNames = new HashSet<String>(tableSchema.fieldNames());
            }
            readColumnNames.remove(tagToPartField);
        }
        SearchArgumentToPredicateConverter converter = new SearchArgumentToPredicateConverter(sarg, tableSchema.fieldNames(), tableSchema.logicalRowType().getFieldTypes(), readColumnNames);
        return converter.convert();
    }

    public static Options extractCatalogConfig(Configuration hiveConf) {
        HashMap<String, String> configMap = hiveConf == null ? new HashMap() : OptionsUtils.convertToPropertiesPrefixKey((Iterable<Map.Entry<String, String>>)hiveConf, "paimon.", v -> !"NULL".equalsIgnoreCase((String)v));
        return Options.fromMap(configMap);
    }
}

