/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.statistics.FullFieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public interface PartitionPredicate {
    public boolean test(BinaryRow var1);

    public boolean test(long var1, FieldStats[] var3);

    public static PartitionPredicate fromPredicate(RowType partitionType, Predicate predicate) {
        return new DefaultPartitionPredicate(new RowDataToObjectArrayConverter(partitionType), predicate);
    }

    public static PartitionPredicate fromMultiple(RowType partitionType, List<BinaryRow> partitions) {
        return new MultiplePartitionPredicate(new RowDataToObjectArrayConverter(partitionType), new HashSet<BinaryRow>(partitions));
    }

    public static class MultiplePartitionPredicate
    implements PartitionPredicate {
        private final Set<BinaryRow> partitions;
        private final Predicate[] min;
        private final Predicate[] max;

        private MultiplePartitionPredicate(RowDataToObjectArrayConverter converter, Set<BinaryRow> partitions) {
            this.partitions = partitions;
            RowType partitionType = converter.rowType();
            int fieldNum = partitionType.getFieldCount();
            Serializer[] serializers = new Serializer[fieldNum];
            FullFieldStatsCollector[] collectors = new FullFieldStatsCollector[fieldNum];
            this.min = new Predicate[fieldNum];
            this.max = new Predicate[fieldNum];
            for (int i = 0; i < fieldNum; ++i) {
                serializers[i] = InternalSerializers.create(partitionType.getTypeAt(i));
                collectors[i] = new FullFieldStatsCollector();
            }
            for (BinaryRow part : partitions) {
                Object[] fields = converter.convert(part);
                for (int i = 0; i < fields.length; ++i) {
                    collectors[i].collect(fields[i], serializers[i]);
                }
            }
            PredicateBuilder builder = new PredicateBuilder(partitionType);
            for (int i = 0; i < collectors.length; ++i) {
                FieldStats stats = collectors[i].result();
                this.min[i] = builder.greaterOrEqual(i, stats.minValue());
                this.max[i] = builder.lessOrEqual(i, stats.maxValue());
            }
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.partitions.contains(part);
        }

        @Override
        public boolean test(long rowCount, FieldStats[] fieldStats) {
            if (fieldStats.length == 0) {
                return true;
            }
            for (int i = 0; i < fieldStats.length; ++i) {
                if (this.min[i].test(rowCount, fieldStats) && this.max[i].test(rowCount, fieldStats)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DefaultPartitionPredicate
    implements PartitionPredicate {
        private final RowDataToObjectArrayConverter converter;
        private final Predicate predicate;

        private DefaultPartitionPredicate(RowDataToObjectArrayConverter converter, Predicate predicate) {
            this.converter = converter;
            this.predicate = predicate;
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.predicate.test(this.converter.convert(part));
        }

        @Override
        public boolean test(long rowCount, FieldStats[] fieldStats) {
            return this.predicate.test(rowCount, fieldStats);
        }
    }
}

