/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageSerializer
implements VersionedSerializer<CommitMessage> {
    private static final int CURRENT_VERSION = 2;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();
    private final IndexFileMetaSerializer indexEntrySerializer = new IndexFileMetaSerializer();

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public byte[] serialize(CommitMessage obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(obj, view);
        return out.toByteArray();
    }

    public void serializeList(List<CommitMessage> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (CommitMessage commitMessage : list) {
            this.serialize(commitMessage, view);
        }
    }

    private void serialize(CommitMessage obj, DataOutputView view) throws IOException {
        CommitMessageImpl message = (CommitMessageImpl)obj;
        SerializationUtils.serializeBinaryRow(obj.partition(), view);
        view.writeInt(obj.bucket());
        this.dataFileSerializer.serializeList(message.newFilesIncrement().newFiles(), view);
        this.dataFileSerializer.serializeList(message.newFilesIncrement().changelogFiles(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactBefore(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactAfter(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().changelogFiles(), view);
        this.indexEntrySerializer.serializeList(message.indexIncrement().newIndexFiles(), view);
    }

    @Override
    public CommitMessage deserialize(int version, byte[] serialized) throws IOException {
        this.checkVersion(version);
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(view);
    }

    public List<CommitMessage> deserializeList(int version, DataInputView view) throws IOException {
        this.checkVersion(version);
        int length = view.readInt();
        ArrayList<CommitMessage> list = new ArrayList<CommitMessage>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(view));
        }
        return list;
    }

    private void checkVersion(int version) {
        if (version != 2) {
            throw new UnsupportedOperationException("Expecting FileCommittable version to be 2, but found " + version + ".\nFileCommittable is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
    }

    private CommitMessage deserialize(DataInputView view) throws IOException {
        return new CommitMessageImpl(SerializationUtils.deserializeBinaryRow(view), view.readInt(), new NewFilesIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new CompactIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new IndexIncrement(this.indexEntrySerializer.deserializeList(view)));
    }
}

