/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class ContinuousFromSnapshotStartingScanner
extends AbstractStartingScanner {
    private final boolean changelogAsFollowup;
    private final boolean changelogDecoupled;

    public ContinuousFromSnapshotStartingScanner(SnapshotManager snapshotManager, long snapshotId, boolean changelogAsFollowup, boolean changelogDecoupled) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotId;
        this.changelogDecoupled = changelogDecoupled;
        this.changelogAsFollowup = changelogAsFollowup;
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long earliestId = this.getEarliestId();
        if (earliestId == null) {
            return new StartingScanner.NoSnapshot();
        }
        return new StartingScanner.NextSnapshot(Math.max(this.startingSnapshotId, earliestId));
    }

    private Long getEarliestId() {
        Long earliestChangelogId;
        Long earliestId = this.changelogAsFollowup && this.changelogDecoupled ? ((earliestChangelogId = this.snapshotManager.earliestLongLivedChangelogId()) == null ? this.snapshotManager.earliestSnapshotId() : earliestChangelogId) : this.snapshotManager.earliestSnapshotId();
        return earliestId;
    }
}

