/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.InternalRowPartitionComputer;

public class CatalogUtils {
    public static Path path(String warehouse, String database, String table) {
        return new Path(String.format("%s/%s.db/%s", warehouse, database, table));
    }

    public static String stringifyPath(String warehouse, String database, String table) {
        return String.format("%s/%s.db/%s", warehouse, database, table);
    }

    public static String warehouse(String path) {
        return new Path(path).getParent().getParent().toString();
    }

    public static String database(Path path) {
        return SchemaManager.identifierFromPath(path.toString(), false).getDatabaseName();
    }

    public static String database(String path) {
        return SchemaManager.identifierFromPath(path, false).getDatabaseName();
    }

    public static String table(Path path) {
        return SchemaManager.identifierFromPath(path.toString(), false).getObjectName();
    }

    public static String table(String path) {
        return SchemaManager.identifierFromPath(path, false).getObjectName();
    }

    public static Map<String, String> tableDefaultOptions(Map<String, String> options) {
        return OptionsUtils.convertToPropertiesPrefixKey(options, "table-default.");
    }

    public static List<Partition> listPartitionsFromFileSystem(Table table) {
        Options options = Options.fromMap(table.options());
        InternalRowPartitionComputer computer = new InternalRowPartitionComputer(options.get(CoreOptions.PARTITION_DEFAULT_NAME), table.rowType().project(table.partitionKeys()), table.partitionKeys().toArray(new String[0]), options.get(CoreOptions.PARTITION_GENERATE_LEGCY_NAME));
        List<PartitionEntry> partitionEntries = table.newReadBuilder().newScan().listPartitionEntries();
        ArrayList<Partition> partitions = new ArrayList<Partition>(partitionEntries.size());
        for (PartitionEntry entry : partitionEntries) {
            partitions.add(new Partition(computer.generatePartValues(entry.partition()), entry.recordCount(), entry.fileSizeInBytes(), entry.fileCount(), entry.lastFileCreationTime()));
        }
        return partitions;
    }
}

