/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen.codesplit;

import java.util.Optional;
import org.apache.paimon.codegen.codesplit.BlockStatementRewriter;
import org.apache.paimon.codegen.codesplit.DeclarationRewriter;
import org.apache.paimon.codegen.codesplit.FunctionSplitter;
import org.apache.paimon.codegen.codesplit.MemberFieldRewriter;
import org.apache.paimon.codegen.codesplit.ReturnValueRewriter;
import org.apache.paimon.utils.Preconditions;

public class JavaCodeSplitter {
    public static String split(String code, int maxMethodLength, int maxClassMemberCount) {
        try {
            return JavaCodeSplitter.splitImpl(code, maxMethodLength, maxClassMemberCount);
        }
        catch (Throwable t) {
            throw new RuntimeException("JavaCodeSplitter failed. This is a bug. Please file an issue.", t);
        }
    }

    private static String splitImpl(String code, int maxMethodLength, int maxClassMemberCount) {
        Preconditions.checkArgument(code != null && !code.isEmpty(), "code cannot be empty");
        Preconditions.checkArgument(maxMethodLength > 0, "maxMethodLength must be greater than 0");
        Preconditions.checkArgument(maxClassMemberCount > 0, "maxClassMemberCount must be greater than 0");
        if (code.length() <= maxMethodLength) {
            return code;
        }
        String returnValueRewrittenCode = new ReturnValueRewriter(code, maxMethodLength).rewrite();
        return Optional.ofNullable(new DeclarationRewriter(returnValueRewrittenCode, maxMethodLength).rewrite()).map(text -> new BlockStatementRewriter((String)text, maxMethodLength).rewrite()).map(text -> new FunctionSplitter((String)text, maxMethodLength).rewrite()).map(text -> new MemberFieldRewriter((String)text, maxClassMemberCount).rewrite()).orElse(code);
    }
}

