/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.shade.org.apache.avro.file.DataFileStream;
import org.apache.paimon.shade.org.apache.avro.generic.GenericDatumReader;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class AvroSimpleStatsExtractor
implements SimpleStatsExtractor {
    private final RowType rowType;

    public AvroSimpleStatsExtractor(RowType rowType, SimpleColStatsCollector.Factory[] statsCollectors) {
        this.rowType = rowType;
        Preconditions.checkArgument(rowType.getFieldCount() == statsCollectors.length, "The stats collector is not aligned to write schema.");
    }

    @Override
    public SimpleColStats[] extract(FileIO fileIO, Path path, long length) throws IOException {
        return this.extractWithFileInfo(fileIO, path, length).getLeft();
    }

    @Override
    public Pair<SimpleColStats[], SimpleStatsExtractor.FileInfo> extractWithFileInfo(FileIO fileIO, Path path, long length) throws IOException {
        SeekableInputStream fileInputStream = fileIO.newInputStream(path);
        long rowCount = this.getRowCount(fileInputStream);
        return Pair.of(IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> new SimpleColStats(null, null, null)).toArray(SimpleColStats[]::new), new SimpleStatsExtractor.FileInfo(rowCount));
    }

    private long getRowCount(InputStream inStream) throws IOException {
        long count = 0L;
        try (DataFileStream streamReader = new DataFileStream(inStream, new GenericDatumReader());){
            while (streamReader.hasNext()) {
                count += streamReader.getBlockCount();
                streamReader.nextBlock();
            }
        }
        return count;
    }
}

