/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.hive.HiveSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public abstract class SchemaVisitor<P, R> {
    public static <P, T> T visit(HiveSchema schema, P partner, SchemaVisitor<P, T> visitor, PartnerAccessors<P> accessors) {
        return SchemaVisitor.visit(schema.rowType(), partner, visitor, accessors);
    }

    public static <P, T> T visit(DataType type, P partner, SchemaVisitor<P, T> visitor, PartnerAccessors<P> accessors) {
        switch (type.getTypeRoot()) {
            case ROW: {
                List<DataField> fields = ((RowType)type).getFields();
                ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
                for (DataField field : fields) {
                    P fieldPartner = partner != null ? (P)accessors.fieldPartner(partner, field.name()) : null;
                    T result = SchemaVisitor.visit(field.type(), fieldPartner, visitor, accessors);
                    results.add(result);
                }
                return visitor.rowType((RowType)type, partner, results);
            }
            case ARRAY: {
                ArrayType list = (ArrayType)type;
                DataType elementType = list.getElementType();
                P partnerElement = partner != null ? (P)accessors.listPartner(partner) : null;
                T result = SchemaVisitor.visit(elementType, partnerElement, visitor, accessors);
                return visitor.list(list, partner, result);
            }
            case MAP: {
                MapType map = (MapType)type;
                P keyPartner = partner != null ? (P)accessors.mapKeyPartner(partner) : null;
                T keyResult = SchemaVisitor.visit(map.getKeyType(), keyPartner, visitor, accessors);
                P valuePartner = partner != null ? (P)accessors.mapValuePartner(partner) : null;
                T valueResult = SchemaVisitor.visit(map.getValueType(), valuePartner, visitor, accessors);
                return visitor.map(map, partner, keyResult, valueResult);
            }
        }
        return visitor.primitive(type, partner);
    }

    public R rowType(RowType rowType, P partner, List<R> fieldResults) {
        return null;
    }

    public R list(ArrayType list, P partner, R elementResult) {
        return null;
    }

    public R map(MapType map, P partner, R keyResult, R valueResult) {
        return null;
    }

    public R primitive(DataType primitive, P partner) {
        return null;
    }

    public static interface PartnerAccessors<P> {
        public P fieldPartner(P var1, String var2);

        public P mapKeyPartner(P var1);

        public P mapValuePartner(P var1);

        public P listPartner(P var1);
    }
}

