/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.util.Objects;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobID;

public class TezUtil {
    private static final String TASK_ATTEMPT_ID_KEY = "mapred.task.id";
    private static final String TEZ_VERTEX_ID_HIVE = "hive.tez.vertex.index";
    private static final String TEZ_VERTEX_ID_DAG = "mapreduce.task.vertex.id";

    public static JobContext enrichContextWithVertexId(JobContext jobContext) {
        String vertexId = jobContext.getJobConf().get(TEZ_VERTEX_ID_DAG);
        if (vertexId != null) {
            JobID jobID = TezUtil.getJobIDWithVertexAppended(jobContext.getJobID(), vertexId);
            return new JobContextImpl(jobContext.getJobConf(), jobID, jobContext.getProgressible());
        }
        return jobContext;
    }

    public static TaskAttemptContext enrichContextWithAttemptWrapper(TaskAttemptContext taskAttemptContext) {
        TaskAttemptID wrapped = TezUtil.taskAttemptWrapper(taskAttemptContext.getTaskAttemptID());
        return new TaskAttemptContextImpl(taskAttemptContext.getJobConf(), wrapped);
    }

    public static TaskAttemptID taskAttemptWrapper(TaskAttemptID attemptID) {
        return new TaskAttemptWrapper(attemptID, "");
    }

    public static TaskAttemptID taskAttemptWrapper(JobConf jc) {
        return new TaskAttemptWrapper(TaskAttemptID.forName((String)jc.get(TASK_ATTEMPT_ID_KEY)), jc.get(TEZ_VERTEX_ID_HIVE));
    }

    private static JobID getJobIDWithVertexAppended(JobID jobID, String vertexId) {
        if (vertexId != null && !vertexId.isEmpty()) {
            return new JobID(jobID.getJtIdentifier() + vertexId, jobID.getId());
        }
        return jobID;
    }

    private TezUtil() {
    }

    private static class TaskAttemptWrapper
    extends TaskAttemptID {
        TaskAttemptWrapper(TaskAttemptID attemptID, String vertexId) {
            super(TezUtil.getJobIDWithVertexAppended((JobID)attemptID.getJobID(), vertexId).getJtIdentifier(), attemptID.getJobID().getId(), attemptID.getTaskType(), attemptID.getTaskID().getId(), attemptID.getId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TaskAttemptWrapper that = (TaskAttemptWrapper)((Object)o);
            return this.getId() == that.getId() && this.getTaskID().getId() == that.getTaskID().getId() && Objects.equals(this.getJobID(), that.getJobID());
        }

        public int hashCode() {
            return Objects.hash(this.getId(), this.getTaskID().getId(), this.getJobID());
        }
    }
}

