/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.hive.objectinspector.PaimonObjectInspectorFactory;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;
import org.apache.paimon.types.DataType;

public class PaimonMapObjectInspector
implements MapObjectInspector {
    private final ObjectInspector keyObjectInspector;
    private final ObjectInspector valueObjectInspector;
    private final InternalArray.ElementGetter keyGetter;
    private final InternalArray.ElementGetter valueGetter;

    public PaimonMapObjectInspector(DataType keyType, DataType valueType) {
        this.keyObjectInspector = PaimonObjectInspectorFactory.create(keyType);
        this.valueObjectInspector = PaimonObjectInspectorFactory.create(valueType);
        this.keyGetter = InternalArray.createElementGetter(keyType);
        this.valueGetter = InternalArray.createElementGetter(valueType);
    }

    public ObjectInspector getMapKeyObjectInspector() {
        return this.keyObjectInspector;
    }

    public ObjectInspector getMapValueObjectInspector() {
        return this.valueObjectInspector;
    }

    public Object getMapValueElement(Object o, Object key) {
        if (o == null || key == null) {
            return null;
        }
        InternalMap mapData = (InternalMap)o;
        InternalArray keyArrayData = mapData.keyArray();
        InternalArray valueArrayData = mapData.valueArray();
        for (int i = 0; i < mapData.size(); ++i) {
            Object k = this.keyGetter.getElementOrNull(keyArrayData, i);
            Object normalizedSearchKey = key;
            if (this.keyObjectInspector instanceof WriteableObjectInspector) {
                normalizedSearchKey = ((WriteableObjectInspector)this.keyObjectInspector).convert(key);
            }
            if (!Objects.equals(k, normalizedSearchKey)) continue;
            return this.valueGetter.getElementOrNull(valueArrayData, i);
        }
        return null;
    }

    public Map<?, ?> getMap(Object o) {
        if (o == null) {
            return null;
        }
        InternalMap mapData = (InternalMap)o;
        InternalArray keyArrayData = mapData.keyArray();
        InternalArray valueArrayData = mapData.valueArray();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < mapData.size(); ++i) {
            Object k = this.keyGetter.getElementOrNull(keyArrayData, i);
            Object v = this.valueGetter.getElementOrNull(valueArrayData, i);
            result.put(k, v);
        }
        return result;
    }

    public int getMapSize(Object o) {
        if (o == null) {
            return -1;
        }
        return ((InternalMap)o).size();
    }

    public String getTypeName() {
        return "map<" + this.keyObjectInspector.getTypeName() + "," + this.valueObjectInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }
}

