/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonVarcharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveVarcharObjectInspector,
WriteableObjectInspector {
    private final int len;

    public PaimonVarcharObjectInspector(int len) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)len));
        this.len = len;
    }

    public HiveVarchar getPrimitiveJavaObject(Object o) {
        return o == null ? null : new HiveVarchar(o.toString(), this.len);
    }

    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        HiveVarchar hiveVarchar = this.getPrimitiveJavaObject(o);
        return hiveVarchar == null ? null : new HiveVarcharWritable(hiveVarchar);
    }

    public Object copyObject(Object o) {
        if (o instanceof BinaryString) {
            return BinaryString.fromString(o.toString());
        }
        if (o instanceof HiveVarchar) {
            HiveVarchar hiveVarchar = (HiveVarchar)o;
            return new HiveVarchar(hiveVarchar, this.len);
        }
        return o;
    }

    @Override
    public BinaryString convert(Object value) {
        return value == null ? null : BinaryString.fromString(value.toString());
    }
}

